/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.entity.train;

import jp.ngt.ngtlib.item.ItemUtil;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.RTMResource;
import jp.ngt.rtm.entity.train.EntityTrainBase;
import jp.ngt.rtm.entity.train.parts.EntityArtillery;
import jp.ngt.rtm.entity.train.parts.EntityCargo;
import jp.ngt.rtm.entity.train.parts.EntityCargoWithModel;
import jp.ngt.rtm.entity.train.parts.EntityContainer;
import jp.ngt.rtm.entity.train.parts.EntityTie;
import jp.ngt.rtm.item.ItemCargo;
import jp.ngt.rtm.modelpack.ResourceType;
import jp.ngt.rtm.modelpack.modelset.ResourceSet;
import jp.ngt.rtm.modelpack.state.ResourceState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public final class EntityFreightCar
extends EntityTrainBase
implements IInventory {
    private static final float[][] CARGO_POS = new float[][]{{0.0f, 0.0f, 8.0f}, {0.0f, 0.0f, 4.0f}, {0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, -4.0f}, {0.0f, 0.0f, -8.0f}};
    private ItemStack[] cargoSlots = ItemUtil.getEmptyArray((int)5);
    public EntityCargo[] cargoEntities = new EntityCargo[5];

    public EntityFreightCar(World world) {
        super(world);
    }

    public EntityFreightCar(World world, String s) {
        super(world, s);
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        NBTTagList list = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            byte b0;
            NBTTagCompound nbt1 = list.func_150305_b(i);
            if (!nbt1.func_150297_b("Slot", 1) || (b0 = nbt1.func_74771_c("Slot")) < 0 || b0 >= this.cargoSlots.length) continue;
            this.cargoSlots[b0] = new ItemStack(nbt1);
        }
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.cargoSlots.length; ++i) {
            if (this.cargoSlots[i] == null || this.cargoEntities[i] == null) continue;
            this.cargoEntities[i].writeCargoToItem();
            NBTTagCompound nbt0 = new NBTTagCompound();
            nbt0.func_74774_a("Slot", (byte)i);
            this.cargoSlots[i].func_77955_b(nbt0);
            list.func_74742_a((NBTBase)nbt0);
        }
        nbt.func_74782_a("Items", (NBTBase)list);
    }

    @Override
    public void func_70106_y() {
        super.func_70106_y();
        for (int i = 0; i < this.cargoEntities.length; ++i) {
            if (this.cargoEntities[i] == null) continue;
            this.cargoEntities[i].func_70106_y();
        }
    }

    @Override
    public void onVehicleUpdate() {
        super.onVehicleUpdate();
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < this.cargoSlots.length; ++i) {
                if (this.hasCargo(i)) {
                    if (this.cargoEntities[i] != null) continue;
                    EntityCargo entity = this.createCargoEntity((byte)i);
                    entity.updatePartPos(this);
                    this.field_70170_p.func_72838_d((Entity)entity);
                    this.cargoEntities[i] = entity;
                    continue;
                }
                if (this.cargoEntities[i] == null) continue;
                this.cargoEntities[i].func_70106_y();
                this.cargoEntities[i] = null;
            }
        }
    }

    @Override
    public boolean func_70097_a(DamageSource par1, float par2) {
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < this.cargoSlots.length; ++i) {
                if (this.cargoSlots[i] == null) continue;
                this.func_70099_a(this.cargoSlots[i], 1.0f);
            }
        }
        return super.func_70097_a(par1, par2);
    }

    @Override
    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (super.func_184230_a(player, hand)) {
            return true;
        }
        if (!this.field_70170_p.field_72995_K) {
            player.openGui((Object)RTMCore.instance, (int)RTMCore.guiIdFreightCar, player.field_70170_p, this.func_145782_y(), 0, 0);
        }
        return true;
    }

    private boolean hasCargo(int par1) {
        ItemStack itemstack = this.cargoSlots[par1];
        return itemstack != null && itemstack.func_77973_b() instanceof ItemCargo;
    }

    private EntityCargo createCargoEntity(byte slot) {
        EntityCargoWithModel entity;
        ResourceState state;
        EntityCargo cargo = null;
        int damage = this.cargoSlots[slot].func_77952_i();
        float[] pos = (float[])CARGO_POS[slot].clone();
        pos[1] = pos[1] + this.getVehicleYOffset();
        switch (damage) {
            case 0: {
                cargo = new EntityContainer(this.field_70170_p, this, this.cargoSlots[slot], pos, slot);
                break;
            }
            case 1: {
                cargo = new EntityArtillery(this.field_70170_p, this, this.cargoSlots[slot], pos, slot);
                break;
            }
            case 2: {
                cargo = new EntityTie(this.field_70170_p, this, this.cargoSlots[slot], pos, slot);
                break;
            }
            default: {
                cargo = new EntityContainer(this.field_70170_p, this, this.cargoSlots[slot], pos, slot);
            }
        }
        cargo.readCargoFromItem();
        if ((damage == 0 || damage == 1) && ((ResourceSet)(state = (entity = (EntityCargoWithModel)cargo).getResourceState()).getResourceSet()).isDummy()) {
            state.setResourceName(state.type.defaultName);
            entity.updateResourceState();
        }
        return cargo;
    }

    public int func_70302_i_() {
        return this.cargoSlots.length;
    }

    public ItemStack func_70301_a(int par1) {
        return this.cargoSlots[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (!this.cargoSlots[par1].func_190926_b()) {
            if (this.cargoSlots[par1].func_190916_E() <= par2) {
                ItemStack itemstack = this.cargoSlots[par1];
                this.cargoSlots[par1] = ItemStack.field_190927_a;
                return itemstack;
            }
            ItemStack itemstack = this.cargoSlots[par1].func_77979_a(par2);
            if (this.cargoSlots[par1].func_190916_E() == 0) {
                this.cargoSlots[par1] = ItemStack.field_190927_a;
            }
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int par1) {
        if (!this.cargoSlots[par1].func_190926_b()) {
            ItemStack itemstack = this.cargoSlots[par1];
            this.cargoSlots[par1] = ItemStack.field_190927_a;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int par1, ItemStack itemStack) {
        this.cargoSlots[par1] = itemStack;
        if (!itemStack.func_190926_b() && itemStack.func_190916_E() > this.func_70297_j_()) {
            itemStack.func_190920_e(this.func_70297_j_());
        }
    }

    @Override
    public String func_70005_c_() {
        return "Inventory_FreightCar";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.func_70068_e((Entity)player) < 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int var1, ItemStack var2) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    @Override
    protected ResourceType getSubType() {
        return RTMResource.TRAIN_CC;
    }

    public boolean func_191420_l() {
        return false;
    }
}

