/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.entity.train;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.math.PooledVec3;
import jp.ngt.ngtlib.math.Vec3;
import jp.ngt.ngtlib.renderer.NGTParticle;
import jp.ngt.ngtlib.util.NGTUtil;
import jp.ngt.ngtlib.util.PermissionManager;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.RTMItem;
import jp.ngt.rtm.RTMResource;
import jp.ngt.rtm.electric.WireManager;
import jp.ngt.rtm.entity.npc.EntityMotorman;
import jp.ngt.rtm.entity.npc.macro.MacroRecorder;
import jp.ngt.rtm.entity.train.EntityBogie;
import jp.ngt.rtm.entity.train.util.BogieController;
import jp.ngt.rtm.entity.train.util.EnumNotch;
import jp.ngt.rtm.entity.train.util.Formation;
import jp.ngt.rtm.entity.train.util.FormationEntry;
import jp.ngt.rtm.entity.train.util.FormationManager;
import jp.ngt.rtm.entity.train.util.TrainState;
import jp.ngt.rtm.entity.vehicle.EntityVehicleBase;
import jp.ngt.rtm.item.ItemTrain;
import jp.ngt.rtm.modelpack.cfg.TrainConfig;
import jp.ngt.rtm.modelpack.modelset.ModelSetTrain;
import jp.ngt.rtm.modelpack.modelset.ModelSetVehicleBase;
import jp.ngt.rtm.network.PacketNotice;
import jp.ngt.rtm.rail.TileEntityLargeRailBase;
import jp.ngt.rtm.rail.TileEntityLargeRailCore;
import jp.ngt.rtm.world.IChunkLoader;
import jp.ngt.rtm.world.RTMChunkManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityTrainBase
extends EntityVehicleBase<ModelSetTrain>
implements IChunkLoader {
    private static final DataParameter<Integer> BOGIE_ID0 = EntityDataManager.func_187226_a(EntityTrainBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> BOGIE_ID1 = EntityDataManager.func_187226_a(EntityTrainBase.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final short MAX_AIR_COUNT = 2880;
    public static final short MIN_AIR_COUNT = 2480;
    public static final float TRAIN_WIDTH = 2.75f;
    public static final float TRAIN_HEIGHT = 1.1875f;
    public final BogieController bogieController = new BogieController();
    private Formation formation;
    private float trainSpeed;
    public int brakeCount = 72;
    public int atsCount;
    public boolean onRail = true;
    public int brakeAirCount = 2880;
    public boolean complessorActive;
    private float wave;
    private static final int[] PANTO_POS_ZERO = new int[]{0, 0};
    private ForgeChunkManager.Ticket ticket;
    private final Set<ChunkPos> loadedChunks = new HashSet<ChunkPos>();
    private int prevChunkCoordX;
    private int prevChunkCoordZ;

    public EntityTrainBase(World world) {
        super(world);
        this.func_70105_a(2.75f, 1.1875f);
        this.field_70145_X = true;
    }

    public EntityTrainBase(World world, String s) {
        this(world);
    }

    public void spawnTrain(World world) {
        world.func_72838_d((Entity)this);
        this.formation = FormationManager.getInstance().createNewFormation(this);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(BOGIE_ID0, (Object)0);
        this.func_184212_Q().func_187214_a(BOGIE_ID1, (Object)0);
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        NBTTagCompound entryData = new NBTTagCompound();
        this.writeFormationData(entryData);
        nbt.func_74782_a("FormationEntry", (NBTBase)entryData);
        nbt.func_74768_a("trainDir", this.getTrainDirection());
    }

    private void writeFormationData(NBTTagCompound nbt) {
        if (this.formation == null) {
            return;
        }
        FormationEntry entry = this.formation.getEntry(this);
        if (entry != null) {
            nbt.func_74772_a("FormationId", this.formation.id);
            nbt.func_74774_a("EntryPos", entry.entryId);
            nbt.func_74774_a("EntryDir", entry.dir);
        }
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        NBTTagCompound entryData = nbt.func_74775_l("FormationEntry");
        this.readFormationData(entryData);
        this.setTrainDirection(nbt.func_74762_e("trainDir"));
    }

    private void readFormationData(NBTTagCompound nbt) {
        long id = nbt.func_74763_f("FormationId");
        byte pos = nbt.func_74771_c("EntryPos");
        byte dir = nbt.func_74771_c("EntryDir");
        Formation f0 = FormationManager.getInstance().getFormation(id);
        if (f0 == null) {
            this.formation = FormationManager.getInstance().createNewFormation(this);
        } else {
            this.formation = f0;
            f0.setTrain(this, pos, dir);
        }
    }

    public Entity[] func_70021_al() {
        return null;
    }

    @Override
    public AxisAlignedBB func_70114_g(Entity par1) {
        return null;
    }

    public double func_70033_W() {
        return 0.0;
    }

    @Override
    public void func_70106_y() {
        super.func_70106_y();
        if (!this.field_70170_p.field_72995_K) {
            this.releaseTicket();
            this.bogieController.setDead(this);
            try {
                this.formation.onRemovedTrain(this);
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void onVehicleUpdate() {
        this.updateSpeed();
        if (this.existBogies()) {
            this.bogieController.updateBogies(this);
        }
        super.onVehicleUpdate();
        if (this.field_70170_p.field_72995_K) {
            this.spawnSmoke();
        } else {
            this.updateChunks();
            this.updateATS();
        }
    }

    @Override
    protected void updateFallState() {
        if (this.onRail) {
            this.field_70181_x = 0.0;
        } else {
            super.updateFallState();
        }
    }

    @Override
    protected void updateMovement() {
        if (this.formation.isFrontCar(this)) {
            this.formation.updateTrainMovement();
        }
    }

    public void updateTrainMovement(BogieController.MotionState state) {
        if (state == BogieController.MotionState.FLY) {
            if (this.onRail) {
                float speed = this.getSpeed() * this.getMoveDir();
                Vec3 vec3 = PooledVec3.create((double)0.0, (double)0.0, (double)speed);
                vec3 = vec3.rotateAroundX(this.field_70125_A + 15.0f);
                vec3 = vec3.rotateAroundY(this.field_70177_z);
                this.field_70159_w = vec3.getX();
                this.field_70181_x = vec3.getY();
                this.field_70179_y = vec3.getZ();
                this.onRail = false;
                this.field_70145_X = false;
                this.setSpeed(0.0f);
            }
        } else if (state == BogieController.MotionState.MOVE) {
            if (!this.onRail) {
                this.field_70179_y = 0.0;
                this.field_70181_x = 0.0;
                this.field_70159_w = 0.0;
                this.onRail = true;
                this.field_70145_X = true;
            }
        } else if (state == BogieController.MotionState.STOP) {
            // empty if block
        }
        if (!this.onRail) {
            super.updateMovement();
            this.bogieController.updateBogiePos(this, 0, BogieController.UpdateFlag.NONE);
            this.bogieController.updateBogiePos(this, 1, BogieController.UpdateFlag.NONE);
        }
    }

    @Override
    protected void applyPhysicalEffect() {
        double d0 = 0.99;
        this.field_70159_w *= d0;
        this.field_70181_x *= d0;
        this.field_70179_y *= d0;
        float f0 = 0.125f;
        if (this.field_70125_A > 0.0f) {
            this.field_70125_A -= f0;
        } else if (this.field_70125_A < 0.0f) {
            this.field_70125_A += f0;
        }
        if (Math.abs(this.field_70125_A) < f0) {
            this.field_70125_A = 0.0f;
        }
        this.getBogie((int)0).field_70125_A = this.field_70125_A;
        this.getBogie((int)1).field_70125_A = this.field_70125_A * -1.0f;
    }

    public void updateRoll(float par1) {
        TrainConfig cfg = (TrainConfig)((ModelSetTrain)this.getResourceState().getResourceSet()).getConfig();
        float f0 = -cfg.rolling;
        float pendulum = NGTMath.wrapAngle((float)((this.field_70177_z - this.field_70126_B) * f0));
        if (this.getTrainDirection() == 1) {
            pendulum *= -1.0f;
        }
        float roll = par1 + pendulum;
        this.wave = (float)((double)(this.wave + this.getSpeed() * cfg.rollSpeedCoefficient) % (Math.PI * 2));
        float sw = (NGTMath.getSin((float)this.wave) + NGTMath.getSin((float)(this.wave * cfg.rollVariationCoefficient))) * 0.5f;
        this.rotationRoll = roll + sw * cfg.rollWidthCoefficient;
    }

    protected void updateATS() {
        if (this.atsCount > 0) {
            ++this.atsCount;
            if (this.atsCount >= 100) {
                this.stopTrain(false);
                this.atsCount = 0;
            }
        }
    }

    @Override
    protected void updateBlockCollisionState() {
        TileEntityLargeRailCore railCore;
        int minY = NGTMath.floor((double)this.field_70163_u) - 3;
        TileEntityLargeRailBase rail = TileEntityLargeRailBase.getRailFromCoordinates(this.field_70170_p, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, minY);
        if (rail != null && (railCore = rail.getRailCore()) != null) {
            int signal = railCore.getSignal();
            this.setSignal(signal);
        }
        this.func_145775_I();
    }

    @SideOnly(value=Side.CLIENT)
    protected void spawnSmoke() {
        ModelSetTrain set = (ModelSetTrain)this.getResourceState().getResourceSet();
        if (((TrainConfig)set.getConfig()).smoke != null) {
            float speed = this.getSpeed();
            int notch = this.getNotch();
            Random random = this.field_70170_p.field_73012_v;
            for (int i = 0; i < ((TrainConfig)set.getConfig()).smoke.length; ++i) {
                Vec3 vec3 = PooledVec3.create((double)((Double)((TrainConfig)set.getConfig()).smoke[i][0]), (double)((Double)((TrainConfig)set.getConfig()).smoke[i][1]), (double)((Double)((TrainConfig)set.getConfig()).smoke[i][2]));
                vec3 = vec3.rotateAroundX(this.field_70125_A);
                vec3 = vec3.rotateAroundY(this.field_70177_z);
                double min = (Double)((TrainConfig)set.getConfig()).smoke[i][4];
                double max = (Double)((TrainConfig)set.getConfig()).smoke[i][5];
                int amount = speed > 0.05f ? (int)max : (notch > 0 ? (int)min + 3 : (int)min);
                EnumParticleTypes particle = NGTParticle.getParticle((String)((String)((TrainConfig)set.getConfig()).smoke[i][3]));
                for (int j = 0; j < amount; ++j) {
                    double d0 = this.field_70165_t + vec3.getX() + (double)random.nextFloat() * 0.5 - 0.25;
                    double d1 = this.field_70163_u + vec3.getY() + (double)this.getVehicleYOffset();
                    double d2 = this.field_70161_v + vec3.getZ() + (double)random.nextFloat() * 0.5 - 0.25;
                    double smokeSpeed = 0.0625;
                    if (((TrainConfig)set.getConfig()).smoke.length == 7) {
                        smokeSpeed = (Double)((TrainConfig)set.getConfig()).smoke[i][6];
                    }
                    double vx = (random.nextDouble() * 2.0 - 1.0) * smokeSpeed;
                    double vz = (random.nextDouble() * 2.0 - 1.0) * smokeSpeed;
                    this.field_70170_p.func_175688_a(particle, d0, d1, d2, vx, 0.25, vz, new int[0]);
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void updateAnimation() {
        super.updateAnimation();
        ModelSetTrain modelSet = (ModelSetTrain)this.getResourceState().getResourceSet();
        if (this.getTrainDirection() == 0 && this.seatRotation > -45) {
            --this.seatRotation;
        }
        if (this.getTrainDirection() == 1 && this.seatRotation < 45) {
            ++this.seatRotation;
        }
        this.setRollsignAnimation(this.getVehicleState(TrainState.TrainStateType.Destination));
        if (this.rollsignAnimation > this.rollsignV) {
            --this.rollsignAnimation;
        } else if (this.rollsignAnimation < this.rollsignV) {
            ++this.rollsignAnimation;
        }
        if (this.getResourceState().type == RTMResource.TRAIN_EC) {
            if (this.complessorActive) {
                ++this.brakeAirCount;
                if (this.brakeAirCount >= 2880) {
                    this.complessorActive = false;
                    RTMCore.proxy.playSound((Entity)this, "rtm:sounds/train/cp_fin.ogg", 1.0f, 1.0f);
                }
            } else if (this.brakeAirCount < 2480) {
                this.complessorActive = true;
            }
        }
    }

    @Override
    protected int[] getPantographMaxHeight() {
        int[] ia;
        ModelSetTrain modelSet = (ModelSetTrain)this.getResourceState().getResourceSet();
        if (((TrainConfig)modelSet.getConfig()).pantoPos != null) {
            ia = new int[((TrainConfig)modelSet.getConfig()).pantoPos.length];
            for (int i = 0; i < ia.length; ++i) {
                Random rand;
                float[] fa = ((TrainConfig)modelSet.getConfig()).pantoPos[i];
                if (!(fa[3] > 0.0f)) continue;
                double trainY = this.field_70163_u + (double)this.getVehicleYOffset();
                Vec3 vec = PooledVec3.create((double)fa[0], (double)fa[3], (double)fa[1]);
                vec = vec.rotateAroundX(this.field_70125_A);
                vec = vec.rotateAroundY(this.field_70177_z);
                double y = WireManager.INSTANCE.getWireY(this.field_70165_t + vec.getX(), trainY + vec.getY(), this.field_70161_v + vec.getZ());
                ia[i] = (int)((y - trainY - (double)fa[3]) / (double)(fa[2] - fa[3]) * 40.0);
                long time = this.func_130014_f_().func_72820_D() % 24000L;
                if (trainY + vec.getY() == y || this.getSpeed() == 0.0f || time < 11615L || time > 22925L || !this.func_130014_f_().func_180494_b(this.func_180425_c()).func_150559_j() || (rand = this.func_130014_f_().field_73012_v).nextInt(20) != 0) continue;
                int count = rand.nextInt(5) + 1;
                for (int k = 0; k < 5; ++k) {
                    NGTParticle.INSTANCE.spawnParticle(this.func_130014_f_(), 100, false, this.field_70165_t + vec.getX(), y, this.field_70161_v + vec.getZ(), rand.nextGaussian() * 0.0625, -0.25, rand.nextGaussian() * 0.0625, ia);
                }
            }
        } else {
            ia = PANTO_POS_ZERO;
        }
        return ia;
    }

    @SideOnly(value=Side.CLIENT)
    public float getCouplerYaw(int dir) {
        EntityTrainBase conTrain = this.getConnectedTrain(dir);
        if (conTrain == null) {
            return 0.0f;
        }
        float dif = NGTMath.getAngleD((double)this.field_70161_v, (double)this.field_70165_t, (double)conTrain.field_70161_v, (double)conTrain.field_70165_t);
        float angle = NGTMath.wrapAngle((float)(dif - (this.field_70177_z + (dir == 0 ? 0.0f : 180.0f))));
        return angle + (Math.abs(angle) > 90.0f ? 180.0f : 0.0f);
    }

    protected void playBrakeReleaseSound(boolean isStrong) {
        String sound;
        ModelSetTrain modelSet = (ModelSetTrain)this.getResourceState().getResourceSet();
        String string = sound = isStrong ? ((TrainConfig)modelSet.getConfig()).sound_BrakeRelease : ((TrainConfig)modelSet.getConfig()).sound_BrakeRelease2;
        if (sound != null) {
            RTMCore.proxy.playSound((Entity)this, sound, 1.0f, 1.0f);
        }
    }

    protected void updateSpeed() {
        if (!this.onRail) {
            return;
        }
        int notch = this.getNotch();
        Entity passenger = this.getFirstPassenger();
        if (passenger != null && (passenger instanceof EntityPlayer || passenger instanceof EntityMotorman) || notch > 0) {
            // empty if block
        }
        boolean isBrakeDisabled = true;
        float speed = this.getSpeed();
        if (notch < 0) {
            int max;
            int n = max = notch < 0 ? notch * -18 : 0;
            if (this.brakeCount < max) {
                ++this.brakeCount;
                if (this.field_70170_p.field_72995_K) {
                    --this.brakeAirCount;
                }
            } else if (this.brakeCount > max) {
                this.brakeCount -= this.brakeCount - max > 1 ? 2 : 1;
            }
        } else if (notch >= 0) {
            if (this.brakeCount > 0) {
                if (speed <= 0.0f) {
                    isBrakeDisabled = false;
                }
                this.brakeCount -= 2;
            } else if (this.brakeCount < 0) {
                this.brakeCount = 0;
            }
        }
        if (this.isControlCar() && isBrakeDisabled && !this.field_70170_p.field_72995_K) {
            ModelSetTrain set = (ModelSetTrain)this.getResourceState().getResourceSet();
            float acceleration = EnumNotch.getAcceleration(notch, speed, (TrainConfig)set.getConfig());
            if (notch >= 0) {
                float deceleration;
                if (this.field_70125_A == 0.0f) {
                    float f1 = 2.0E-4f;
                    deceleration = speed > 0.0f ? f1 : (speed < 0.0f ? -f1 : 0.0f);
                } else {
                    float dec = 0.0125f;
                    float f2 = this.getTrainDirection() == 0 ? dec : -dec;
                    deceleration = NGTMath.sin((float)this.field_70125_A) * f2;
                }
                speed += acceleration - deceleration;
            } else {
                speed += speed > 0.0f ? acceleration : (speed < 0.0f ? -acceleration : 0.0f);
            }
            this.setSpeed(speed);
        }
    }

    public void func_70080_a(double x, double y, double z, float yaw, float pitch) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    protected void func_70101_b(float yaw, float pitch) {
        this.field_70177_z = NGTMath.wrapAngle((float)yaw);
        this.field_70125_A = NGTMath.wrapAngle((float)pitch);
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        if (!this.onRail) {
            super.func_70091_d(type, x, y, z);
        }
    }

    public void func_70024_g(double par1, double par3, double par5) {
    }

    public double getDefaultDistanceToConnectedTrain(EntityTrainBase par1) {
        ModelSetVehicleBase modelSet0 = (ModelSetVehicleBase)this.getResourceState().getResourceSet();
        ModelSetVehicleBase modelSet1 = (ModelSetVehicleBase)par1.getResourceState().getResourceSet();
        if (modelSet0 != null && modelSet1 != null) {
            double d0 = ((TrainConfig)modelSet0.getConfig()).trainDistance;
            double d1 = ((TrainConfig)modelSet1.getConfig()).trainDistance;
            return d0 + d1;
        }
        return 20.25;
    }

    public boolean inConnectableRange(EntityTrainBase par1) {
        double d0 = this.getDefaultDistanceToConnectedTrain(par1);
        return this.func_70068_e((Entity)par1) <= d0 * d0;
    }

    @Override
    public Vec3 getRiderPos(Entity passenger) {
        return super.getRiderPos(passenger).add(0.0, this.func_70042_X(), 0.0);
    }

    @Override
    protected int getRiderPosIndex() {
        return this.getTrainDirection();
    }

    public double func_70042_X() {
        return this.field_70131_O + 1.1875f - 0.93f;
    }

    public boolean func_70097_a(DamageSource par1, float par2) {
        if (this.func_180431_b(par1) || this.field_70128_L) {
            return false;
        }
        if (!par1.func_94541_c() && par1.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)par1.func_76346_g();
            if (!this.field_70170_p.field_72995_K && PermissionManager.INSTANCE.hasPermission((ICommandSender)player, "editVehicle")) {
                if (!player.field_71075_bZ.field_75098_d) {
                    int damage = 0;
                    ModelSetTrain model = (ModelSetTrain)this.getResourceState().getResourceSet();
                    if (model != null) {
                        String type = ((TrainConfig)model.getConfig()).getSubType();
                        damage = type.equals("DC") ? 0 : (type.equals("EC") ? 1 : (type.equals("CC") ? 2 : 3));
                    }
                    this.func_70099_a(new ItemStack(RTMItem.itemtrain, 1, damage), 0.0f);
                }
                this.func_70106_y();
            }
            return true;
        }
        return false;
    }

    protected boolean interactTrain(EntityBogie bogie, EntityPlayer player) {
        if (this.getFirstPassenger() != null && !this.getFirstPassenger().equals((Object)player)) {
            return true;
        }
        if (!this.field_70170_p.field_72995_K) {
            ItemStack itemstack = player.field_71071_by.func_70448_g();
            byte id1 = bogie.getBogieId();
            if (!itemstack.func_190926_b()) {
                if (itemstack.func_77973_b() == RTMItem.crowbar) {
                    this.concatenation(bogie, player);
                } else if (itemstack.func_77973_b() == RTMItem.itemMotorman) {
                    this.mountMotorman(bogie, player, itemstack);
                } else if (itemstack.func_77973_b() == RTMItem.paddle) {
                    NGTLog.sendChatMessage((ICommandSender)player, (String)("UUID:" + this.func_110124_au().toString() + "(bogie, found train)"), (Object[])new Object[0]);
                }
            } else if (id1 >= 0) {
                this.mountEntityToTrain((Entity)player, id1);
            }
        }
        return true;
    }

    protected void concatenation(EntityBogie bogie, EntityPlayer player) {
        byte id1 = bogie.getBogieId();
        if (id1 >= 0) {
            if (this.getConnectedTrain(id1) == null) {
                bogie.isActivated = true;
                NGTLog.sendChatMessage((ICommandSender)player, (String)"message.train.concatenation_mode", (Object[])new Object[0]);
            } else {
                this.formation.onDisconnectedTrain(this, id1);
                NGTLog.sendChatMessage((ICommandSender)player, (String)"message.train.deconcatenation", (Object[])new Object[0]);
            }
        }
    }

    protected void mountMotorman(EntityBogie bogie, EntityPlayer player, ItemStack stack) {
        byte id1 = bogie.getBogieId();
        if (id1 >= 0) {
            EntityMotorman motorman = new EntityMotorman(this.field_70170_p, player);
            motorman.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
            if (this.field_70170_p.func_72838_d((Entity)motorman)) {
                this.mountEntityToTrain((Entity)motorman, id1);
                stack.func_190918_g(1);
            }
        }
    }

    private void mountEntityToTrain(Entity entity, int direction) {
        if (this.getTrainDirection() != direction) {
            this.setSpeed(-this.getSpeed());
        }
        this.setTrainDirection(direction);
        entity.func_184220_m((Entity)this);
    }

    @Override
    protected void removePassengerFromVehicle(Entity passenger) {
        Object riding = this.getBogie(this.getTrainDirection());
        if (riding == null || this.func_70068_e((Entity)riding) > 225.0) {
            riding = this;
        }
        this.fixRiderPosOnDismount(passenger, (Entity)riding);
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af()) {
            if (this.field_70170_p.field_72995_K) {
                player.openGui((Object)RTMCore.instance, (int)RTMCore.guiIdSelectEntityModel, player.field_70170_p, this.func_145782_y(), 0, 0);
            }
            return true;
        }
        if (NGTUtil.isEquippedItem((EntityPlayer)player, (Item)RTMItem.paddle)) {
            if (!this.field_70170_p.field_72995_K) {
                NGTLog.sendChatMessage((ICommandSender)player, (String)("UUID:" + this.func_110124_au().toString() + "(train)"), (Object[])new Object[0]);
            }
            return true;
        }
        return false;
    }

    @Override
    public void updateResourceState() {
        super.updateResourceState();
        this.updateTrainSize();
    }

    private void updateTrainSize() {
        float td2;
        float width;
        TrainConfig cfg = (TrainConfig)((ModelSetTrain)this.getResourceState().getResourceSet()).getConfig();
        float[][] bogiePos = cfg.getBogiePos();
        float hBogieZ = Math.abs(bogiePos[0][2] - bogiePos[1][2]) * 0.5f;
        float f = width = hBogieZ < (td2 = (float)((double)cfg.trainDistance / 3.0 * 2.0)) ? hBogieZ : td2;
        if (width < 2.75f) {
            this.func_70105_a(width, 1.1875f);
            if (this.existBogies()) {
                this.getBogie(0).setBogieSize(width, 1.1875f);
                this.getBogie(1).setBogieSize(width, 1.1875f);
            }
        }
    }

    public void connectTrain(EntityBogie par1, EntityBogie par2) {
        if (!this.field_70170_p.field_72995_K && par2.getTrain() != null) {
            byte id1 = par1.getBogieId();
            byte id2 = par2.getBogieId();
            if (id1 >= 0 && id2 >= 0 && this.getConnectedTrain(id1) == null && par2.getTrain().formation != null) {
                this.formation.connectTrain(this, par2.getTrain(), id1, id2, par2.getTrain().formation);
                RTMCore.proxy.playSound(par1, "block.anvil.place", 1.0f, 1.0f);
                EntityPlayer player = null;
                if (this.getFirstPassenger() instanceof EntityPlayer) {
                    player = (EntityPlayer)this.getFirstPassenger();
                } else if (par2.getTrain().getFirstPassenger() instanceof EntityPlayer) {
                    player = (EntityPlayer)par2.getTrain().getFirstPassenger();
                }
                if (player != null) {
                    NGTLog.sendChatMessage((ICommandSender)player, (String)"message.train.concatenated", (Object[])new Object[0]);
                }
            }
        }
    }

    @Override
    public float getSpeed() {
        return this.trainSpeed;
    }

    @Override
    public void setSpeed(float par1) {
        if (this.field_70170_p.field_72995_K) {
            this.trainSpeed = par1;
        } else if (this.isControlCar()) {
            this.formation.setSpeed(par1);
        }
    }

    public void setSpeed_NoSync(float par1) {
        this.trainSpeed = par1;
    }

    public void stopTrain(boolean changeSpeed) {
        if (this.formation != null) {
            this.setNotch(-8);
            if (changeSpeed) {
                this.setSpeed(0.0f);
            }
        }
    }

    public boolean isControlCar() {
        return this.getVehicleState(TrainState.TrainStateType.Role) == TrainState.Role_Front.data;
    }

    public boolean existBogies() {
        return this.getBogie(0) != null && this.getBogie(1) != null;
    }

    public int getBogieEntityId(int bogieId) {
        DataParameter<Integer> key = bogieId == 0 ? BOGIE_ID0 : BOGIE_ID1;
        return (Integer)this.func_184212_Q().func_187225_a(key);
    }

    public void setBogieEntityId(int bogieId, int entityId) {
        DataParameter<Integer> key = bogieId == 0 ? BOGIE_ID0 : BOGIE_ID1;
        this.func_184212_Q().func_187227_b(key, (Object)entityId);
    }

    public EntityBogie getBogie(int bogieId) {
        return this.bogieController.getBogie(this, bogieId);
    }

    public EntityTrainBase getConnectedTrain(int par1) {
        if (this.formation != null) {
            int dif;
            FormationEntry entry = this.formation.getEntry(this);
            if (entry == null) {
                return null;
            }
            int pos = entry.entryId;
            int n = dif = par1 == 0 ? -1 : 1;
            if (entry.dir == 1) {
                dif *= -1;
            }
            if ((pos += dif) < 0 || pos >= this.formation.size()) {
                return null;
            }
            FormationEntry connected = this.formation.get(pos);
            if (connected != null) {
                return connected.train;
            }
        }
        return null;
    }

    @Override
    public Formation getFormation() {
        return this.formation;
    }

    public void setFormation(Formation par1) {
        this.formation = par1;
    }

    public int getTrainDirection() {
        return this.getVehicleState(TrainState.TrainStateType.Direction);
    }

    public void setTrainDirection(int par1) {
        if (this.formation == null) {
            this.setTrainDirection_NoSync((byte)par1);
        } else {
            this.formation.setTrainDirection((byte)par1, this);
        }
    }

    public void setTrainDirection_NoSync(byte par1) {
        super.setVehicleState(TrainState.TrainStateType.Direction, par1);
        int id2 = 1 - par1;
        if (id2 < 2 && this.existBogies()) {
            this.getBogie(par1).setFront(true);
            this.getBogie(id2).setFront(false);
        }
    }

    public int getNotch() {
        return this.getVehicleState(TrainState.TrainStateType.Notch);
    }

    @SideOnly(value=Side.CLIENT)
    public void syncNotch(int notchInc) {
        RTMCore.NETWORK_WRAPPER.sendToServer((IMessage)new PacketNotice(0, "notch:" + notchInc, (Entity)this));
        MacroRecorder.INSTANCE.recNotch(this.func_130014_f_(), notchInc);
    }

    public boolean addNotch(Entity driver, int par2) {
        int i;
        if (par2 != 0 && this.setNotch((i = this.getNotch()) + par2)) {
            RTMCore.proxy.playSound(driver, "rtm:sounds/train/lever.ogg", 1.0f, 1.0f);
            if (i < 0 && par2 > 0 && !this.field_70170_p.field_72995_K) {
                this.playBrakeReleaseSound(i == -1);
            }
            return true;
        }
        return false;
    }

    public boolean setNotch(int par1) {
        int prevNotch;
        if (this.isControlCar() && par1 <= 5 && par1 >= -8 && (prevNotch = this.getNotch()) != par1) {
            super.setVehicleState(TrainState.TrainStateType.Notch, (byte)par1);
            return true;
        }
        return false;
    }

    public int getSignal() {
        return this.getVehicleState(TrainState.TrainStateType.Signal);
    }

    public void setSignal(int par1) {
        int signal = this.getSignal();
        if (par1 > 0 && signal != -1) {
            this.setSignal2(par1);
            if (par1 == 1 && this.getSpeed() > 0.0f) {
                ++this.atsCount;
            }
        }
    }

    public void setSignal2(int par1) {
        if (par1 == -1) {
            this.atsCount = 0;
        }
        super.setVehicleState(TrainState.TrainStateType.Signal, (byte)par1);
    }

    @Override
    public void setVehicleState(TrainState.TrainStateType type, byte data) {
        byte b;
        byte by = data < type.min ? type.max : (b = data > type.max ? type.min : data);
        if (this.formation != null) {
            this.formation.setTrainStateData(type, b, this);
        }
    }

    public void setTrainStateData_NoSync(TrainState.TrainStateType type, byte data) {
        super.setVehicleState(type, data);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected boolean useInteriorLight() {
        return this.getVehicleState(TrainState.TrainStateType.InteriorLight) > 0;
    }

    @Override
    public float getMoveDir() {
        int i = this.getTrainDirection();
        if (this.getBogie(i) != null) {
            boolean b0 = this.getBogie(i).isFront();
            return i == 0 && b0 || i == 1 && !b0 ? 1.0f : -1.0f;
        }
        return 1.0f;
    }

    @Override
    public float getVehicleYOffset() {
        return 1.1875f;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return ItemTrain.convertFormationAsItem(this);
    }

    private void updateChunks() {
        if (this.isChunkLoaderEnable()) {
            this.forceChunkLoading();
        } else {
            this.releaseTicket();
        }
        this.prevChunkCoordX = this.field_70176_ah;
        this.prevChunkCoordZ = this.field_70164_aj;
    }

    @Override
    public boolean isChunkLoaderEnable() {
        return this.getVehicleState(TrainState.TrainStateType.ChunkLoader) > 0;
    }

    private void releaseTicket() {
        this.loadedChunks.clear();
        if (this.ticket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticket);
            this.ticket = null;
        }
    }

    private boolean requestTicket() {
        ForgeChunkManager.Ticket chunkTicket = RTMChunkManager.INSTANCE.getNewTicket(this.field_70170_p, ForgeChunkManager.Type.ENTITY);
        if (chunkTicket != null) {
            byte depth = this.getVehicleState(TrainState.TrainStateType.ChunkLoader);
            chunkTicket.getModData();
            chunkTicket.setChunkListDepth((int)depth);
            chunkTicket.bindEntity((Entity)this);
            this.setChunkTicket(chunkTicket);
            return true;
        }
        NGTLog.debug((String)"[RTM] Failed to get ticket (Chunk Loader)");
        return false;
    }

    @Override
    public void setChunkTicket(ForgeChunkManager.Ticket par1) {
        if (this.ticket != par1) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticket);
        }
        this.ticket = par1;
    }

    @Override
    public void forceChunkLoading() {
        this.forceChunkLoading(this.field_70176_ah, this.field_70164_aj);
    }

    @Override
    public void forceChunkLoading(int x, int z) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.ticket == null && !this.requestTicket()) {
                return;
            }
            if (x != this.prevChunkCoordX || z != this.prevChunkCoordZ) {
                this.setupChunks(x, z);
            }
            for (ChunkPos chunk : this.loadedChunks) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkPos)chunk);
            }
            ChunkPos myChunk = new ChunkPos(x, z);
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkPos)myChunk);
        }
    }

    private void setupChunks(int xChunk, int zChunk) {
        byte rad = this.getVehicleState(TrainState.TrainStateType.ChunkLoader);
        RTMChunkManager.INSTANCE.getChunksAround(this.loadedChunks, xChunk, zChunk, rad);
    }
}

