/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.entity.train.parts;

import java.util.UUID;
import jp.ngt.ngtlib.entity.EntityCustom;
import jp.ngt.ngtlib.math.PooledVec3;
import jp.ngt.ngtlib.math.Vec3;
import jp.ngt.rtm.entity.train.EntityBogie;
import jp.ngt.rtm.entity.vehicle.EntityVehicleBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Rotations;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityVehiclePart
extends EntityCustom {
    private static final DataParameter<Integer> TRAIN_ID = EntityDataManager.func_187226_a(EntityVehiclePart.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Rotations> POS = EntityDataManager.func_187226_a(EntityVehiclePart.class, (DataSerializer)DataSerializers.field_187199_i);
    protected boolean isIndependent;
    private EntityVehicleBase parent;
    private UUID unloadedParent;
    public boolean needsUpdatePos;
    private EntityLivingBase rider;

    public EntityVehiclePart(World par1) {
        super(par1);
    }

    public EntityVehiclePart(World par1, EntityVehicleBase par2, float[] par3Pos) {
        this(par1);
        this.setVehicle(par2);
        this.setPartPos(par3Pos[0], par3Pos[1], par3Pos[2]);
        this.updatePartPos(par2);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(TRAIN_ID, (Object)0);
        this.func_184212_Q().func_187214_a(POS, (Object)new Rotations(0.0f, 0.0f, 0.0f));
    }

    public void syncData() {
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74757_a("Independent", this.isIndependent);
        Vec3 v3 = this.getPartVec();
        nbt.func_74776_a("vecX", (float)v3.getX());
        nbt.func_74776_a("vecY", (float)v3.getY());
        nbt.func_74776_a("vecZ", (float)v3.getZ());
        if (this.getVehicle() != null) {
            long l0 = 0L;
            long l1 = 0L;
            UUID uuid = this.getVehicle().func_110124_au();
            if (uuid != null) {
                l0 = uuid.getMostSignificantBits();
                l1 = uuid.getLeastSignificantBits();
            }
            nbt.func_74772_a("trainUUID_Most", l0);
            nbt.func_74772_a("trainUUID_Least", l1);
        }
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.isIndependent = nbt.func_74767_n("Independent");
        float vX = nbt.func_74760_g("vecX");
        float vY = nbt.func_74760_g("vecY");
        float vZ = nbt.func_74760_g("vecZ");
        this.setPartPos(vX, vY, vZ);
        if (nbt.func_150297_b("trainUUID_Most", 4) && nbt.func_150297_b("trainUUID_Least", 4)) {
            UUID uuid;
            long l0 = nbt.func_74763_f("trainUUID_Most");
            long l1 = nbt.func_74763_f("trainUUID_Least");
            if (l0 != 0L && l1 != 0L && !this.loadTrainFromUUID(uuid = new UUID(l0, l1))) {
                this.unloadedParent = uuid;
            }
        }
    }

    private boolean loadTrainFromUUID(UUID uuid) {
        for (int j = 0; j < this.field_70170_p.field_72996_f.size(); ++j) {
            Entity entity = (Entity)this.field_70170_p.field_72996_f.get(j);
            if (!uuid.equals(entity.func_110124_au()) || !(entity instanceof EntityVehicleBase)) continue;
            this.setVehicle((EntityVehicleBase)entity);
            this.onLoadVehicle();
            return true;
        }
        return false;
    }

    public abstract void onLoadVehicle();

    public AxisAlignedBB func_70114_g(Entity par1) {
        if (par1 instanceof EntityVehiclePart || par1 instanceof EntityVehicleBase || par1 instanceof EntityBogie) {
            return null;
        }
        return par1.func_174813_aQ();
    }

    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.getFirstPassenger() != null) {
                if (this.rider == null && this.getFirstPassenger() instanceof EntityLivingBase) {
                    this.rider = (EntityLivingBase)this.getFirstPassenger();
                }
            } else if (this.rider != null) {
                this.onDismount((Entity)this.rider);
                this.rider = null;
            }
        }
        if (this.isIndependent) {
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
        } else {
            if (this.unloadedParent != null && this.loadTrainFromUUID(this.unloadedParent)) {
                this.unloadedParent = null;
            }
            super.func_70071_h_();
            EntityVehicleBase vehicle = this.getVehicle();
            if (vehicle != null) {
                this.updatePartPos(vehicle);
            }
        }
    }

    public void onDismount(Entity rider) {
        if (this.getVehicle() != null) {
            this.getVehicle().fixRiderPosOnDismount(rider, (Entity)this);
        }
    }

    public void updatePartPos(EntityVehicleBase vehicle) {
        Vec3 v3 = this.getPartVec();
        v3 = v3.rotateAroundZ(-vehicle.rotationRoll);
        v3 = v3.rotateAroundX(vehicle.field_70125_A);
        v3 = v3.rotateAroundY(vehicle.field_70177_z);
        this.func_70107_b(vehicle.field_70165_t + v3.getX(), vehicle.field_70163_u + v3.getY(), vehicle.field_70161_v + v3.getZ());
        this.func_70101_b(vehicle.field_70177_z, vehicle.field_70125_A);
        this.needsUpdatePos = false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double par1, double par3, double par5, float par7, float par8, int par9, boolean par10) {
        if (this.getVehicle() == null || this.getVehicle().getSpeed() <= 0.0f) {
            this.func_70107_b(par1, par3, par5);
            this.func_70101_b(par7, par8);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double par1, double par3, double par5) {
    }

    public void func_70091_d(MoverType type, double par1, double par3, double par5) {
    }

    public void func_70024_g(double par1, double par3, double par5) {
    }

    public void setVehicle(EntityVehicleBase vehicle) {
        this.func_184212_Q().func_187227_b(TRAIN_ID, (Object)vehicle.func_145782_y());
    }

    public EntityVehicleBase getVehicle() {
        int id;
        Entity entity;
        if (this.parent == null && (entity = this.field_70170_p.func_73045_a(id = ((Integer)this.func_184212_Q().func_187225_a(TRAIN_ID)).intValue())) instanceof EntityVehicleBase) {
            this.parent = (EntityVehicleBase)entity;
        }
        return this.parent;
    }

    public void setPartPos(float x, float y, float z) {
        this.func_184212_Q().func_187227_b(POS, (Object)new Rotations(x, y, z));
    }

    public Vec3 getPartVec() {
        Rotations ro = (Rotations)this.func_184212_Q().func_187225_a(POS);
        return PooledVec3.create((double)ro.func_179415_b(), (double)ro.func_179416_c(), (double)ro.func_179413_d());
    }
}

