/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.entity.vehicle;

import jp.ngt.ngtlib.math.Vec3;
import jp.ngt.rtm.RTMItem;
import jp.ngt.rtm.RTMResource;
import jp.ngt.rtm.block.tileentity.TileEntityMechanism;
import jp.ngt.rtm.entity.vehicle.EntityVehicle;
import jp.ngt.rtm.entity.vehicle.LiftMotion;
import jp.ngt.rtm.entity.vehicle.VehicleType;
import jp.ngt.rtm.modelpack.ResourceType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityLift
extends EntityVehicle {
    private TileEntityMechanism currentPulley;
    private BlockPos currentPulleyPos = new BlockPos(0, 0, 0);
    private float totalMove;
    private long prevTime;

    public EntityLift(World world) {
        super(world);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        int[] ia = nbt.func_74759_k("pulley_pos");
        if (ia.length == 3) {
            this.currentPulleyPos = new BlockPos(ia[0], ia[1], ia[2]);
        }
        this.totalMove = nbt.func_74760_g("total_move");
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        int[] ia = new int[]{this.currentPulleyPos.func_177958_n(), this.currentPulleyPos.func_177956_o(), this.currentPulleyPos.func_177952_p()};
        nbt.func_74783_a("pulley_pos", ia);
        nbt.func_74776_a("total_move", this.totalMove);
    }

    @Override
    protected boolean shouldUpdateMotion() {
        return true;
    }

    @Override
    protected void updateMotion(EntityLivingBase entity, float moveStrafe, float moveForward) {
    }

    @Override
    protected void updateMovement() {
        TileEntity tileEntity;
        if (this.currentPulley == null && (tileEntity = this.func_130014_f_().func_175625_s(this.currentPulleyPos)) instanceof TileEntityMechanism) {
            this.currentPulley = (TileEntityMechanism)tileEntity;
        }
        if (this.currentPulley != null) {
            long time = System.currentTimeMillis();
            int timeDif = this.prevTime <= 0L ? 0 : (int)(time - this.prevTime);
            this.prevTime = time;
            LiftMotion motion = this.currentPulley.getMotion(this, this.totalMove, timeDif);
            this.field_70165_t = motion.pos.getX();
            this.field_70163_u = motion.pos.getY();
            this.field_70161_v = motion.pos.getZ();
            this.field_70177_z = motion.yaw;
            this.field_70125_A = motion.pitch;
            this.totalMove = motion.move;
            this.func_174826_a(this.func_174813_aQ().func_72317_d(this.field_70165_t, this.field_70163_u, this.field_70161_v));
            if (motion.mecha != this.currentPulley) {
                this.setMecha(motion.mecha);
            }
        }
    }

    @Override
    protected void updateFallState() {
    }

    @Override
    protected Vec3 getMotionVec() {
        return Vec3.ZERO;
    }

    public void setMecha(TileEntityMechanism mecha) {
        this.currentPulley = mecha;
        this.currentPulleyPos = mecha.func_174877_v();
    }

    @Override
    protected ItemStack getVehicleItem() {
        return new ItemStack(RTMItem.itemVehicle, 1, VehicleType.LIFT.id);
    }

    @Override
    protected ResourceType getSubType() {
        return RTMResource.VEHICLE_LIFT;
    }
}

