/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.entity.vehicle;

import jp.ngt.ngtlib.math.PooledVec3;
import jp.ngt.ngtlib.math.Vec3;
import jp.ngt.rtm.RTMItem;
import jp.ngt.rtm.RTMResource;
import jp.ngt.rtm.entity.vehicle.EntityVehicle;
import jp.ngt.rtm.modelpack.ResourceType;
import jp.ngt.rtm.modelpack.cfg.VehicleConfig;
import jp.ngt.rtm.modelpack.modelset.ModelSetVehicle;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityPlane
extends EntityVehicle {
    public EntityPlane(World world) {
        super(world);
        this.field_70138_W = 0.5f;
    }

    @Override
    protected boolean shouldUpdateMotion() {
        return true;
    }

    @Override
    protected void updateFallState() {
        boolean hovering;
        boolean bl = hovering = ((VehicleConfig)((ModelSetVehicle)this.getResourceState().getResourceSet()).getConfig()).hoveringSpeed != 0.0f;
        if (hovering) {
            this.field_70181_x *= 0.8;
        } else if (this.speed == 0.0) {
            super.updateFallState();
        }
    }

    @Override
    protected void updateMotion(EntityLivingBase entity, float moveStrafe, float moveForward) {
        float maxYaw;
        VehicleConfig cfg = (VehicleConfig)((ModelSetVehicle)this.getResourceState().getResourceSet()).getConfig();
        boolean hovering = cfg.hoveringSpeed != 0.0f;
        this.speed += (double)(moveForward * cfg.getAcceleration(this.field_70122_E));
        float maxSpeed = cfg.getMaxSpeed(this.field_70122_E);
        float f0 = moveStrafe * cfg.getYawCoefficient(this.field_70122_E);
        if (!cfg.changeYawOnStopping) {
            f0 = (float)((double)f0 * (this.speed / (double)maxSpeed));
        }
        if (f0 > (maxYaw = cfg.getMaxYaw(this.field_70122_E))) {
            f0 = maxYaw;
        } else if (f0 < -maxYaw) {
            f0 = -maxYaw;
        }
        this.field_70177_z += f0;
        if (this.speed > (double)maxSpeed) {
            this.speed = maxSpeed;
        } else if (this.speed < 0.0) {
            if (hovering) {
                if (this.speed < (double)(-maxSpeed)) {
                    this.speed = -maxSpeed;
                }
            } else {
                this.speed = 0.0;
            }
        }
        Vec3 vec = this.getMotionVec();
        this.field_70159_w = vec.getX();
        this.field_70179_y = vec.getZ();
        double d0 = 0.05 * (1.0 - this.speed / (double)maxSpeed);
        if (!hovering) {
            this.field_70181_x = vec.getY() - d0;
        }
        if (moveForward == 0.0f) {
            this.speed *= (double)cfg.getFriction(this.field_70122_E);
        }
        if (Math.abs(this.speed) < 0.001) {
            this.speed = 0.0;
            this.field_70179_y = 0.0;
            this.field_70159_w = 0.0;
        }
        this.rotationRoll = this.speed > 0.0 && !this.field_70122_E ? moveStrafe * (float)(this.speed / (double)maxSpeed) * -cfg.getRollCoefficient(this.field_70122_E) : (this.rotationRoll *= 0.75f);
        if (Math.abs(this.rotationRoll) < 0.01f) {
            this.rotationRoll = 0.0f;
        }
    }

    @Override
    protected Vec3 getMotionVec() {
        if (this.field_70122_E && this.field_70125_A < 0.0f || this.field_70171_ac) {
            return super.getMotionVec();
        }
        Vec3 vec = PooledVec3.create((double)0.0, (double)0.0, (double)this.speed);
        vec = vec.rotateAroundX(this.field_70125_A);
        vec = vec.rotateAroundY(this.field_70177_z);
        return vec;
    }

    @Override
    protected void updateRotation() {
        this.field_70125_A *= 0.99f;
        if (Math.abs(this.field_70125_A) < 0.01f) {
            this.field_70125_A = 0.0f;
        }
    }

    @Override
    public void setUpDown(int par1) {
        VehicleConfig cfg = (VehicleConfig)((ModelSetVehicle)this.getResourceState().getResourceSet()).getConfig();
        if (cfg.hoveringSpeed != 0.0f) {
            this.field_70181_x += (double)((float)par1 * cfg.hoveringSpeed);
        } else if (this.speed > 0.0 && par1 != 0) {
            this.field_70125_A += cfg.getPitchCoefficient(this.field_70122_E) * (float)par1 * (float)(this.speed / (double)cfg.getMaxSpeed(this.field_70122_E));
            if (this.field_70122_E && this.field_70125_A < 1.0f) {
                this.field_70125_A = 0.0f;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean disableUnmount() {
        float speed = this.getSpeed2();
        boolean onGround = this.isOnGround();
        boolean hovering = ((VehicleConfig)((ModelSetVehicle)this.getResourceState().getResourceSet()).getConfig()).hoveringSpeed != 0.0f;
        BlockPos pos = this.func_180425_c().func_177977_b();
        AxisAlignedBB aabb = this.func_130014_f_().func_180495_p(pos).func_185890_d((IBlockAccess)this.func_130014_f_(), pos);
        if (aabb != null) {
            aabb = aabb.func_186670_a(pos);
        }
        boolean onBlock = aabb != null && aabb.field_72337_e >= this.field_70163_u;
        return !onGround && (speed > 0.0f || hovering) && !onBlock;
    }

    @Override
    protected ItemStack getVehicleItem() {
        return new ItemStack(RTMItem.itemVehicle, 1, 2);
    }

    @Override
    protected ResourceType getSubType() {
        return RTMResource.VEHICLE_PLANE;
    }
}

