/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.entity.vehicle;

import java.util.List;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.math.PooledVec3;
import jp.ngt.ngtlib.math.Vec3;
import jp.ngt.ngtlib.util.PermissionManager;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.entity.vehicle.EntityVehicleBase;
import jp.ngt.rtm.entity.vehicle.VehicleController;
import jp.ngt.rtm.entity.vehicle.VehicleNGTO;
import jp.ngt.rtm.modelpack.cfg.VehicleConfig;
import jp.ngt.rtm.modelpack.modelset.ModelSetVehicle;
import jp.ngt.rtm.rail.BlockLargeRailBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityVehicle
extends EntityVehicleBase<ModelSetVehicle> {
    private static final DataParameter<Byte> ON_GROUND = EntityDataManager.func_187226_a(EntityVehicle.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Float> SPEED = EntityDataManager.func_187226_a(EntityVehicle.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> SPEED2 = EntityDataManager.func_187226_a(EntityVehicle.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> MOV_FOR = EntityDataManager.func_187226_a(EntityVehicle.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> MOV_STR = EntityDataManager.func_187226_a(EntityVehicle.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<NBTTagCompound> NGTO = EntityDataManager.func_187226_a(EntityVehicle.class, (DataSerializer)DataSerializers.field_192734_n);
    protected double speed;
    public float vibration;
    private float prevPitchDif;
    private float prevRollDif;
    public float accelerationStrafe;
    public float accelerationForward;
    private int accelerationDecCount;
    private VehicleNGTO vngto;
    public final VehicleController controller = new VehicleController();

    public EntityVehicle(World world) {
        super(world);
        this.func_70105_a(2.0f, 2.0f);
        if (world.field_72995_K) {
            this.seatRotation = -45;
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(ON_GROUND, (Object)0);
        this.func_184212_Q().func_187214_a(SPEED, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(SPEED2, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(MOV_FOR, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(MOV_STR, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(NGTO, (Object)new NBTTagCompound());
    }

    @Override
    public AxisAlignedBB func_70114_g(Entity entity) {
        return entity.func_70104_M() ? null : entity.func_174813_aQ();
    }

    public double func_70042_X() {
        return 0.0;
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setNGTO(VehicleNGTO.readFromNBT(nbt.func_74775_l("NGTO"), false));
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.getNGTO() != null) {
            nbt.func_74782_a("NGTO", (NBTBase)this.getNGTO().writeToNBT());
        }
    }

    @Override
    public void onVehicleUpdate() {
        super.onVehicleUpdate();
        this.updateVibration();
        if (!this.field_70170_p.field_72995_K) {
            if (this.getFirstPassenger() == null) {
                this.controller.onUpdate(this);
            }
            this.setOnGround(this.field_70122_E);
            this.setSpeed((float)this.speed);
            this.setSpeed2((float)this.speed);
            this.setAccelerationForward(this.accelerationForward);
            this.setAccelerationStrafe(this.accelerationStrafe);
            this.updateRotation();
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
    }

    @Override
    protected void updateFallState() {
        if (this.field_70122_E) {
            this.field_70181_x = 0.0;
        } else {
            super.updateFallState();
        }
    }

    @Override
    protected void updateMovement() {
        if (this.accelerationDecCount > 0) {
            float f0 = (float)(this.accelerationDecCount - 1) / (float)this.accelerationDecCount;
            this.accelerationForward *= f0;
            this.accelerationStrafe *= f0;
        }
        if (this.shouldUpdateMotion() && this.getFirstPassenger() != null && this.getFirstPassenger() instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)this.getFirstPassenger();
            this.updateMotion(living, living.field_70702_br, living.field_191988_bg);
        }
        super.updateMovement();
    }

    @Override
    protected void applyPhysicalEffect() {
        VehicleConfig cfg = (VehicleConfig)((ModelSetVehicle)this.getResourceState().getResourceSet()).getConfig();
        if (!this.shouldUpdateMotion()) {
            if (this.field_70122_E) {
                this.speed *= (double)cfg.getFriction(this.field_70122_E);
                this.field_70159_w *= 0.9;
                this.field_70179_y *= 0.9;
                if (cfg.hoveringSpeed == 0.0f || this.field_70181_x < 0.0) {
                    this.field_70181_x = 0.0;
                }
            } else {
                this.speed *= 0.9999;
                super.applyPhysicalEffect();
                if (cfg.hoveringSpeed != 0.0f) {
                    this.field_70159_w *= 0.9;
                    this.field_70179_y *= 0.9;
                }
            }
        }
    }

    protected void updateVibration() {
        double dxz = this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y;
        if (this.vibration > 0.0f) {
            this.vibration = 0.0f;
        } else {
            float[] v = ((VehicleConfig)((ModelSetVehicle)this.getResourceState().getResourceSet()).getConfig()).vibration;
            this.vibration = dxz > 0.0 ? v[1] : v[0];
        }
    }

    protected boolean shouldUpdateMotion() {
        return this.field_70122_E;
    }

    @Override
    protected void updateBlockCollisionState() {
        int x = NGTMath.floor((double)this.field_70165_t);
        int y = (int)this.func_174813_aQ().field_72338_b;
        int z = NGTMath.floor((double)this.field_70161_v);
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState state = this.func_130014_f_().func_180495_p(pos);
        boolean isAir = state.func_177230_c() == Blocks.field_150350_a;
        boolean isLiquid = state.func_185904_a().func_76224_d();
        if (isAir || isLiquid || state.func_185900_c((IBlockAccess)this.field_70170_p, pos) == null) {
            pos = pos.func_177977_b();
            state = this.func_130014_f_().func_180495_p(pos);
            this.field_70171_ac = isLiquid;
        }
    }

    @Override
    protected void updateEntityCollisionState() {
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(0.25, 0.25, 0.25));
        if (list != null && !list.isEmpty()) {
            for (int k = 0; k < list.size(); ++k) {
                Entity entity = (Entity)list.get(k);
                if (entity == this.getFirstPassenger() || !entity.func_70104_M()) continue;
                this.func_70108_f(entity);
            }
        }
    }

    protected void updateMotion(EntityLivingBase entity, float moveStrafe, float moveForward) {
        VehicleConfig cfg = (VehicleConfig)((ModelSetVehicle)this.getResourceState().getResourceSet()).getConfig();
        this.speed += (double)(moveForward * cfg.getAcceleration(this.field_70122_E));
        float maxSpeed = cfg.getMaxSpeed(this.field_70122_E);
        float f0 = moveStrafe * cfg.getYawCoefficient(this.field_70122_E);
        f0 = (float)((double)f0 * (cfg.changeYawOnStopping ? (double)(this.speed >= 0.0 ? 1.0f : -1.0f) : this.speed / (double)maxSpeed));
        float maxYaw = cfg.getMaxYaw(this.field_70122_E);
        f0 = f0 > maxYaw ? maxYaw : (f0 < -maxYaw ? -maxYaw : f0);
        this.field_70177_z += f0;
        this.speed = this.speed > (double)maxSpeed ? (double)maxSpeed : (this.speed < (double)(-maxSpeed) ? (double)(-maxSpeed) : this.speed);
        Vec3 vec = this.getMotionVec();
        this.field_70159_w = vec.getX();
        this.field_70179_y = vec.getZ();
        if (moveForward == 0.0f) {
            this.speed *= (double)cfg.getFriction(this.field_70122_E);
        }
        if (Math.abs(this.speed) < 0.001) {
            this.speed = 0.0;
            this.field_70179_y = 0.0;
            this.field_70159_w = 0.0;
        }
        this.accelerationForward = moveForward;
        this.accelerationStrafe = moveStrafe;
        this.accelerationDecCount = 5;
    }

    protected Vec3 getMotionVec() {
        VehicleConfig cfg = (VehicleConfig)((ModelSetVehicle)this.getResourceState().getResourceSet()).getConfig();
        float maxSpeed = cfg.getMaxSpeed(this.field_70122_E);
        float f0 = (float)(1.0 - this.speed / (double)maxSpeed);
        float f1 = this.field_70126_B + NGTMath.wrapAngle((float)(this.field_70177_z - this.field_70126_B)) * f0;
        float yaw2 = this.field_70122_E || this.field_70171_ac ? f1 : this.field_70177_z;
        Vec3 vec = PooledVec3.create((double)0.0, (double)0.0, (double)this.speed);
        vec = vec.rotateAroundY(yaw2);
        return vec;
    }

    protected void updateRotation() {
        float prevPitch = this.field_70125_A;
        float prevRoll = this.rotationRoll;
        float pitch = this.field_70125_A;
        float roll = this.rotationRoll;
        if (this.field_70122_E) {
            if (this.field_70159_w != 0.0 || this.field_70179_y != 0.0) {
                double hFront = this.getBlockHeight(this.field_70177_z);
                double hBack = this.getBlockHeight(this.field_70177_z + 180.0f);
                double hLeft = this.getBlockHeight(this.field_70177_z + 90.0f);
                double hRight = this.getBlockHeight(this.field_70177_z - 90.0f);
                pitch = (float)NGTMath.toDegrees((double)Math.atan2(hFront - hBack, this.field_70130_N));
                roll = (float)NGTMath.toDegrees((double)Math.atan2(hLeft - hRight, this.field_70130_N));
            } else {
                pitch *= 0.75f;
                roll *= 0.75f;
            }
        } else {
            pitch *= 0.75f;
            roll *= 0.75f;
        }
        if (Math.abs(pitch) < 0.01f) {
            pitch = 0.0f;
        }
        if (Math.abs(roll) < 0.01f) {
            roll = 0.0f;
        }
        float pitchDif = pitch - prevPitch;
        pitch = prevPitch + (pitchDif + this.prevPitchDif) * 0.5f;
        this.prevPitchDif = pitch - prevPitch;
        float rollDif = roll - prevRoll;
        roll = prevRoll + (rollDif + this.prevRollDif) * 0.5f;
        this.prevRollDif = roll - prevRoll;
        this.field_70125_A = pitch;
        this.rotationRoll = roll;
    }

    private double getBlockHeight(float yaw) {
        int blockY;
        float rad = NGTMath.toRadians((float)yaw);
        double r = (double)this.field_70130_N * 0.5;
        int blockX = NGTMath.floor((double)(this.field_70165_t + (double)MathHelper.func_76126_a((float)rad) * r));
        int blockZ = NGTMath.floor((double)(this.field_70161_v + (double)MathHelper.func_76134_b((float)rad) * r));
        BlockPos pos = new BlockPos(blockX, blockY, blockZ);
        IBlockState state = null;
        AxisAlignedBB aabb = null;
        for (blockY = NGTMath.floor((double)this.field_70163_u) + (int)this.field_70138_W; blockY > 0; --blockY) {
            state = this.field_70170_p.func_180495_p(pos);
            aabb = state.func_177230_c().func_180646_a(state, (IBlockAccess)this.field_70170_p, pos);
            if (aabb != null) {
                double y = aabb.field_72337_e;
                if (state.func_177230_c() instanceof BlockLargeRailBase) {
                    y -= 256.0;
                }
                return y + (double)blockY - 1.0;
            }
            pos = pos.func_177977_b();
        }
        return this.field_70163_u;
    }

    @Override
    public Vec3 getRiderPos(Entity passenger) {
        Vec3 vec = super.getRiderPos(passenger);
        if (this.getNGTO() != null) {
            VehicleNGTO obj = this.getNGTO();
            vec = PooledVec3.create((double)(obj.riderPosX * obj.scale), (double)(obj.riderPosY * obj.scale), (double)(obj.riderPosZ * obj.scale));
        }
        return vec;
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
        super.func_184231_a(y, onGroundIn, state, pos);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public void setUpDown(int par1) {
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af()) {
            if (this.field_70170_p.field_72995_K) {
                player.openGui((Object)RTMCore.instance, (int)RTMCore.guiIdSelectEntityModel, player.field_70170_p, this.func_145782_y(), 0, 0);
            }
            return true;
        }
        if (this.getFirstPassenger() instanceof EntityPlayer && this.getFirstPassenger() != player) {
            return true;
        }
        if (!this.field_70170_p.field_72995_K) {
            player.func_184220_m((Entity)this);
        }
        return true;
    }

    public boolean func_70097_a(DamageSource source, float par2) {
        EntityPlayer player;
        if (!this.field_70170_p.field_72995_K && source.func_76346_g() instanceof EntityPlayer && PermissionManager.INSTANCE.hasPermission((ICommandSender)(player = (EntityPlayer)source.func_76346_g()), "editVehicle")) {
            this.func_70106_y();
            if (!player.field_71075_bZ.field_75098_d) {
                this.func_70099_a(this.getVehicleItem(), 0.5f);
            }
        }
        return true;
    }

    protected abstract ItemStack getVehicleItem();

    public void func_70108_f(Entity entity) {
        VehicleConfig cfg;
        float strength;
        double dxz;
        if (!this.field_70170_p.field_72995_K && entity != this.getFirstPassenger() && entity instanceof EntityLivingBase && (dxz = this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y) > 0.0 && (strength = (float)(dxz / (double)(cfg = (VehicleConfig)((ModelSetVehicle)this.getResourceState().getResourceSet()).getConfig()).getMaxSpeed(this.field_70122_E))) > 0.5f) {
            entity.func_70097_a(DamageSource.func_92087_a((Entity)this), strength);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setRollAndSpeed(float speed, float roll) {
        this.vehicleRoll = roll;
    }

    @Override
    public float getSpeed() {
        return ((Float)this.func_184212_Q().func_187225_a(SPEED)).floatValue();
    }

    @Override
    public void setSpeed(float par1) {
        this.func_184212_Q().func_187227_b(SPEED, (Object)Float.valueOf(par1));
    }

    protected float getSpeed2() {
        return ((Float)this.func_184212_Q().func_187225_a(SPEED2)).floatValue();
    }

    protected void setSpeed2(float par1) {
        this.func_184212_Q().func_187227_b(SPEED2, (Object)Float.valueOf(par1));
    }

    public boolean isOnGround() {
        return (Byte)this.func_184212_Q().func_187225_a(ON_GROUND) == 1;
    }

    protected void setOnGround(boolean par1) {
        byte value = (byte)(par1 ? 1 : 0);
        this.func_184212_Q().func_187227_b(ON_GROUND, (Object)value);
    }

    public float getAccelerationForward() {
        return ((Float)this.func_184212_Q().func_187225_a(MOV_FOR)).floatValue();
    }

    public void setAccelerationForward(float par1) {
        this.func_184212_Q().func_187227_b(MOV_FOR, (Object)Float.valueOf(par1));
    }

    public float getAccelerationStrafe() {
        return ((Float)this.func_184212_Q().func_187225_a(MOV_STR)).floatValue();
    }

    public void setAccelerationStrafe(float par1) {
        this.func_184212_Q().func_187227_b(MOV_STR, (Object)Float.valueOf(par1));
    }

    @Override
    public VehicleNGTO getNGTO() {
        if (this.vngto == null) {
            this.vngto = VehicleNGTO.readFromNBT((NBTTagCompound)this.func_184212_Q().func_187225_a(NGTO), false);
        }
        return this.vngto;
    }

    public void setNGTO(VehicleNGTO ngto) {
        if (ngto != null) {
            this.func_184212_Q().func_187227_b(NGTO, (Object)ngto.writeToNBT());
        }
    }

    @Override
    public void updateResourceState() {
        super.updateResourceState();
        VehicleConfig cfg = (VehicleConfig)((ModelSetVehicle)this.getResourceState().getResourceSet()).getConfig();
        this.func_70105_a(cfg.getSize()[0], cfg.getSize()[1]);
    }
}

