/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.entity.vehicle;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.ngtlib.network.PacketNBT;
import jp.ngt.ngtlib.util.NGTUtil;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.entity.train.EntityBogie;
import jp.ngt.rtm.entity.train.EntityTrainBase;
import jp.ngt.rtm.entity.vehicle.EntityVehicleBase;
import jp.ngt.rtm.network.PacketVehicleMovement;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.EntityTrackerEntry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketEntityAttach;
import net.minecraft.network.play.server.SPacketEntityMetadata;
import net.minecraft.network.play.server.SPacketSetPassengers;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public final class VehicleTrackerEntry
extends EntityTrackerEntry {
    private Entity trackedEntity;
    private int updateFrequency;
    private boolean updatedPlayerVisibility;
    private List<Entity> passengers = Collections.emptyList();
    private double posX;
    private double posY;
    private double posZ;
    private boolean isDataInitialized;
    private Entity rider;
    private boolean isTrain;

    public VehicleTrackerEntry(Entity par2) {
        super(par2, 256, 256, 3, false);
        this.trackedEntity = par2;
        this.updateFrequency = 3;
        this.isTrain = this.trackedEntity instanceof EntityTrainBase || this.trackedEntity instanceof EntityBogie;
    }

    public boolean equals(Object obj) {
        return obj instanceof VehicleTrackerEntry ? ((VehicleTrackerEntry)((Object)obj)).trackedEntity.func_145782_y() == this.trackedEntity.func_145782_y() : false;
    }

    public int hashCode() {
        return this.trackedEntity.func_145782_y();
    }

    public void setPlayers(Set<EntityPlayerMP> par1) {
        this.field_73134_o.clear();
        this.field_73134_o.addAll(par1);
    }

    public void func_73122_a(List<EntityPlayer> par1) {
        List list;
        this.field_73133_n = false;
        if (!this.isDataInitialized || this.trackedEntity.func_70092_e(this.posX, this.posY, this.posZ) > 16.0) {
            this.posX = this.trackedEntity.field_70165_t;
            this.posY = this.trackedEntity.field_70163_u;
            this.posZ = this.trackedEntity.field_70161_v;
            this.isDataInitialized = true;
            this.field_73133_n = true;
            this.func_73125_b(par1);
        }
        if (!(list = this.trackedEntity.func_184188_bt()).equals(this.passengers)) {
            this.passengers = list;
            this.func_151259_a((Packet<?>)new SPacketSetPassengers(this.trackedEntity));
        }
        if (this.field_73136_m % this.updateFrequency == 0 && this.trackedEntity.func_184187_bx() == null) {
            RTMCore.NETWORK_WRAPPER.sendToAll((IMessage)new PacketVehicleMovement(this.trackedEntity, false));
            if (this.isTrain) {
                // empty if block
            }
        }
        this.sendMetadataToAllAssociatedPlayers();
        ++this.field_73136_m;
    }

    private void sendMetadataToAllAssociatedPlayers() {
        EntityDataManager entitydatamanager = this.trackedEntity.func_184212_Q();
        if (entitydatamanager.func_187223_a()) {
            this.func_151261_b((Packet<?>)new SPacketEntityMetadata(this.trackedEntity.func_145782_y(), entitydatamanager, false));
        }
    }

    public void func_151259_a(Packet<?> packetIn) {
        for (EntityPlayerMP entityplayermp : this.field_73134_o) {
            entityplayermp.field_71135_a.func_147359_a(packetIn);
        }
    }

    public void func_151261_b(Packet<?> packetIn) {
        this.func_151259_a(packetIn);
    }

    public void func_73119_a() {
        for (EntityPlayerMP entityplayermp : this.field_73134_o) {
            this.trackedEntity.func_184203_c(entityplayermp);
            entityplayermp.func_152339_d(this.trackedEntity);
        }
    }

    public void func_73118_a(EntityPlayerMP playerMP) {
        if (this.field_73134_o.contains(playerMP)) {
            this.trackedEntity.func_184203_c(playerMP);
            playerMP.func_152339_d(this.trackedEntity);
            this.field_73134_o.remove(playerMP);
        }
    }

    public void func_73117_b(EntityPlayerMP par1) {
        if (par1 != this.trackedEntity) {
            if (this.func_180233_c(par1)) {
                if (!this.field_73134_o.contains(par1) && (this.isPlayerWatchingThisChunk(par1) || this.trackedEntity.field_98038_p)) {
                    this.field_73134_o.add(par1);
                    Packet packet = FMLNetworkHandler.getEntitySpawningPacket((Entity)this.trackedEntity);
                    par1.field_71135_a.func_147359_a(packet);
                    if (!this.trackedEntity.func_184212_Q().func_187228_d()) {
                        par1.field_71135_a.func_147359_a((Packet)new SPacketEntityMetadata(this.trackedEntity.func_145782_y(), this.trackedEntity.func_184212_Q(), true));
                    }
                    PacketNBT.sendToClient((Entity)this.trackedEntity);
                    if (this.trackedEntity.func_184187_bx() != null) {
                        par1.field_71135_a.func_147359_a((Packet)new SPacketEntityAttach(this.trackedEntity, this.trackedEntity.func_184187_bx()));
                    }
                    ForgeEventFactory.onStartEntityTracking((Entity)this.trackedEntity, (EntityPlayer)par1);
                }
            } else if (this.field_73134_o.contains(par1)) {
                this.field_73134_o.remove(par1);
                par1.func_152339_d(this.trackedEntity);
                ForgeEventFactory.onStopEntityTracking((Entity)this.trackedEntity, (EntityPlayer)par1);
            }
        }
    }

    public boolean func_180233_c(EntityPlayerMP playerMP) {
        return true;
    }

    private boolean isPlayerWatchingThisChunk(EntityPlayerMP playerMP) {
        return playerMP.func_71121_q().func_184164_w().func_72694_a(playerMP, this.trackedEntity.field_70176_ah, this.trackedEntity.field_70164_aj);
    }

    public void func_73125_b(List<EntityPlayer> players) {
        for (int i = 0; i < players.size(); ++i) {
            this.func_73117_b((EntityPlayerMP)players.get(i));
        }
    }

    public static boolean trackingVehicle(Entity par1) {
        EntityTracker tracker;
        Set<EntityTrackerEntry> trackedEntities;
        if (!(par1 instanceof EntityVehicleBase) && !(par1 instanceof EntityBogie)) {
            throw new IllegalArgumentException("This entity is not Vehicle");
        }
        if (par1.field_70170_p instanceof WorldServer && (trackedEntities = VehicleTrackerEntry.getTrackedEntities(tracker = ((WorldServer)par1.field_70170_p).func_73039_n())) != null) {
            VehicleTrackerEntry tte = new VehicleTrackerEntry(par1);
            EntityTrackerEntry trackerEntry = null;
            for (EntityTrackerEntry entry : trackedEntities) {
                if (entry == null || !entry.equals((Object)tte)) continue;
                if (entry instanceof VehicleTrackerEntry) break;
                trackerEntry = entry;
                break;
            }
            if (trackerEntry != null) {
                trackedEntities.remove(trackerEntry);
                tte.setPlayers(trackerEntry.field_73134_o);
                trackedEntities.add(tte);
                return true;
            }
        }
        NGTLog.debug((String)"Failed to change tracking entry (VTE)");
        return false;
    }

    protected static Set<EntityTrackerEntry> getTrackedEntities(EntityTracker tracker) {
        return (Set)NGTUtil.getField(EntityTracker.class, (Object)tracker, (String[])new String[]{"entries", "field_72793_b"});
    }
}

