/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.gui;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jp.ngt.ngtlib.gui.GuiScreenCustom;
import jp.ngt.ngtlib.io.FileType;
import jp.ngt.ngtlib.io.NGTFileLoader;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.ngtlib.renderer.model.EncryptedModel;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiConvertModel
extends GuiScreenCustom {
    private EntityPlayer player;
    private GuiButton buttonDone;
    private File modelFile;
    private List<File> jsonList = new ArrayList<File>();

    public GuiConvertModel(EntityPlayer player) {
        this.player = player;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int hw = this.field_146294_l / 2;
        this.field_146292_n.clear();
        this.buttonDone = new GuiButton(0, hw - 155, this.field_146295_m - 28, 150, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        this.buttonDone.field_146124_l = false;
        this.field_146292_n.add(this.buttonDone);
        this.field_146292_n.add(new GuiButton(1, hw + 5, this.field_146295_m - 28, 150, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(100, 20, 40, 100, 20, "Load Model"));
        this.field_146292_n.add(new GuiButton(101, 20, 70, 100, 20, "Load JSON"));
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0) {
            this.exportFile();
            this.field_146297_k.func_147108_a(null);
        } else if (button.field_146127_k == 1) {
            this.field_146297_k.func_147108_a(null);
        } else if (button.field_146127_k == 100) {
            this.selectModel();
        } else if (button.field_146127_k == 101) {
            this.selectJSON();
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.func_146276_q_();
        super.func_73863_a(par1, par2, par3);
        if (this.modelFile != null) {
            this.func_73731_b(this.field_146289_q, this.modelFile.getAbsolutePath(), 140, 45, 0xFFFFFF);
        }
        for (int i = 0; i < this.jsonList.size(); ++i) {
            this.func_73731_b(this.field_146289_q, this.jsonList.get(i).getAbsolutePath(), 140, 75 + i * 20, 0xFFFFFF);
        }
    }

    private void selectModel() {
        File file = NGTFileLoader.selectFile((FileType[])new FileType[]{FileType.OBJ, FileType.MQO});
        if (file != null) {
            this.buttonDone.field_146124_l = true;
            this.modelFile = file;
            NGTLog.debug((String)"Add model file : %s", (Object[])new Object[]{file.getAbsolutePath()});
        }
    }

    private void selectJSON() {
        File file = NGTFileLoader.selectFile((FileType[])new FileType[]{FileType.JSON});
        if (file != null) {
            this.jsonList.add(file);
            NGTLog.debug((String)"Add json file : %s", (Object[])new Object[]{file.getAbsolutePath()});
        }
    }

    private void exportFile() {
        String fileName = this.modelFile.getName();
        fileName = fileName.substring(0, fileName.lastIndexOf(46));
        fileName = fileName + "." + FileType.NPM.getExtension();
        File file = new File((File)NGTFileLoader.getModsDir().get(0), fileName);
        try {
            EncryptedModel model = new EncryptedModel(this.modelFile, this.jsonList.toArray(new File[this.jsonList.size()]));
            file.createNewFile();
            model.exportData(file);
            NGTLog.sendChatMessage((ICommandSender)this.player, (String)("Export to : " + file.getAbsolutePath()), (Object[])new Object[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            NGTLog.sendChatMessage((ICommandSender)this.player, (String)"Failed to export file.", (Object[])new Object[0]);
        }
    }
}

