/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.gui;

import java.util.ArrayList;
import java.util.List;
import jp.ngt.ngtlib.gui.GuiScreenCustom;
import jp.ngt.ngtlib.gui.GuiTextFieldCustom;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.math.Vec3;
import jp.ngt.ngtlib.network.PacketNBT;
import jp.ngt.ngtlib.renderer.GLHelper;
import jp.ngt.ngtlib.renderer.NGTRenderHelper;
import jp.ngt.ngtlib.renderer.NGTTessellator;
import jp.ngt.ngtlib.util.NGTUtil;
import jp.ngt.ngtlib.util.NGTUtilClient;
import jp.ngt.rtm.block.decoration.DecorationModel;
import jp.ngt.rtm.block.decoration.DecorationStore;
import jp.ngt.rtm.block.decoration.Element;
import jp.ngt.rtm.block.decoration.Face;
import jp.ngt.rtm.block.tileentity.RenderDecoration;
import jp.ngt.rtm.gui.GuiButtonIcon;
import jp.ngt.rtm.gui.GuiSelectIcon;
import jp.ngt.rtm.item.ItemDecoration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.Project;

@SideOnly(value=Side.CLIENT)
public class GuiDecorationBlock
extends GuiScreenCustom {
    private static final int W_ELEMENT = 60;
    private static final int W_FACE = 60;
    private static final int W_VERTEX = 60;
    private static final int W_UV = 40;
    private static final int H_FIELD = 20;
    private static final int THICKNESS = 3;
    private static final int Y_START = 35;
    private RenderDecoration renderer;
    private EntityPlayer player;
    private GuiButton buttonDone;
    private DecorationModel model;
    private GuiTextFieldCustom modelNameField;
    private final float[] moveVec = new float[3];
    private GuiTextFieldCustom moveVecField;
    private boolean lockUV = true;
    private List<GuiTextFieldCustom> elementList = new ArrayList<GuiTextFieldCustom>();
    private GuiTextFieldCustom selectedElemntField;
    private Element selectedElemnt;
    private List<GuiTextFieldCustom> faceList = new ArrayList<GuiTextFieldCustom>();
    private GuiTextFieldCustom selectedFaceField;
    private Face selectedFace;
    private GuiTextFieldCustom faceTextureField;
    private GuiTextFieldCustom faceShadowField;
    private int faceTypeIndex;
    private List<GuiTextFieldCustom> vertexList = new ArrayList<GuiTextFieldCustom>();
    private List<GuiTextFieldCustom> uvList = new ArrayList<GuiTextFieldCustom>();
    private float[] selectedVertex;
    private GuiTextFieldCustom selectedObjectField;
    private Object selectedObject;
    private float rotationYaw;
    private float rotationPitch;

    public GuiDecorationBlock(EntityPlayer player) {
        this.player = player;
        this.renderer = new RenderDecoration();
        this.setModel(DecorationStore.INSTANCE.getModel(ItemDecoration.getModelName(player.func_184614_ca())));
    }

    public void setModel(DecorationModel par1) {
        this.model = par1;
        this.selectedElemnt = this.model.elements[0];
        this.selectedFace = this.selectedElemnt.faces[0];
    }

    public void func_73866_w_() {
        GuiTextFieldCustom field;
        int i;
        super.func_73866_w_();
        int hw = this.field_146294_l / 2;
        this.field_146292_n.clear();
        this.selectedObjectField = null;
        this.buttonDone = new GuiButton(0, hw - 155, this.field_146295_m - 28, 150, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        this.field_146292_n.add(this.buttonDone);
        this.field_146292_n.add(new GuiButton(1, hw + 5, this.field_146295_m - 28, 150, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])));
        int startX = this.field_146294_l - 245;
        int buttonY = 9;
        int hInc = 26;
        this.field_146292_n.add(new GuiButton(200, 30, 13, 50, 20, "load model"));
        this.field_146292_n.add(new GuiButton(201, 80, 13, 50, 20, "save model"));
        this.modelNameField = this.setTextField(30, 35, 100, 20, this.model.name);
        this.field_146292_n.add(new GuiButton(210, 30, this.field_146295_m - 82, 30, 20, "move"));
        this.field_146292_n.add(new GuiButton(211, 60, this.field_146295_m - 82, 70, 20, "lock UV : " + this.lockUV));
        this.moveVecField = this.setTextField(30, this.field_146295_m - 60, 100, 20, this.vtxToStr(this.moveVec, 0, 3));
        this.field_146292_n.add(new GuiButton(100, startX, buttonY, 20, 20, "+"));
        this.field_146292_n.add(new GuiButton(101, startX + 20, buttonY, 20, 20, "C"));
        this.field_146292_n.add(new GuiButton(102, startX + 40, buttonY, 20, 20, "-"));
        this.elementList.clear();
        for (i = 0; i < this.model.elements.length; ++i) {
            Element element = this.model.elements[i];
            field = this.setTextField(startX, 35 + i * hInc, 60, 20, element.name);
            this.elementList.add(field);
            field.setListner(() -> this.setElement(element, field));
            if (element == this.selectedElemnt) {
                this.selectedElemntField = field;
            }
            if (element != this.selectedObject) continue;
            this.selectedObjectField = field;
        }
        this.field_146292_n.add(new GuiButton(110, startX += 66, buttonY, 20, 20, "+"));
        this.field_146292_n.add(new GuiButton(111, startX + 20, buttonY, 20, 20, "C"));
        this.field_146292_n.add(new GuiButton(112, startX + 40, buttonY, 20, 20, "-"));
        this.faceList.clear();
        for (i = 0; i < this.selectedElemnt.faces.length; ++i) {
            Face face = this.selectedElemnt.faces[i];
            field = this.setTextField(startX, 35 + i * hInc, 60, 20, face.name);
            this.faceList.add(field);
            field.setListner(() -> this.setFace(face, field));
            if (face == this.selectedFace) {
                this.selectedFaceField = field;
            }
            if (face != this.selectedObject) continue;
            this.selectedObjectField = field;
        }
        this.field_146292_n.add(new GuiButtonIcon(120, startX += 66, 23, 32, 32, new IconElementTexture(this.selectedFace.texture)));
        this.field_146292_n.add(new GuiButton(121, startX + 35, 35, 40, 20, this.selectedFace.type.toString()));
        this.faceTypeIndex = this.selectedFace.type.ordinal();
        this.faceShadowField = this.setTextField(startX, 35 + hInc, 60, 20, String.valueOf(this.selectedFace.shadow));
        this.faceShadowField.setListner(() -> this.saveFieldToModel());
        this.vertexList.clear();
        for (i = 0; i < this.selectedFace.vertex.length; ++i) {
            float[] vtx = this.selectedFace.vertex[i];
            String s = this.vtxToStr(vtx, 0, 3);
            GuiTextFieldCustom field2 = this.setTextField(startX, 35 + (2 + i) * hInc, 60, 20, s);
            this.vertexList.add(field2);
            field2.setListner(() -> this.setVertex(vtx, field2));
            if (vtx != this.selectedObject) continue;
            this.selectedObjectField = field2;
        }
        startX += 66;
        this.uvList.clear();
        for (i = 0; i < this.selectedFace.vertex.length; ++i) {
            String s = this.vtxToStr(this.selectedFace.vertex[i], 3, 2);
            field = this.setTextField(startX, 35 + (2 + i) * hInc, 40, 20, s);
            field.setListner(() -> {
                this.selectedObject = null;
                this.saveFieldToModel();
            });
            this.uvList.add(field);
        }
    }

    protected void setElement(Element par1, GuiTextFieldCustom field) {
        if (par1 != this.selectedElemnt || par1 != this.selectedObject) {
            this.saveFieldToModel();
            this.selectedElemnt = par1;
            this.selectedObject = par1;
            this.selectedFace = this.selectedElemnt.faces[0];
            this.selectedVertex = this.selectedFace.vertex[0];
            this.func_73866_w_();
        }
    }

    protected void setFace(Face par1, GuiTextFieldCustom field) {
        if (par1 != this.selectedFace || par1 != this.selectedObject) {
            this.saveFieldToModel();
            this.selectedFace = par1;
            this.selectedObject = par1;
            this.selectedVertex = this.selectedFace.vertex[0];
            this.func_73866_w_();
        }
    }

    protected void setVertex(float[] par1, GuiTextFieldCustom field) {
        if (par1 != this.selectedVertex || par1 != this.selectedObject) {
            this.saveFieldToModel();
            this.selectedVertex = par1;
            this.selectedObject = par1;
            this.func_73866_w_();
        }
    }

    protected void saveFieldToModel() {
        int i;
        this.selectedFace.shadow = this.getFloat(this.faceShadowField.func_146179_b(), this.selectedFace.shadow);
        for (i = 0; i < this.selectedFace.vertex.length; ++i) {
            this.strToVtx(this.vertexList.get(i).func_146179_b(), this.selectedFace.vertex[i], 0);
        }
        for (i = 0; i < this.selectedFace.vertex.length; ++i) {
            this.strToVtx(this.uvList.get(i).func_146179_b(), this.selectedFace.vertex[i], 3);
        }
        for (i = 0; i < this.selectedElemnt.faces.length; ++i) {
            this.selectedElemnt.faces[i].name = this.faceList.get(i).func_146179_b();
        }
        for (i = 0; i < this.model.elements.length; ++i) {
            this.model.elements[i].name = this.elementList.get(i).func_146179_b();
        }
        this.model.name = this.modelNameField.func_146179_b();
    }

    private String vtxToStr(float[] vtx, int start, int len) {
        StringBuilder sb = new StringBuilder();
        for (int i = start; i < start + len; ++i) {
            sb.append(String.valueOf(vtx[i]));
            if (i >= start + len - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private void strToVtx(String s, float[] fa, int start) {
        String[] sa = s.split(",");
        for (int i = 0; i < sa.length; ++i) {
            fa[i + start] = this.getFloat(sa[i], fa[i + start]);
        }
    }

    private float getFloat(String s, float def) {
        try {
            float f = Float.valueOf(s).floatValue();
            return f;
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    private void editElement(int par1) {
        this.saveFieldToModel();
        if (par1 == 0 || par1 == 1) {
            ArrayList<Element> list = new ArrayList<Element>();
            NGTUtil.addArray(list, (Object[])this.model.elements);
            Element newElement = par1 == 0 ? Element.getDefaultElement() : this.selectedElemnt.clone();
            newElement.name = "element" + list.size() + 1;
            list.add(newElement);
            this.model.elements = list.toArray(new Element[list.size()]);
        } else if (this.model.elements.length >= 2) {
            ArrayList list = new ArrayList();
            NGTUtil.addArray(list, (Object[])this.model.elements);
            list.remove(this.selectedElemnt);
            this.model.elements = list.toArray(new Element[list.size()]);
        }
        this.func_73866_w_();
    }

    private void editFace(int par1) {
        this.saveFieldToModel();
        if (par1 == 0 || par1 == 1) {
            ArrayList<Face> list = new ArrayList<Face>();
            NGTUtil.addArray(list, (Object[])this.selectedElemnt.faces);
            Face newFace = par1 == 0 ? Face.getDefaultFace() : this.selectedFace.clone();
            newFace.name = "face" + list.size() + 1;
            list.add(newFace);
            this.selectedElemnt.faces = list.toArray(new Face[list.size()]);
        } else if (this.selectedElemnt.faces.length >= 2) {
            ArrayList list = new ArrayList();
            NGTUtil.addArray(list, (Object[])this.selectedElemnt.faces);
            list.remove(this.selectedFace);
            this.selectedElemnt.faces = list.toArray(new Face[list.size()]);
        }
        this.func_73866_w_();
    }

    public void setFaceTexture(String name) {
        this.selectedFace.texture = name;
    }

    private void openLoadModelGUI() {
        List<DecorationModel> list1 = DecorationStore.INSTANCE.getModels();
        ArrayList<GuiButtonIcon.IconElement> list2 = new ArrayList<GuiButtonIcon.IconElement>();
        for (DecorationModel res : list1) {
            list2.add(new IconElementModel(res));
        }
        this.field_146297_k.func_147108_a((GuiScreen)new GuiSelectIcon(this, list2, 64));
    }

    private void openIconSelectGUI() {
        List<ResourceLocation> list1 = DecorationStore.INSTANCE.getAllIcon();
        ArrayList<GuiButtonIcon.IconElement> list2 = new ArrayList<GuiButtonIcon.IconElement>();
        for (ResourceLocation res : list1) {
            list2.add(new IconElementTexture(res.toString()));
        }
        this.field_146297_k.func_147108_a((GuiScreen)new GuiSelectIcon(this, list2, 32));
    }

    private void saveModel() {
        this.saveFieldToModel();
        DecorationStore.INSTANCE.registerModelOnClient(this.model);
        ItemStack stack = this.player.func_184614_ca();
        ItemDecoration.setModel(stack, this.model.name);
        PacketNBT.sendToServer((EntityPlayer)this.player, (ItemStack)stack);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0) {
            this.saveModel();
            this.field_146297_k.func_147108_a(null);
        } else if (button.field_146127_k == 1) {
            this.field_146297_k.func_147108_a(null);
        } else if (button.field_146127_k >= 100 && button.field_146127_k <= 102) {
            this.editElement(button.field_146127_k - 100);
        } else if (button.field_146127_k >= 110 && button.field_146127_k <= 112) {
            this.editFace(button.field_146127_k - 110);
        } else if (button.field_146127_k == 120) {
            this.openIconSelectGUI();
        } else if (button.field_146127_k == 121) {
            ++this.faceTypeIndex;
            this.faceTypeIndex %= Face.FaceType.values().length;
            this.selectedFace.type = Face.FaceType.values()[this.faceTypeIndex];
            button.field_146126_j = this.selectedFace.type.toString();
        } else if (button.field_146127_k == 200) {
            this.openLoadModelGUI();
        } else if (button.field_146127_k == 201) {
            this.saveModel();
        } else if (button.field_146127_k == 210) {
            this.strToVtx(this.moveVecField.func_146179_b(), this.moveVec, 0);
            this.moveObject();
            this.func_73866_w_();
        } else if (button.field_146127_k == 211) {
            this.lockUV ^= true;
            button.field_146126_j = "lock UV : " + this.lockUV;
        }
    }

    private void moveObject() {
        if (this.selectedObject instanceof Element) {
            ((Element)this.selectedObject).addVec(this.moveVec, this.lockUV);
        } else if (this.selectedObject instanceof Face) {
            ((Face)this.selectedObject).addVec(this.moveVec, this.lockUV);
        } else if (this.selectedObject instanceof float[]) {
            Face.addVecToVertex((float[])this.selectedObject, this.selectedFace.type, this.moveVec, this.lockUV);
        }
    }

    protected void onTextFieldClicked(GuiTextField field) {
        this.saveFieldToModel();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        int color1 = 0x707070;
        int color2 = 0xA0A0A0;
        int color3 = 0xD0D0D0;
        int t2 = 6;
        int hInc = 26;
        int startX = this.field_146294_l - 245;
        int y2 = 20 + t2;
        int startY = 32 - y2;
        GL11.glDisable((int)3553);
        NGTTessellator tessellator = NGTTessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.setColorOpaque_I(color1);
        NGTRenderHelper.addQuadGuiFaceWithSize((float)(startX -= 3), (float)startY, (float)(60 + t2), (float)(this.elementList.size() * hInc + y2), (float)this.field_73735_i);
        tessellator.setColorOpaque_I(color2);
        NGTRenderHelper.addQuadGuiFaceWithSize((float)startX, (float)(this.selectedElemntField.field_146210_g - 3), (float)(60 + t2), (float)hInc, (float)this.field_73735_i);
        NGTRenderHelper.addQuadGuiFaceWithSize((float)(startX += 60 + t2), (float)startY, (float)(60 + t2), (float)(this.faceList.size() * hInc + y2), (float)this.field_73735_i);
        tessellator.setColorOpaque_I(color3);
        NGTRenderHelper.addQuadGuiFaceWithSize((float)startX, (float)(this.selectedFaceField.field_146210_g - 3), (float)(60 + t2), (float)hInc, (float)this.field_73735_i);
        NGTRenderHelper.addQuadGuiFaceWithSize((float)(startX += 60 + t2), (float)startY, (float)(60 + t2 + 40 + t2), (float)((this.vertexList.size() + 2) * hInc + y2), (float)this.field_73735_i);
        tessellator.draw();
        if (this.selectedObjectField != null) {
            tessellator.startDrawing(1);
            tessellator.setColorOpaque_I(0xFF0000);
            int sx = this.selectedObjectField.field_146209_f - 3;
            int sy = this.selectedObjectField.field_146210_g - 3;
            int w = this.selectedObjectField.field_146218_h + t2;
            int h = this.selectedObjectField.field_146219_i + t2;
            NGTRenderHelper.addQuadGuiFrameWithSize((float)sx, (float)sy, (float)w, (float)h, (float)this.field_73735_i);
            tessellator.draw();
        }
        GL11.glEnable((int)3553);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        float speed = 1.0f;
        if (Mouse.isButtonDown((int)1)) {
            this.rotationYaw = (float)(this.field_146294_l / 2 - mouseX) * speed;
            this.rotationPitch = (float)(this.field_146295_m / 2 - mouseY) * speed;
        }
        this.preRenderModel();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-7.5f, (float)0.0f, (float)-8.0f);
        GL11.glRotatef((float)this.rotationPitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)this.rotationYaw, (float)0.0f, (float)1.0f, (float)0.0f);
        float scale = 2.0f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        this.renderer.renderModel(this.model, false);
        GL11.glPopMatrix();
        this.postRenderModel();
    }

    public void preRenderModel() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        Project.gluPerspective((float)80.0f, (float)((float)this.field_146294_l / (float)this.field_146295_m), (float)5.0f, (float)1000.0f);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GLHelper.enableLighting();
        GL11.glEnable((int)2929);
        GL11.glEnable((int)32826);
    }

    public void postRenderModel() {
        GL11.glDisable((int)32826);
        GL11.glDisable((int)2929);
        GLHelper.disableLighting();
        GL11.glMatrixMode((int)5889);
        GL11.glViewport((int)0, (int)0, (int)this.field_146297_k.field_71443_c, (int)this.field_146297_k.field_71440_d);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GLHelper.disableLighting();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public class IconElementModel
    implements GuiButtonIcon.IconElement {
        private static final float ROTATION_PER_SEC = 90.0f;
        private final DecorationModel model;
        private float rotation;
        private long prevTime;
        private float roX = 20.0f;
        private float roY = 45.0f;
        private Vec3 roVec = new Vec3(0.0, 1.0, 0.0);

        public IconElementModel(DecorationModel par1) {
            this.model = par1;
            float sinX = NGTMath.sin((float)(-this.roX));
            this.roVec = new Vec3((double)(sinX * NGTMath.sin((float)(-this.roY))), (double)NGTMath.cos((float)(-this.roX)), (double)(sinX * NGTMath.cos((float)(-this.roY))));
        }

        @Override
        public void draw(GuiButtonIcon button, Minecraft mc, int par2, int par3) {
            long time = System.currentTimeMillis();
            float roInc = 90.0f * (float)(time - this.prevTime) * 0.001f;
            this.prevTime = time;
            this.rotation = (this.rotation + roInc) % 360.0f;
            float scale = 32.0f;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)button.field_146128_h, (float)button.field_146129_i, (float)button.getZLevel());
            GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
            GL11.glTranslatef((float)scale, (float)(-scale), (float)-32.0f);
            GL11.glRotatef((float)this.roX, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)this.roY, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)this.rotation, (float)((float)this.roVec.getX()), (float)((float)this.roVec.getY()), (float)((float)this.roVec.getZ()));
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            GuiDecorationBlock.this.renderer.renderModel(this.model, false);
            GL11.glPopMatrix();
        }

        @Override
        public void onClick() {
            DecorationModel newModel = this.model.clone();
            GuiDecorationBlock.this.setModel(newModel);
        }
    }

    public class IconElementTexture
    implements GuiButtonIcon.IconElement {
        public final String iconName;
        private final TextureAtlasSprite icon;

        public IconElementTexture(String par1) {
            this.iconName = par1;
            this.icon = NGTUtilClient.getIcon((String)par1);
        }

        @Override
        public void draw(GuiButtonIcon button, Minecraft mc, int par2, int par3) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            NGTUtilClient.bindTexture((ResourceLocation)TextureMap.field_110575_b);
            NGTTessellator tessellator = NGTTessellator.instance;
            tessellator.startDrawingQuads();
            tessellator.addVertexWithUV((float)button.field_146128_h, (float)button.field_146129_i, button.getZLevel(), this.icon.func_94209_e(), this.icon.func_94206_g());
            tessellator.addVertexWithUV((float)button.field_146128_h, (float)(button.field_146129_i + button.field_146121_g), button.getZLevel(), this.icon.func_94209_e(), this.icon.func_94210_h());
            tessellator.addVertexWithUV((float)(button.field_146128_h + button.field_146120_f), (float)(button.field_146129_i + button.field_146121_g), button.getZLevel(), this.icon.func_94212_f(), this.icon.func_94210_h());
            tessellator.addVertexWithUV((float)(button.field_146128_h + button.field_146120_f), (float)button.field_146129_i, button.getZLevel(), this.icon.func_94212_f(), this.icon.func_94206_g());
            tessellator.draw();
        }

        @Override
        public void onClick() {
            GuiDecorationBlock.this.setFaceTexture(this.iconName);
        }
    }
}

