/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.gui;

import java.awt.Color;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import jp.ngt.ngtlib.gui.GuiButtonCustom;
import jp.ngt.ngtlib.gui.GuiScreenCustom;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.renderer.NGTTessellator;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.gui.DataMapEditor;
import jp.ngt.rtm.gui.GuiButtonSelectModel;
import jp.ngt.rtm.modelpack.IResourceSelector;
import jp.ngt.rtm.modelpack.ModelPackManager;
import jp.ngt.rtm.modelpack.cfg.IConfigWithType;
import jp.ngt.rtm.modelpack.cfg.ResourceConfig;
import jp.ngt.rtm.modelpack.modelset.ModelSetBase;
import jp.ngt.rtm.modelpack.modelset.ResourceSet;
import jp.ngt.rtm.modelpack.state.ResourceState;
import jp.ngt.rtm.network.PacketSelectResource;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiSelectModel
extends GuiScreenCustom {
    public static final ResourceLocation ButtonBlue = new ResourceLocation("rtm", "textures/gui/button_blue.png");
    public final IResourceSelector selector;
    private List<ResourceSet> modelListAll;
    private List<ResourceSet> modelListSelect;
    private GuiButtonSelectModel[] selectButtons;
    private GuiTextField nameField;
    protected GuiTextField argField;
    private GuiTextField searchField;
    private GuiButtonCustom colorButton;
    private int modelColor;
    private int currentScroll;
    private boolean wasClicking;

    public GuiSelectModel(World par1, IResourceSelector par2) {
        this.xSize = 352;
        this.ySize = 240;
        this.selector = par2;
        ResourceState state = par2.getResourceState();
        if (state.type.subType == null) {
            this.modelListAll = ModelPackManager.INSTANCE.getModelList(state.type);
        } else {
            String subType = state.type.subType;
            List<ResourceSet> list = ModelPackManager.INSTANCE.getModelList(state.type);
            this.modelListAll = new ArrayList<ResourceSet>();
            for (ResourceSet modelSet : list) {
                if (!((IConfigWithType)modelSet.getConfig()).getSubType().equals(subType)) continue;
                this.modelListAll.add(modelSet);
            }
        }
        this.modelListSelect = new ArrayList<ResourceSet>();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        ResourceState state = this.selector.getResourceState();
        this.nameField = this.setTextField(this.field_146294_l - 205, 5, 120, 20, state.getName()).addTips("Custom Name");
        this.argField = this.setTextField(this.field_146294_l - 205, 30, 100, 20, state.getArg()).addTips("Custom Parameters");
        this.searchField = this.setTextField(this.field_146294_l - 80, 5, 60, 20, "").addTips("Search Box");
        this.modelColor = state.color;
        this.colorButton = ((GuiButtonCustom)this.func_189646_b((GuiButton)new GuiButtonCustom(10000, this.field_146294_l - 80, 30, 40, 20, "0xFFFFFF", (GuiScreen)this))).addTips("Select Color");
        this.setColorToButton(this.modelColor);
        ((GuiButtonCustom)this.func_189646_b((GuiButton)new GuiButtonCustom(10001, this.field_146294_l - 105, 30, 20, 20, " ", (GuiScreen)this))).addTips("DataMap");
        this.resetModelList();
    }

    private void resetModelList() {
        if (this.selectButtons != null) {
            this.field_146292_n.removeAll(Arrays.asList(this.selectButtons));
        }
        this.modelListSelect.clear();
        this.currentScroll = 0;
        String keyword = this.searchField.func_146179_b();
        if (keyword == null || keyword.length() == 0) {
            this.modelListSelect.addAll(this.modelListAll);
        } else {
            for (ResourceSet set : this.modelListAll) {
                if (!((ResourceConfig)set.getConfig()).tags.contains(keyword)) continue;
                this.modelListSelect.add(set);
            }
        }
        Collections.sort(this.modelListSelect, (o1, o2) -> ((ResourceConfig)o1.getConfig()).getName().compareTo(((ResourceConfig)o2.getConfig()).getName()));
        int i0 = this.field_146295_m / 2 - 16;
        this.selectButtons = new GuiButtonSelectModel[this.modelListSelect.size()];
        for (int i = 0; i < this.selectButtons.length; ++i) {
            ResourceSet modelSet = this.modelListSelect.get(i);
            this.selectButtons[i] = new GuiButtonSelectModel(i, 10, i0 + 32 * i, (ModelSetBase)modelSet, ((ResourceConfig)modelSet.getConfig()).getName(), this);
            this.field_146292_n.add(this.selectButtons[i]);
            if (!((ResourceConfig)modelSet.getConfig()).getName().equals(this.selector.getResourceState().getResourceName())) continue;
            this.currentScroll = i;
            this.selectButtons[i].isSelected = true;
        }
        this.resetButtonPos();
        this.field_146292_n.add(new GuiButton(10900, this.field_146294_l + 36, this.field_146295_m - 20, 100, 20, "cansel"));
    }

    private void setColorToButton(int color) {
        String colorS;
        this.colorButton.field_146126_j = colorS = "0x" + Integer.toHexString(color);
    }

    private void resetColor() {
        try {
            this.selector.getResourceState().color = this.modelColor = Integer.decode(this.colorButton.field_146126_j).intValue();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    protected void drawGuiContainerBackgroundLayer(float par1, int par2, int par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.modelListSelect.size() > 0) {
            this.drawScrollBar(par2, par3);
        }
        this.drawColorPalet();
    }

    protected void drawGuiContainerForegroundLayer(int par1, int par2) {
        if (this.modelListAll.size() == 0) {
            this.field_146289_q.func_78276_b("Can't get list", (this.field_146294_l - this.xSize) / 2, (this.field_146295_m - this.ySize) / 2, 0xFF0000);
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        boolean clickIsAvailable;
        this.wasClicking = Mouse.isButtonDown((int)0);
        boolean bl = clickIsAvailable = par1 < this.field_146294_l && par1 >= this.field_146294_l - 16;
        if (this.wasClicking && clickIsAvailable) {
            int mouseY = par2 < 8 ? 8 : (par2 >= this.field_146295_m ? this.field_146295_m : par2);
            int i1 = NGTMath.floor((float)((float)mouseY * (float)(this.modelListSelect.size() + 1) / (float)(this.field_146295_m - 16)));
            this.scroll(i1);
        }
        float z = this.field_73735_i;
        this.field_73735_i = -1000.0f;
        this.func_146276_q_();
        this.field_73735_i = z;
        super.func_73863_a(par1, par2, par3);
    }

    private void drawColorPalet() {
        NGTTessellator tessellator = NGTTessellator.instance;
        GL11.glDisable((int)3553);
        tessellator.startDrawingQuads();
        tessellator.setColorOpaque_I(this.modelColor);
        tessellator.addVertex((float)(this.field_146294_l - 20), 50.0f, this.field_73735_i);
        tessellator.addVertex((float)(this.field_146294_l - 20), 30.0f, this.field_73735_i);
        tessellator.addVertex((float)(this.field_146294_l - 40), 30.0f, this.field_73735_i);
        tessellator.addVertex((float)(this.field_146294_l - 40), 50.0f, this.field_73735_i);
        tessellator.draw();
        GL11.glEnable((int)3553);
    }

    private void drawScrollBar(int mouseX, int mouseY) {
        NGTTessellator tessellator = NGTTessellator.instance;
        GL11.glDisable((int)3553);
        tessellator.setColorOpaque_I(0xFFFFFF);
        tessellator.startDrawingQuads();
        tessellator.addVertex((float)(this.field_146294_l - 7), (float)(this.field_146295_m - 8), this.field_73735_i);
        tessellator.addVertex((float)(this.field_146294_l - 7), 8.0f, this.field_73735_i);
        tessellator.addVertex((float)(this.field_146294_l - 9), 8.0f, this.field_73735_i);
        tessellator.addVertex((float)(this.field_146294_l - 9), (float)(this.field_146295_m - 8), this.field_73735_i);
        tessellator.draw();
        GL11.glEnable((int)3553);
        int buttonY = 0;
        if (this.wasClicking) {
            buttonY = (mouseY < 8 ? 8 : (mouseY >= this.field_146295_m - 8 ? this.field_146295_m - 8 : mouseY)) - 8;
        } else if (this.modelListSelect.size() > 1) {
            buttonY = this.currentScroll * (this.field_146295_m - 16) / (this.modelListSelect.size() - 1);
        }
        this.field_146297_k.func_110434_K().func_110577_a(ButtonBlue);
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV((float)this.field_146294_l, (float)(buttonY + 16), this.field_73735_i, 1.0f, 0.0625f);
        tessellator.addVertexWithUV((float)this.field_146294_l, (float)buttonY, this.field_73735_i, 1.0f, 0.0f);
        tessellator.addVertexWithUV((float)(this.field_146294_l - 16), (float)buttonY, this.field_73735_i, 0.9375f, 0.0f);
        tessellator.addVertexWithUV((float)(this.field_146294_l - 16), (float)(buttonY + 16), this.field_73735_i, 0.9375f, 0.0625f);
        tessellator.draw();
    }

    public void func_73729_b(int x, int y, int z, int u, int v, int p_73729_6_) {
        float f = 0.001953125f;
        float f1 = 0.001953125f;
        NGTTessellator tessellator = NGTTessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV((float)(x + 0), (float)(y + p_73729_6_), this.field_73735_i, (float)(z + 0) * f, (float)(u + p_73729_6_) * f1);
        tessellator.addVertexWithUV((float)(x + v), (float)(y + p_73729_6_), this.field_73735_i, (float)(z + v) * f, (float)(u + p_73729_6_) * f1);
        tessellator.addVertexWithUV((float)(x + v), (float)(y + 0), this.field_73735_i, (float)(z + v) * f, (float)(u + 0) * f1);
        tessellator.addVertexWithUV((float)(x + 0), (float)(y + 0), this.field_73735_i, (float)(z + 0) * f, (float)(u + 0) * f1);
        tessellator.draw();
    }

    protected void func_73864_a(int par1, int par2, int par3) throws IOException {
        super.func_73864_a(par1, par2, par3);
    }

    protected void func_73869_a(char par1, int par2) throws IOException {
        super.func_73869_a(par1, par2);
        this.resetModelList();
        this.resetColor();
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 10900) {
            if (this.selector.closeGui(null)) {
                this.field_146297_k.func_147108_a(null);
            }
        } else if (button.field_146127_k == 10000) {
            this.openColorChooser();
        } else if (button.field_146127_k == 10001) {
            this.openDataMapEditor();
        } else if (button.field_146127_k < this.modelListSelect.size()) {
            ResourceState state = this.selector.getResourceState();
            String name = ((ResourceConfig)this.modelListSelect.get(button.field_146127_k).getConfig()).getName();
            state.setResourceName(name);
            state.getResourceSet();
            state.color = this.modelColor;
            state.setName(this.nameField.func_146179_b());
            state.setArg(this.argField.func_146179_b(), true);
            if (this.saveData(state)) {
                RTMCore.NETWORK_WRAPPER.sendToServer((IMessage)new PacketSelectResource(this.selector));
                this.field_146297_k.func_147108_a(null);
            }
        }
    }

    private void openColorChooser() {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(2);
        frame.setBounds(20, 20, 450, 400);
        frame.setTitle("Select Color");
        JColorChooser chooser = new JColorChooser(new Color(this.modelColor));
        chooser.getSelectionModel().addChangeListener(event -> {
            int color = chooser.getColor().getRGB() & 0xFFFFFF;
            this.setColorToButton(color);
            this.resetColor();
        });
        frame.getContentPane().add((Component)chooser, "Center");
        frame.setVisible(true);
    }

    private void openDataMapEditor() {
        DataMapEditor editor = new DataMapEditor(this);
    }

    protected boolean saveData(ResourceState state) {
        return this.selector.closeGui(state);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int i0 = Mouse.getEventDWheel();
        if (i0 != 0) {
            this.scroll(this.currentScroll - (i0 > 0 ? 1 : -1));
        }
    }

    private void scroll(int par1) {
        this.currentScroll = par1;
        if (this.currentScroll < 0) {
            this.currentScroll = 0;
        } else if (this.currentScroll >= this.selectButtons.length) {
            this.currentScroll = this.selectButtons.length - 1;
        }
        this.resetButtonPos();
    }

    private void resetButtonPos() {
        int i0 = this.field_146295_m / 2 - 16;
        for (int i = 0; i < this.selectButtons.length; ++i) {
            this.selectButtons[i].field_146129_i = i0 + 32 * (i - this.currentScroll);
        }
    }
}

