/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.gui;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import jp.ngt.ngtlib.gui.GuiScreenCustom;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.gui.GuiButtonSelectTexture;
import jp.ngt.rtm.modelpack.IResourceSelector;
import jp.ngt.rtm.modelpack.ModelPackManager;
import jp.ngt.rtm.modelpack.cfg.ResourceConfig;
import jp.ngt.rtm.modelpack.cfg.TextureConfig;
import jp.ngt.rtm.modelpack.modelset.ResourceSet;
import jp.ngt.rtm.modelpack.modelset.TextureSetBase;
import jp.ngt.rtm.modelpack.state.ResourceState;
import jp.ngt.rtm.network.PacketSelectResource;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class GuiSelectTexture
extends GuiScreenCustom {
    public final IResourceSelector holder;
    private final GuiScreen parent;
    private List<ResourceSet> resourceSets;
    private int currentScroll;
    private int prevScroll;
    private int uCount;
    private int vCount;

    public GuiSelectTexture(IResourceSelector par1, @Nullable GuiScreen screen) {
        this.holder = par1;
        this.resourceSets = ModelPackManager.INSTANCE.getModelList(par1.getResourceState().type);
        this.parent = screen;
    }

    public void func_73866_w_() {
        ResourceConfig cfg = ((TextureSetBase)this.resourceSets.get(0)).getConfig();
        this.uCount = !this.resourceSets.isEmpty() ? ((TextureConfig)cfg).getUCountInGui() : 1;
        this.vCount = !this.resourceSets.isEmpty() ? ((TextureConfig)cfg).getVCountInGui() : 1;
        int x = this.field_146294_l / this.uCount;
        int y = this.field_146295_m / this.vCount;
        this.field_146292_n.clear();
        int yCount = this.resourceSets.size() / this.uCount + 1;
        for (int v = 0; v < yCount; ++v) {
            int index;
            for (int u = 0; u < this.uCount && (index = v * this.uCount + u) < this.resourceSets.size(); ++u) {
                TextureSetBase set = (TextureSetBase)this.resourceSets.get(index);
                ResourceConfig prop = set.getConfig();
                float f0 = 1.0f;
                f0 = ((TextureConfig)prop).width > ((TextureConfig)prop).height ? (float)x / ((TextureConfig)prop).width : (float)y / ((TextureConfig)prop).height;
                int w = (int)(((TextureConfig)prop).width * f0);
                int h = (int)(((TextureConfig)prop).height * f0);
                int xPos = x * u + (x - w) / 2;
                int yPos = y * v + (y - h) / 2;
                this.field_146292_n.add(new GuiButtonSelectTexture(index, xPos, yPos, w, h, this.holder.getResourceState().type, set));
            }
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.func_146276_q_();
        super.func_73863_a(par1, par2, par3);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 256) {
            this.field_146297_k.func_147108_a(this.parent);
        }
        if (button.field_146127_k < this.resourceSets.size()) {
            ResourceState state = this.holder.getResourceState();
            String name = ((TextureConfig)((GuiButtonSelectTexture)button).property.getConfig()).getName();
            state.setResourceName(name);
            if (this.holder.closeGui(state)) {
                RTMCore.NETWORK_WRAPPER.sendToServer((IMessage)new PacketSelectResource(this.holder));
            }
            this.field_146297_k.func_147108_a(this.parent);
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int scroll = Mouse.getEventDWheel();
        if (scroll != 0) {
            int size2;
            this.prevScroll = this.currentScroll;
            scroll = scroll > 0 ? 1 : (scroll < 0 ? -1 : 0);
            this.currentScroll -= scroll;
            if (this.currentScroll < 0) {
                this.currentScroll = 0;
            }
            if (this.currentScroll >= (size2 = this.resourceSets.size() / this.uCount)) {
                this.currentScroll = size2 - 1;
            }
            this.renewButton(this.currentScroll);
        }
    }

    protected void renewButton(int scroll) {
        if (this.currentScroll != this.prevScroll) {
            int y = this.field_146295_m / this.vCount;
            if (this.prevScroll > this.currentScroll) {
                y = -y;
            }
            for (int i = 0; i < this.field_146292_n.size(); ++i) {
                ((GuiButtonSelectTexture)((Object)this.field_146292_n.get(i))).moveButton(y);
            }
        }
    }
}

