/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.item;

import jp.ngt.ngtlib.item.ItemArgHolderBase;
import jp.ngt.ngtlib.item.ItemUtil;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.RTMResource;
import jp.ngt.rtm.entity.train.parts.EntityArtillery;
import jp.ngt.rtm.entity.train.parts.EntityCargo;
import jp.ngt.rtm.entity.train.parts.EntityCargoWithModel;
import jp.ngt.rtm.entity.train.parts.EntityContainer;
import jp.ngt.rtm.entity.train.parts.EntityTie;
import jp.ngt.rtm.item.ItemWithModel;
import jp.ngt.rtm.modelpack.ResourceType;
import jp.ngt.rtm.modelpack.state.ResourceState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCargo
extends ItemWithModel {
    @Override
    protected ActionResult<ItemStack> onItemRightClick(ItemArgHolderBase.ItemArgHolder holder) {
        if (holder.getItemStack().func_77952_i() != 2) {
            return super.onItemRightClick(holder);
        }
        return holder.success();
    }

    protected ActionResult<ItemStack> onItemUse(ItemArgHolderBase.ItemArgHolder holder, float hitX, float hitY, float hitZ) {
        ItemStack itemStack = holder.getItemStack();
        World world = holder.getWorld();
        EntityPlayer player = holder.getPlayer();
        BlockPos pos = holder.getBlockPos();
        if (!world.field_72995_K) {
            BlockPos newPos = ItemUtil.getPlacePos((BlockPos)pos, (EnumFacing)holder.getFacing());
            int x = newPos.func_177958_n();
            int y = newPos.func_177956_o();
            int z = newPos.func_177952_p();
            ItemStack itemstack = itemStack.func_77946_l();
            int damage = itemstack.func_77952_i();
            EntityCargo cargo = this.createCargoEntity(world, itemstack, x, y, z, damage);
            float rotationInterval = 15.0f;
            int yaw = NGTMath.floor((double)(NGTMath.normalizeAngle((double)((double)(-player.field_70177_z) + 180.0 + (double)rotationInterval / 2.0)) / (double)rotationInterval));
            float yawF = (float)yaw * rotationInterval;
            cargo.func_70080_a((double)x + 0.5, y, (double)z + 0.5, yawF, 0.0f);
            cargo.readCargoFromItem();
            world.func_72838_d((Entity)cargo);
            if (cargo instanceof EntityCargoWithModel) {
                EntityCargoWithModel cwm = (EntityCargoWithModel)cargo;
                cwm.getResourceState().readFromNBT(this.getModelState(itemstack).writeToNBT());
                cwm.updateResourceState();
            }
            itemstack.func_190918_g(1);
        }
        return holder.success();
    }

    public EntityCargo createCargoEntity(World world, ItemStack itemstack, int x, int y, int z, int damage) {
        switch (damage) {
            case 0: {
                return new EntityContainer(world, itemstack, x, y, z);
            }
            case 1: {
                return new EntityArtillery(world, itemstack, x, y, z);
            }
            case 2: {
                return new EntityTie(world, itemstack, x, y, z);
            }
        }
        return new EntityContainer(world, itemstack, x, y, z);
    }

    public String func_77667_c(ItemStack itemStack) {
        return super.func_77658_a() + "." + itemStack.func_77952_i();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (int j = 0; j < 3; ++j) {
            list.add((Object)new ItemStack((Item)this, 1, j));
        }
    }

    @Override
    protected ResourceType getModelType(ItemStack itemStack) {
        switch (itemStack.func_77952_i()) {
            case 0: {
                return RTMResource.CONTAINER;
            }
            case 1: {
                return RTMResource.FIREARM;
            }
            case 2: {
                return null;
            }
        }
        return RTMResource.CONTAINER;
    }

    @Override
    public int getGuiId(ItemStack stack) {
        return RTMCore.guiIdSelectItemModel;
    }

    protected ResourceState getNewState(ItemStack itemStack, ResourceType type) {
        return new ResourceState(type, null);
    }
}

