/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.item;

import java.util.List;
import jp.ngt.ngtlib.event.TickProcessEntry;
import jp.ngt.ngtlib.event.TickProcessQueue;
import jp.ngt.ngtlib.item.ItemArgHolderBase;
import jp.ngt.ngtlib.item.ItemCustom;
import jp.ngt.ngtlib.util.PermissionManager;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.RTMItem;
import jp.ngt.rtm.entity.EntityBullet;
import jp.ngt.rtm.entity.npc.EntityDummyPlayer;
import jp.ngt.rtm.item.ItemAmmunition;
import jp.ngt.rtm.item.RazerBullet;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemGun
extends ItemCustom {
    public static final int INTERVAL = 2;
    public final GunType gunType;

    public ItemGun(GunType par1) {
        this.gunType = par1;
        this.field_77777_bU = 1;
        this.func_77656_e(par1.maxSize);
    }

    protected ActionResult<ItemStack> onItemRightClick(ItemArgHolderBase.ItemArgHolder holder) {
        int i0;
        ItemStack itemstack = holder.getItemStack();
        EntityPlayer player = holder.getPlayer();
        if (itemstack.func_77952_i() < itemstack.func_77958_k()) {
            player.func_184598_c(holder.getHand());
        } else if (!player.field_71075_bZ.field_75098_d && !holder.getWorld().field_72995_K && (i0 = this.setMagazine(player)) < itemstack.func_77958_k()) {
            itemstack.func_77964_b(i0);
            player.func_70099_a(new ItemStack(this.getMagazineFromGunType(), 1, itemstack.func_77958_k()), 1.0f);
        }
        return holder.success();
    }

    private int setMagazine(EntityPlayer player) {
        Item magazineItem = this.getMagazineFromGunType();
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != magazineItem || stack.func_77952_i() >= magazineItem.func_77612_l()) continue;
            player.field_71071_by.func_70299_a(i, null);
            return stack.func_77952_i();
        }
        return 1024;
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase living, int count) {
        if (!(living instanceof EntityPlayer)) {
            // empty if block
        }
        EntityPlayer player = (EntityPlayer)living;
        if (stack.func_77952_i() != stack.func_77958_k() && this.onUsingGun(stack, player.field_70170_p, player, count) && !player.field_71075_bZ.field_75098_d && stack.func_77984_f()) {
            stack.func_77964_b(stack.func_77952_i() + 1);
        }
    }

    public int func_77626_a(ItemStack itemStack) {
        return this.gunType.useDuration;
    }

    public EnumAction func_77661_b(ItemStack itemStack) {
        return EnumAction.BOW;
    }

    public int func_77619_b() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    protected boolean onUsingGun(ItemStack itemstack, World world, EntityPlayer player, int count) {
        if (count % 2 > 0) {
            return false;
        }
        if (!this.gunType.rapidFire && count < this.gunType.useDuration) {
            return false;
        }
        if (!world.field_72995_K) {
            if (this.gunType == GunType.razer_gun) {
                if (PermissionManager.INSTANCE.hasPermission((ICommandSender)player, "useRazer")) {
                    RazerBullet bullet = new RazerBullet(player);
                    TickProcessQueue.getInstance((Side)Side.SERVER).add((TickProcessEntry)bullet);
                    return true;
                }
            } else if (PermissionManager.INSTANCE.hasPermission((ICommandSender)player, "useGun")) {
                EntityBullet bullet = player instanceof EntityDummyPlayer ? ((EntityDummyPlayer)player).npc.getBullet(this.gunType) : new EntityBullet(world, (EntityLivingBase)player, this.gunType.speed, this.gunType.bulletType);
                world.func_72838_d((Entity)bullet);
                RTMCore.proxy.playSound((Entity)player, "rtm:sounds/item/gun.ogg", RTMCore.gunSoundVol, 1.0f);
                if (!player.field_71075_bZ.field_75098_d) {
                    int damage = this.gunType.bulletType.id * 4 + 2;
                    player.func_70099_a(new ItemStack(RTMItem.bullet, 1, damage), 0.5f);
                }
            }
        }
        return false;
    }

    protected void addInformation(ItemArgHolderBase.ItemArgHolder holder, List<String> list, ITooltipFlag flag) {
        int max = holder.getItemStack().func_77958_k();
        list.add(TextFormatting.GRAY + "Bullet:" + String.valueOf(max - holder.getItemStack().func_77952_i()) + "/" + String.valueOf(max));
    }

    public Item getMagazineFromGunType() {
        switch (this.gunType) {
            case handgun: {
                return RTMItem.magazine_handgun;
            }
            case rifle: {
                return RTMItem.magazine_rifle;
            }
            case autoloading_rifle: {
                return RTMItem.magazine_alr;
            }
            case sniper_rifle: {
                return RTMItem.magazine_sr;
            }
            case smg: {
                return RTMItem.magazine_smg;
            }
            case amr: {
                return RTMItem.magazine_amr;
            }
            case razer_gun: {
                return RTMItem.razer_gun;
            }
        }
        return RTMItem.magazine_handgun;
    }

    public static enum GunType {
        handgun(ItemAmmunition.BulletType.handgun_9mm, 10, 16, 4.5f, false),
        rifle(ItemAmmunition.BulletType.rifle_7_62mm, 5, 16, 7.5f, false),
        autoloading_rifle(ItemAmmunition.BulletType.rifle_7_62mm, 30, 6, 7.5f, true),
        sniper_rifle(ItemAmmunition.BulletType.rifle_7_62mm, 10, 20, 7.5f, false),
        smg(ItemAmmunition.BulletType.handgun_9mm, 30, 6, 4.5f, true),
        amr(ItemAmmunition.BulletType.rifle_12_7mm, 10, 24, 9.0f, false),
        razer_gun(ItemAmmunition.BulletType.rifle_12_7mm, 10, 60, 150.0f, false);

        public final ItemAmmunition.BulletType bulletType;
        public final int maxSize;
        public final int useDuration;
        public final float speed;
        public boolean rapidFire;

        private GunType(ItemAmmunition.BulletType par1, int par2, int par3, float par4, boolean par5) {
            this.bulletType = par1;
            this.maxSize = par2;
            this.useDuration = par3;
            this.speed = par4;
            this.rapidFire = par5;
        }
    }
}

