/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.item;

import java.util.List;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.ngtlib.item.ItemArgHolderBase;
import jp.ngt.ngtlib.item.ItemCustom;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.rtm.entity.fluid.EntityFluid;
import jp.ngt.rtm.entity.fluid.FluidType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class ItemPaddle
extends ItemCustom {
    private static final int[][][] FURNACE_PATTERN = new int[][][]{new int[][]{{-3, 1, 0}, {-2, 1, 0}, {0, 1, 0}, {3, 1, 0}, {2, -1, 0}, {3, 0, 0}}, new int[][]{{2, 1, 0}, {3, 1, 0}, {-3, 1, 0}, {0, 1, 0}, {-3, -1, 0}, {-2, 0, 0}}, new int[][]{{0, 1, -3}, {0, 1, -2}, {0, 1, 0}, {0, 1, 3}, {0, -1, 2}, {0, 0, 3}}, new int[][]{{0, 1, 2}, {0, 1, 3}, {0, 1, -3}, {0, 1, 0}, {0, -1, -3}, {0, 0, -2}}};

    public ItemPaddle() {
        this.field_77777_bU = 1;
        this.func_77656_e(Item.ToolMaterial.IRON.func_77997_a());
    }

    protected ActionResult<ItemStack> onItemRightClick(ItemArgHolderBase.ItemArgHolder holder) {
        return holder.setItemStack(holder.getItemStack().func_77946_l()).success();
    }

    public boolean canDestroyBlockInCreative(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
        return false;
    }

    public boolean func_150897_b(IBlockState block) {
        return false;
    }

    private static boolean stir(EntityPlayer player, EntityFluid fluid) {
        BlockPos pos = fluid.func_180425_c();
        float temp = ItemPaddle.checkFurnaceEnv(fluid.field_70170_p, player, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        if (temp > 0.0f) {
            if (temp > fluid.getTemperature()) {
                fluid.setTemperture(temp);
            }
            if (temp >= FluidType.STEEL.meltingPoint) {
                if (player.func_130014_f_().field_73012_v.nextInt(4) == 0) {
                    NGTLog.sendChatMessage((ICommandSender)player, (String)"message.paddle.get_steel", (Object[])new Object[0]);
                    fluid.setFluidType(FluidType.STEEL);
                    return true;
                }
            } else {
                NGTLog.sendChatMessage((ICommandSender)player, (String)"Low temperature (%5.1f)", (Object[])new Object[]{Float.valueOf(temp)});
            }
        }
        return false;
    }

    private static float checkFurnaceEnv(World world, EntityPlayer player, int x, int y, int z) {
        float temp = 0.0f;
        int chimney = -1;
        int ceiling = -1;
        int coke = -1;
        int heatSource = -1;
        for (int i = 0; i < FURNACE_PATTERN.length; ++i) {
            boolean fHeatSource;
            boolean fChimney = ItemPaddle.checkChimney(world, x, y, z, FURNACE_PATTERN[i][0], FURNACE_PATTERN[i][1]);
            int n = chimney == 1 ? chimney : (chimney = fChimney ? 1 : 0);
            if (!fChimney) continue;
            boolean fCeiling = ItemPaddle.checkCeiling(world, x, y, z, FURNACE_PATTERN[i][2], FURNACE_PATTERN[i][3]);
            int n2 = ceiling == 1 ? ceiling : (ceiling = fCeiling ? 1 : 0);
            if (!fCeiling) continue;
            boolean fCoke = ItemPaddle.checkCokeNotAdjacent(world, x, y, z);
            int n3 = coke == 1 ? coke : (coke = fCoke ? 1 : 0);
            if (!fCoke) continue;
            float tempNew = ItemPaddle.checkHeatSource(world, x, y, z, FURNACE_PATTERN[i][4], FURNACE_PATTERN[i][5]);
            boolean bl = fHeatSource = tempNew > 0.0f;
            int n4 = heatSource == 1 ? heatSource : (heatSource = fHeatSource ? 1 : 0);
            if (!fHeatSource || !(tempNew > temp)) continue;
            temp = tempNew;
        }
        NGTLog.sendChatMessage((ICommandSender)player, (String)"Chimney:%s, Ceiling:%s, Coke:%s, HeatSource:s%", (Object[])new Object[]{ItemPaddle.getMessage(chimney), ItemPaddle.getMessage(ceiling), ItemPaddle.getMessage(coke), ItemPaddle.getMessage(heatSource)});
        return temp;
    }

    private static String getMessage(int state) {
        return state == 1 ? "OK" : (state == 0 ? "NG" : "-");
    }

    private static boolean checkCokeNotAdjacent(World world, int x, int y, int z) {
        List list = world.func_72872_a(EntityFluid.class, new AxisAlignedBB((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)));
        for (EntityFluid fluid : list) {
            if (fluid.getFluidType() != FluidType.COKE) continue;
            return false;
        }
        return true;
    }

    private static boolean checkChimney(World world, int x, int y, int z, int[] start, int[] end) {
        boolean flag = false;
        for (int i = start[0]; i <= end[0]; ++i) {
            for (int j = start[1]; j <= end[1]; ++j) {
                for (int k = start[2]; k <= end[2]; ++k) {
                    flag |= world.func_175678_i(new BlockPos(x + i, y + j, z + k));
                }
            }
        }
        return flag;
    }

    private static boolean checkCeiling(World world, int x, int y, int z, int[] start, int[] end) {
        for (int i = start[0]; i <= end[0]; ++i) {
            for (int j = start[1]; j <= end[1]; ++j) {
                for (int k = start[2]; k <= end[2]; ++k) {
                    if (!world.func_175678_i(new BlockPos(x + i, y + j, z + k))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static float checkHeatSource(World world, int x, int y, int z, int[] start, int[] end) {
        List list = world.func_72872_a(EntityFluid.class, new AxisAlignedBB((double)(x + start[0]), (double)(y + start[1]), (double)(z + start[2]), (double)(x + end[0] + 1), (double)(y + end[1] + 1), (double)(z + end[2] + 1)));
        double sum = 0.0;
        int count = 0;
        for (EntityFluid fluid : list) {
            if (fluid.getFluidType() != FluidType.COKE) continue;
            sum += (double)fluid.getTemperature();
            ++count;
        }
        return count > 0 ? (float)(sum / (double)count) : 0.0f;
    }

    public static void pushPull(EntityPlayer player, EntityFluid fluid, float dir) {
        if (fluid.getFluidType() == FluidType.PIG_IRON && ItemPaddle.stir(player, fluid)) {
            return;
        }
        double x = fluid.field_70165_t - player.field_70165_t;
        double z = fluid.field_70161_v - player.field_70161_v;
        double len = NGTMath.firstSqrt((double)(x * x + z * z));
        float f0 = dir * 0.1f;
        fluid.field_70159_w += x / len * (double)f0;
        fluid.field_70179_y += z / len * (double)f0;
    }
}

