/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.item;

import java.util.List;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.ngtlib.item.ItemArgHolderBase;
import jp.ngt.ngtlib.item.ItemCustom;
import jp.ngt.ngtlib.network.PacketNBT;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.modelpack.IResourceSelector;
import jp.ngt.rtm.modelpack.ModelPackManager;
import jp.ngt.rtm.modelpack.ResourceType;
import jp.ngt.rtm.modelpack.modelset.ResourceSet;
import jp.ngt.rtm.modelpack.state.ResourceState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemWithModel<T extends ResourceSet>
extends ItemCustom
implements IResourceSelector {
    private ItemStack selectedItem;
    private EntityPlayer selectedPlayer;

    public ItemWithModel() {
        this.func_77627_a(true);
    }

    protected ActionResult<ItemStack> onItemRightClick(ItemArgHolderBase.ItemArgHolder holder) {
        if (holder.getWorld().field_72995_K) {
            if (this.getModelType(holder.getItemStack()) != null) {
                this.selectedItem = holder.getItemStack();
                this.selectedPlayer = holder.getPlayer();
                holder.getPlayer().openGui((Object)RTMCore.instance, this.getGuiId(holder.getItemStack()), holder.getWorld(), 0, -1, 0);
            } else {
                NGTLog.debug((String)"No Type");
            }
        }
        return holder.success();
    }

    public abstract int getGuiId(ItemStack var1);

    @SideOnly(value=Side.CLIENT)
    protected void addInformation(ItemArgHolderBase.ItemArgHolder holder, List<String> list, ITooltipFlag flag) {
        ResourceState<T> state;
        if (ModelPackManager.INSTANCE.modelLoaded && (state = this.getModelState(holder.getItemStack())) != null) {
            list.add(TextFormatting.GRAY + state.getResourceName());
        }
    }

    protected abstract ResourceType getModelType(ItemStack var1);

    public ResourceState<T> getModelState(ItemStack itemStack) {
        ResourceType type = this.getModelType(itemStack);
        if (type != null) {
            ResourceState<T> state = this.getNewState(itemStack, type);
            if (itemStack.func_77942_o()) {
                state.readFromNBT(itemStack.func_77978_p().func_74775_l("State"));
            } else {
                state.setResourceName(type.defaultName);
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74782_a("State", (NBTBase)state.writeToNBT());
                itemStack.func_77982_d(nbt);
            }
            return state;
        }
        return null;
    }

    protected abstract ResourceState<T> getNewState(ItemStack var1, ResourceType var2);

    public void setModelState(ItemStack itemStack, ResourceState<T> state) {
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.func_77978_p().func_74782_a("State", (NBTBase)state.writeToNBT());
        if (this.selectedPlayer != null) {
            PacketNBT.sendToServer((EntityPlayer)this.selectedPlayer, (ItemStack)this.selectedItem);
        }
    }

    @Override
    public ResourceState<T> getResourceState() {
        return this.getModelState(this.selectedItem);
    }

    @Override
    public void updateResourceState() {
    }

    @Override
    public int[] getSelectorPos() {
        return new int[3];
    }

    @Override
    public boolean closeGui(ResourceState par1) {
        this.setModelState(this.selectedItem, par1);
        return true;
    }
}

