/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.modelpack.cfg;

import jp.ngt.rtm.modelpack.cfg.IConfigWithType;
import jp.ngt.rtm.modelpack.cfg.ModelConfig;
import jp.ngt.rtm.modelpack.cfg.VehicleBaseConfig;

public class VehicleConfig
extends VehicleBaseConfig
implements IConfigWithType {
    private String name;
    public ModelConfig.ModelSource model;
    public String vehicleType;
    private float[] friction;
    private float[] acceleration;
    private float[] maxSpeed;
    private float[] maxYaw;
    private float[] yawCoefficient;
    private float[] pitchCoefficient;
    private float[] rollCoefficient;
    public boolean changeYawOnStopping;
    public float hoveringSpeed;
    public float[] vibration;
    public float connectionDistance;
    public float[] gripPos;

    @Override
    public void init() {
        super.init();
        if (this.playerPos == null || this.playerPos.length != 1) {
            this.playerPos = new float[][]{{0.0f, 0.0f, 0.0f}};
        }
        if (this.vibration == null) {
            this.vibration = new float[]{0.0f, 0.0f};
        }
        if (this.gripPos == null || this.gripPos.length != 3) {
            this.gripPos = new float[]{0.0f, 0.0f, 0.0f};
        }
    }

    @Override
    public ModelConfig.ModelSource getModel() {
        return this.model;
    }

    public float getFriction(boolean onGround) {
        if (this.friction == null) {
            return 0.9f;
        }
        return this.friction[onGround ? 0 : 1];
    }

    public float getAcceleration(boolean onGround) {
        if (this.acceleration == null) {
            return 0.0125f;
        }
        return this.acceleration[onGround ? 0 : 1];
    }

    public float getMaxSpeed(boolean onGround) {
        if (this.maxSpeed == null) {
            return 0.8f;
        }
        return this.maxSpeed[onGround ? 0 : 1];
    }

    public float getMaxYaw(boolean onGround) {
        if (this.maxYaw == null) {
            return 15.0f;
        }
        return this.maxYaw[onGround ? 0 : 1];
    }

    public float getYawCoefficient(boolean onGround) {
        if (this.yawCoefficient == null) {
            return 4.5f;
        }
        return this.yawCoefficient[onGround ? 0 : 1];
    }

    public float getPitchCoefficient(boolean onGround) {
        if (this.pitchCoefficient == null) {
            return 2.5f;
        }
        return this.pitchCoefficient[onGround ? 0 : 1];
    }

    public float getRollCoefficient(boolean onGround) {
        if (this.rollCoefficient == null) {
            return 45.0f;
        }
        return this.rollCoefficient[onGround ? 0 : 1];
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static VehicleConfig getDummy() {
        VehicleConfig cfg = new VehicleConfig();
        cfg.name = "dummy";
        cfg.vehicleType = "N";
        cfg.init();
        return cfg;
    }

    @Override
    public String getSubType() {
        return this.vehicleType;
    }
}

