/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.modelpack.state;

import jp.ngt.ngtlib.math.Vec3;
import jp.ngt.rtm.modelpack.state.DataEntryBoolean;
import jp.ngt.rtm.modelpack.state.DataEntryDouble;
import jp.ngt.rtm.modelpack.state.DataEntryHex;
import jp.ngt.rtm.modelpack.state.DataEntryInt;
import jp.ngt.rtm.modelpack.state.DataEntryString;
import jp.ngt.rtm.modelpack.state.DataEntryVec;
import jp.ngt.rtm.modelpack.state.DataType;
import net.minecraft.nbt.NBTTagCompound;

public abstract class DataEntry<T> {
    protected T data;
    public final int flag;

    public DataEntry(T value, int flag) {
        this.data = value;
        this.flag = flag;
    }

    public abstract void readFromNBT(NBTTagCompound var1);

    public abstract void writeToNBT(NBTTagCompound var1);

    public abstract DataType getType();

    public T get() {
        return this.data;
    }

    public static DataEntry getEntry(String type, String data, int flag) {
        DataType dType = DataType.getType(type);
        if (dType == DataType.INT) {
            int i = data.isEmpty() ? 0 : Integer.valueOf(data);
            return new DataEntryInt(i, flag);
        }
        if (dType == DataType.DOUBLE) {
            double d = data.isEmpty() ? 0.0 : Double.valueOf(data);
            return new DataEntryDouble(d, flag);
        }
        if (dType == DataType.BOOLEAN) {
            boolean b = data.isEmpty() ? false : Boolean.valueOf(data);
            return new DataEntryBoolean(b, flag);
        }
        if (dType == DataType.STRING) {
            return new DataEntryString(data, flag);
        }
        if (dType == DataType.VEC) {
            Vec3 vec = DataEntryVec.fromString(data);
            return new DataEntryVec(vec, flag);
        }
        if (dType == DataType.HEX) {
            int i = data.isEmpty() ? 0 : Integer.decode(data);
            return new DataEntryHex(i, flag);
        }
        return null;
    }
}

