/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.modelpack.state;

import java.util.ArrayList;
import java.util.List;
import jp.ngt.rtm.block.tt.SignboardText;
import jp.ngt.rtm.block.tt.StationTimeTable;
import jp.ngt.rtm.modelpack.ResourceType;
import jp.ngt.rtm.modelpack.modelset.TextureSetSignboard;
import jp.ngt.rtm.modelpack.state.ResourceState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ResourceStateSignboard
extends ResourceState<TextureSetSignboard> {
    public final List<SignboardText> texts = new ArrayList<SignboardText>();
    private StationTimeTable timeTable = new StationTimeTable("tt_sample.csv", "\u897f\u4eac", -1);

    public ResourceStateSignboard(ResourceType type, Object entity) {
        super(type, entity);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        if (nbt.func_74764_b("TimeTableSetting")) {
            this.setTTSetting(nbt.func_74779_i("TimeTableSetting"));
        }
        this.texts.clear();
        NBTTagList list = nbt.func_150295_c("Texts", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt2 = list.func_150305_b(i);
            this.texts.add(SignboardText.readFromNBT(nbt2, this.timeTable));
        }
    }

    @Override
    public NBTTagCompound writeToNBT() {
        NBTTagCompound nbt = super.writeToNBT();
        NBTTagList list = new NBTTagList();
        for (SignboardText text : this.texts) {
            list.func_74742_a((NBTBase)text.writeToNBT());
        }
        nbt.func_74782_a("Texts", (NBTBase)list);
        nbt.func_74778_a("TimeTableSetting", this.getTTSetting());
        return nbt;
    }

    public void setTTSetting(String setting) {
        String[] sa = setting.split(",");
        String ttName = this.timeTable.timeTable.fileName;
        String stationName = this.timeTable.station;
        byte track = this.timeTable.track;
        for (String s : sa) {
            if (s.startsWith("tt")) {
                ttName = s.split("=")[1];
                continue;
            }
            if (s.startsWith("station")) {
                stationName = s.split("=")[1];
                continue;
            }
            if (!s.startsWith("track")) continue;
            track = Byte.valueOf(s.split("=")[1]);
        }
        this.timeTable = new StationTimeTable(ttName, stationName, track);
    }

    public String getTTSetting() {
        return String.format("tt=%s,station=%s,track=%d", this.timeTable.timeTable.fileName, this.timeTable.station, this.timeTable.track);
    }

    public StationTimeTable geTimeTable() {
        return this.timeTable;
    }
}

