/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.network;

import io.netty.buffer.ByteBuf;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.util.NGTUtil;
import jp.ngt.rtm.entity.train.EntityBogie;
import jp.ngt.rtm.entity.vehicle.EntityVehicleBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityTracker;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketVehicleMovement
implements IMessage,
IMessageHandler<PacketVehicleMovement, IMessage> {
    private static final double SAMPLING = 32.0;
    private static final double DIV_32 = 0.03125;
    public int entityId;
    public byte type;
    public int vehicleX;
    public int vehicleY;
    public int vehicleZ;
    public float vehicleYaw;
    public float vehiclePitch;
    public float vehicleRoll;
    public float vehicleSpeed;

    public PacketVehicleMovement() {
    }

    public PacketVehicleMovement(Entity par1, boolean onDead) {
        this.entityId = par1.func_145782_y();
        this.type = 0;
        this.vehicleX = NGTMath.floor((double)(par1.field_70165_t * 32.0));
        this.vehicleY = NGTMath.floor((double)(par1.field_70163_u * 32.0));
        this.vehicleZ = NGTMath.floor((double)(par1.field_70161_v * 32.0));
        this.vehicleYaw = par1.field_70177_z;
        this.vehiclePitch = par1.field_70125_A;
        if (par1 instanceof EntityVehicleBase) {
            this.type = (byte)2;
            this.vehicleRoll = ((EntityVehicleBase)par1).getRoll();
            this.vehicleSpeed = ((EntityVehicleBase)par1).getSpeed();
        } else {
            this.vehicleRoll = ((EntityBogie)par1).rotationRoll;
        }
        if (onDead) {
            this.vehicleY = -1;
        }
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeByte((int)this.type);
        buffer.writeInt(this.vehicleX);
        buffer.writeInt(this.vehicleY);
        buffer.writeInt(this.vehicleZ);
        buffer.writeFloat(this.vehicleYaw);
        buffer.writeFloat(this.vehiclePitch);
        buffer.writeFloat(this.vehicleRoll);
        buffer.writeFloat(this.vehicleSpeed);
    }

    public void fromBytes(ByteBuf buffer) {
        this.entityId = buffer.readInt();
        this.type = buffer.readByte();
        this.vehicleX = buffer.readInt();
        this.vehicleY = buffer.readInt();
        this.vehicleZ = buffer.readInt();
        this.vehicleYaw = buffer.readFloat();
        this.vehiclePitch = buffer.readFloat();
        this.vehicleRoll = buffer.readFloat();
        this.vehicleSpeed = buffer.readFloat();
    }

    public IMessage onMessage(PacketVehicleMovement message, MessageContext ctx) {
        World world = NGTUtil.getClientWorld();
        if (world == null) {
            return null;
        }
        if (message.vehicleY < 0) {
            this.deleteEntity(world, message.entityId);
            return null;
        }
        Entity entity = world.func_73045_a(message.entityId);
        if (entity != null && !entity.field_70128_L) {
            double x = (double)message.vehicleX * 0.03125;
            double y = (double)message.vehicleY * 0.03125;
            double z = (double)message.vehicleZ * 0.03125;
            entity.field_70118_ct = EntityTracker.func_187253_a((double)x);
            entity.field_70117_cu = EntityTracker.func_187253_a((double)y);
            entity.field_70116_cv = EntityTracker.func_187253_a((double)z);
            entity.func_180426_a(x, y, z, message.vehicleYaw, message.vehiclePitch, 3, false);
            if (entity instanceof EntityVehicleBase) {
                ((EntityVehicleBase)entity).setRollAndSpeed(message.vehicleSpeed, message.vehicleRoll);
            } else {
                ((EntityBogie)entity).setRoll(message.vehicleRoll);
            }
        } else {
            NGTLog.debug((String)"[PVM] Entity is null or dead %d", (Object[])new Object[]{message.entityId});
        }
        return null;
    }

    private void deleteEntity(World world, int id) {
        Entity entity = world.func_73045_a(id);
        if (entity == null) {
            for (Entity entity2 : world.field_73007_j) {
                if (entity2.func_145782_y() != id) continue;
                entity = entity2;
                break;
            }
        }
        if (entity != null) {
            entity.func_70106_y();
        }
    }
}

