/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.network;

import io.netty.buffer.ByteBuf;
import jp.ngt.ngtlib.event.TickProcessEntry;
import jp.ngt.ngtlib.event.TickProcessQueue;
import jp.ngt.ngtlib.network.PacketCustom;
import jp.ngt.ngtlib.util.NGTUtil;
import jp.ngt.rtm.electric.TileEntityElectricalWiring;
import jp.ngt.rtm.entity.EntityElectricalWiring;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketWire
extends PacketCustom
implements IMessageHandler<PacketWire, IMessage> {
    public static final int ARRAY_SIZE = 4;
    private boolean isBlock;
    private boolean isActivated;
    private NBTTagCompound nbtData;

    public PacketWire() {
    }

    public PacketWire(EntityElectricalWiring entity, TileEntityElectricalWiring tileEntity) {
        super((Entity)entity);
        this.isBlock = false;
        this.isActivated = tileEntity.isActivated;
        this.nbtData = new NBTTagCompound();
        tileEntity.func_189515_b(this.nbtData);
    }

    public PacketWire(TileEntityElectricalWiring tileEntity) {
        super((TileEntity)tileEntity);
        this.isBlock = true;
        this.isActivated = tileEntity.isActivated;
        this.nbtData = new NBTTagCompound();
        tileEntity.func_189515_b(this.nbtData);
    }

    public void toBytes(ByteBuf buffer) {
        super.toBytes(buffer);
        buffer.writeBoolean(this.isBlock);
        buffer.writeBoolean(this.isActivated);
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)this.nbtData);
    }

    public void fromBytes(ByteBuf buffer) {
        super.fromBytes(buffer);
        this.isBlock = buffer.readBoolean();
        this.isActivated = buffer.readBoolean();
        this.nbtData = ByteBufUtils.readTag((ByteBuf)buffer);
    }

    public IMessage onMessage(final PacketWire message, MessageContext ctx) {
        TickProcessQueue.getInstance((Side)Side.CLIENT).add(new TickProcessEntry(){

            public boolean process(World world) {
                return PacketWire.this.processPacket(message);
            }
        }, 20, 5);
        return null;
    }

    protected boolean processPacket(PacketWire message) {
        World world = NGTUtil.getClientWorld();
        TileEntityElectricalWiring tile = null;
        if (message.isBlock) {
            TileEntity tile1 = message.getTileEntity(world);
            if (tile1 instanceof TileEntityElectricalWiring) {
                tile = (TileEntityElectricalWiring)tile1;
            }
        } else {
            Entity entity = message.getEntity(world);
            if (entity instanceof EntityElectricalWiring) {
                tile = ((EntityElectricalWiring)entity).tileEW;
            }
        }
        if (tile != null) {
            tile.isActivated = message.isActivated;
            tile.func_145839_a(message.nbtData);
            return true;
        }
        return false;
    }
}

