/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.rail;

import java.util.List;
import javax.annotation.Nullable;
import jp.ngt.ngtlib.block.BlockArgHolder;
import jp.ngt.ngtlib.block.BlockContainerCustomWithMeta;
import jp.ngt.ngtlib.util.PermissionManager;
import jp.ngt.rtm.RTMItem;
import jp.ngt.rtm.RTMMaterial;
import jp.ngt.rtm.entity.train.EntityBogie;
import jp.ngt.rtm.entity.train.EntityTrainBase;
import jp.ngt.rtm.item.ItemRail;
import jp.ngt.rtm.modelpack.cfg.RailConfig;
import jp.ngt.rtm.modelpack.modelset.ModelSetRail;
import jp.ngt.rtm.modelpack.state.ResourceStateRail;
import jp.ngt.rtm.rail.TileEntityLargeRailBase;
import jp.ngt.rtm.rail.TileEntityLargeRailCore;
import jp.ngt.rtm.rail.util.RailMap;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockLargeRailBase
extends BlockContainerCustomWithMeta {
    public static final float THICKNESS = 0.0625f;
    public static final float AABB_ADD_Y = 256.0f;

    public BlockLargeRailBase() {
        super(RTMMaterial.RAIL_BASE);
        this.func_149711_c(1.0f);
        this.func_149713_g(0);
        this.func_149752_b(15.0f);
        this.func_149672_a(SoundType.field_185849_b);
        this.setAABB(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0));
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public TileEntity func_149915_a(World world, int par2) {
        return new TileEntityLargeRailBase();
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean isActualState) {
        boolean flag;
        int z;
        int y;
        int x = pos.func_177958_n();
        AxisAlignedBB aabb2 = this.getAABB((IBlockAccess)world, x, y = pos.func_177956_o(), z = pos.func_177952_p(), flag = this.preventMobMovement((IBlockAccess)world, pos) && entity instanceof EntityLiving);
        if (entityBox.func_72326_a(aabb2)) {
            collidingBoxes.add(aabb2);
        }
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.getAABB(world, 0, 0, 0, this.preventMobMovement(world, pos));
    }

    private AxisAlignedBB getAABB(IBlockAccess world, int x, int y, int z, boolean par5) {
        double d0 = par5 ? 256.0 : 0.0;
        AxisAlignedBB aabb = this.getAABBWithState(world, new BlockPos(x, y, z)).func_72317_d((double)x, (double)y, (double)z);
        aabb = aabb.func_186666_e(aabb.field_72337_e + d0);
        return aabb;
    }

    public boolean preventMobMovement(IBlockAccess world, BlockPos pos) {
        TileEntityLargeRailCore core = BlockLargeRailBase.getCore(world, pos);
        if (core != null) {
            ModelSetRail set = (ModelSetRail)core.getResourceState().getResourceSet();
            return !((RailConfig)set.getConfig()).allowCrossing;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        return this.getAABBWithState((IBlockAccess)world, pos).func_186670_a(pos);
    }

    protected AxisAlignedBB getAABBWithState(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null) {
            return field_185505_j;
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        float[] fa = ((TileEntityLargeRailBase)tile).getBlockHeights(x, y, z, 0.0625f, false);
        float height2 = 0.0f;
        for (int i = 0; i < 4; ++i) {
            height2 += fa[i];
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)((height2 *= 0.25f) < 0.0625f ? 0.0625f : height2), 1.0);
    }

    protected boolean removedByPlayer(BlockArgHolder holder, boolean willHarvest) {
        World world = holder.getWorld();
        EntityPlayer player = holder.getPlayer();
        BlockPos pos = holder.getBlockPos();
        if (world.field_72995_K) {
            return super.removedByPlayer(holder, willHarvest);
        }
        if (PermissionManager.INSTANCE.hasPermission((ICommandSender)player, "editRail")) {
            if (!player.field_71075_bZ.field_75098_d) {
                int x = pos.func_177958_n();
                int y = pos.func_177956_o();
                int z = pos.func_177952_p();
                TileEntityLargeRailCore tile1 = BlockLargeRailBase.getCore((IBlockAccess)world, pos);
                if (tile1 != null) {
                    this.dropRail(world, x, y, z, tile1.getResourceState());
                }
            }
            return super.removedByPlayer(holder, willHarvest);
        }
        return false;
    }

    protected void dropRail(World world, int x, int y, int z, ResourceStateRail prop) {
        if (!world.field_72995_K) {
            BlockLargeRailBase.func_180635_a((World)world, (BlockPos)new BlockPos(x, y, z), (ItemStack)ItemRail.getRailItem(prop));
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityLargeRailCore core = BlockLargeRailBase.getCore((IBlockAccess)world, pos);
        if (!world.field_72995_K && core != null) {
            RailMap[] railmaps;
            for (RailMap rm : railmaps = core.getAllRailMaps()) {
                rm.breakRail(world, core.getResourceState(), core);
            }
        }
        super.func_180663_b(world, pos, state);
    }

    protected boolean onBlockActivated(BlockArgHolder holder, float hitX, float hitY, float hitZ) {
        World world = holder.getWorld();
        EntityPlayer player = holder.getPlayer();
        if (!world.field_72995_K) {
            TileEntityLargeRailCore core = BlockLargeRailBase.getCore((IBlockAccess)world, holder.getBlockPos());
            if (core != null && player.func_184614_ca().func_77973_b() == RTMItem.paddle) {
                core.getRailMap(null).showRailProp();
            }
        }
        return false;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (world.field_72995_K) {
            EntityTrainBase train;
            boolean isSnow;
            TileEntityLargeRailCore rail = BlockLargeRailBase.getCore((IBlockAccess)world, pos);
            if (rail == null || rail.getResourceState() == null) {
                return;
            }
            Block base = rail.getResourceState().block;
            boolean bl = isSnow = base.func_149688_o(base.func_176223_P()) == Material.field_151597_y;
            if (isSnow && entity instanceof EntityBogie && (train = ((EntityBogie)entity).getTrain()) != null && train.getSpeed() > 0.0f) {
                double speed = (double)train.getSpeed() * 0.125;
                for (int i = 0; i < 5; ++i) {
                    double d0 = (double)pos.func_177958_n() + (double)world.field_73012_v.nextFloat();
                    double d1 = (double)pos.func_177956_o() + (double)world.field_73012_v.nextFloat() * 0.25;
                    double d2 = (double)pos.func_177952_p() + (double)world.field_73012_v.nextFloat();
                    double vx = (d0 - entity.field_70165_t) * speed;
                    double vz = (d2 - entity.field_70161_v) * speed;
                    world.func_175688_a(EnumParticleTypes.SNOW_SHOVEL, d0, d1, d2, vx, 0.125, vz, new int[0]);
                }
            }
        } else if (entity instanceof EntityTrainBase) {
            TileEntityLargeRailCore rail = BlockLargeRailBase.getCore((IBlockAccess)world, pos);
            if (rail != null) {
                rail.colliding = true;
            }
        }
    }

    public boolean isCore() {
        return false;
    }

    public static TileEntityLargeRailCore getCore(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityLargeRailBase) {
            return ((TileEntityLargeRailBase)tile).getRailCore();
        }
        return null;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntityLargeRailCore core = BlockLargeRailBase.getCore((IBlockAccess)world, pos);
        if (core != null) {
            return ItemRail.copyItemFromRail(core);
        }
        return null;
    }

    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.preventMobMovement(world, pos) ? PathNodeType.BLOCKED : PathNodeType.RAIL;
    }
}

