/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.rail;

import jp.ngt.ngtlib.block.BlockUtil;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.renderer.GLHelper;
import jp.ngt.ngtlib.renderer.NGTRenderer;
import jp.ngt.ngtlib.renderer.NGTTessellator;
import jp.ngt.ngtlib.util.ColorUtil;
import jp.ngt.ngtlib.util.NGTUtilClient;
import jp.ngt.rtm.RTMBlock;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.gui.InternalButton;
import jp.ngt.rtm.gui.InternalGUI;
import jp.ngt.rtm.network.PacketMarkerRPClient;
import jp.ngt.rtm.rail.BlockMarker;
import jp.ngt.rtm.rail.TileEntityLargeRailBase;
import jp.ngt.rtm.rail.TileEntityLargeRailCore;
import jp.ngt.rtm.rail.TileEntityMarker;
import jp.ngt.rtm.rail.util.MarkerState;
import jp.ngt.rtm.rail.util.RailMap;
import jp.ngt.rtm.rail.util.RailPosition;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public final class RenderMarkerBlock
extends TileEntitySpecialRenderer<TileEntityMarker> {
    public static final RenderMarkerBlock INSTANCE = new RenderMarkerBlock();
    private static final double FIT_RANGE_SQ = 4.0;
    private String[] displayStrings = new String[RTMCore.markerDisplayDistance / 10];

    private RenderMarkerBlock() {
        for (int i = 0; i < this.displayStrings.length; ++i) {
            this.displayStrings[i] = String.valueOf((i + 1) * 10) + "m";
        }
    }

    public boolean isGlobalRenderer(TileEntityMarker tileEntity) {
        return true;
    }

    public void render(TileEntityMarker tileEntity, double par2, double par4, double par6, float par8, int par9, float par10) {
        if (tileEntity.getMarkerRP() == null) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glDisable((int)2884);
        GLHelper.disableLighting();
        GL11.glTranslatef((float)((float)par2), (float)((float)par4), (float)((float)par6));
        this.renderGUI(tileEntity);
        GL11.glDisable((int)3553);
        if (tileEntity.getState(MarkerState.GRID) && tileEntity.getGrid() != null) {
            this.renderGrid(tileEntity);
        }
        if (tileEntity.getState(MarkerState.LINE1) || tileEntity.getState(MarkerState.LINE2)) {
            RailPosition rp0 = tileEntity.getMarkerRP();
            float x = (float)(rp0.posX - (double)rp0.blockX);
            float y = (float)(rp0.posY - (double)rp0.blockY);
            float z = (float)(rp0.posZ - (double)rp0.blockZ);
            if (tileEntity.getState(MarkerState.LINE1) && tileEntity.getRailMaps() != null) {
                this.renderLine(tileEntity, x, y, z);
            }
            if (tileEntity.getCoreMarker() != null) {
                this.renderAnchor(tileEntity, x, y, z);
            }
        }
        if (tileEntity.getState(MarkerState.DISTANCE)) {
            this.renderDistanceMark(tileEntity);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GLHelper.enableLighting();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
    }

    private void renderGUI(TileEntityMarker marker) {
        if (marker.gui == null) {
            int buttonColor = 61440;
            float buttonWidth = 2.8f;
            float buttonHeight = 0.5f;
            float guiHeight = (buttonHeight + 0.1f) * 5.0f + 0.1f;
            float startY = 0.5f;
            float startX = -(buttonWidth + 0.2f) / 2.0f;
            marker.gui = new InternalGUI(startX, startY, buttonWidth + 0.2f, guiHeight).setColor(65535);
            marker.buttons = new InternalButton[5];
            marker.buttons[0] = new InternalButton(startX += 0.1f, startY += 0.1f, buttonWidth, buttonHeight).setColor(buttonColor).setListner(button -> marker.flipState(MarkerState.ANCHOR21));
            marker.buttons[1] = new InternalButton(startX, startY += buttonHeight + 0.1f, buttonWidth, buttonHeight).setColor(buttonColor).setListner(button -> marker.flipState(MarkerState.LINE2));
            marker.buttons[2] = new InternalButton(startX, startY += buttonHeight + 0.1f, buttonWidth, buttonHeight).setColor(buttonColor).setListner(button -> marker.flipState(MarkerState.LINE1));
            marker.buttons[3] = new InternalButton(startX, startY += buttonHeight + 0.1f, buttonWidth, buttonHeight).setColor(buttonColor).setListner(button -> marker.flipState(MarkerState.GRID));
            marker.buttons[4] = new InternalButton(startX, startY += buttonHeight + 0.1f, buttonWidth, buttonHeight).setColor(buttonColor).setListner(button -> marker.flipState(MarkerState.DISTANCE));
            for (int i = 0; i < marker.buttons.length; ++i) {
                marker.gui.addButton(marker.buttons[i]);
            }
        }
        marker.buttons[0].setText(marker.getStateString(MarkerState.ANCHOR21), 0xFFFFFF, 0.05f);
        marker.buttons[1].setText(marker.getStateString(MarkerState.LINE2), 0xFFFFFF, 0.05f);
        marker.buttons[2].setText(marker.getStateString(MarkerState.LINE1), 0xFFFFFF, 0.05f);
        marker.buttons[3].setText(marker.getStateString(MarkerState.GRID), 0xFFFFFF, 0.05f);
        marker.buttons[4].setText(marker.getStateString(MarkerState.DISTANCE), 0xFFFFFF, 0.05f);
        GL11.glPushMatrix();
        float y = 0.5f;
        if (marker.getState(MarkerState.LINE1)) {
            y = 1.0f;
        }
        if (marker.getState(MarkerState.LINE2) && y < marker.getMarkerRP().constLimitHP) {
            y = marker.getMarkerRP().constLimitHP;
        }
        GL11.glTranslatef((float)0.5f, (float)y, (float)0.5f);
        GL11.glRotatef((float)(-NGTUtilClient.getMinecraft().func_175598_ae().field_78735_i + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        marker.gui.render();
        GL11.glPopMatrix();
    }

    private void renderGrid(TileEntityMarker marker) {
        GL11.glPushMatrix();
        NGTTessellator tessellator = NGTTessellator.instance;
        tessellator.startDrawing(1);
        tessellator.setColorOpaque_I(0);
        for (int[] ia : marker.getGrid()) {
            BlockPos pos = marker.func_174877_v();
            NGTRenderer.addFrame((NGTTessellator)tessellator, (float)(ia[0] - pos.func_177958_n()), (float)(ia[1] - pos.func_177956_o()), (float)(ia[2] - pos.func_177952_p()), (float)1.0f, (float)1.0f, (float)1.0f);
        }
        tessellator.draw();
        GL11.glPopMatrix();
    }

    private void renderDistanceMark(TileEntityMarker marker) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.5f, (float)0.0625f, (float)0.5f);
        int meta = marker.func_145832_p();
        Block block = marker.func_145838_q();
        int color = block == RTMBlock.marker ? 0xFF0000 : 255;
        float dir = (float)BlockMarker.getMarkerDir(marker.func_145838_q(), meta) * 45.0f;
        GL11.glRotatef((float)dir, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glDisable((int)3553);
        float size = 0.4f;
        NGTTessellator tessellator = NGTTessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.setColorOpaque_I(color);
        for (int i = 1; i < this.displayStrings.length; ++i) {
            float moveZ = (float)i * 10.0f;
            for (int j = -1; j <= 1; ++j) {
                float moveX = moveZ * (float)j;
                tessellator.addVertex(-0.4f + moveX, 0.0f, 0.4f + moveZ);
                tessellator.addVertex(-0.4f + moveX, 0.0f, -0.4f + moveZ);
                tessellator.addVertex(0.4f + moveX, 0.0f, -0.4f + moveZ);
                tessellator.addVertex(0.4f + moveX, 0.0f, 0.4f + moveZ);
            }
        }
        tessellator.draw();
        GL11.glEnable((int)3553);
        FontRenderer fontRenderer = NGTUtilClient.getMinecraft().func_175598_ae().func_78716_a();
        for (int i = 0; i < this.displayStrings.length; ++i) {
            float moveZ = (float)(i + 1) * 10.0f;
            for (int j = -1; j <= 1; ++j) {
                float moveX = moveZ * (float)j;
                GL11.glPushMatrix();
                GL11.glTranslatef((float)moveX, (float)0.0f, (float)moveZ);
                GL11.glRotatef((float)(-NGTUtilClient.getMinecraft().func_175598_ae().field_78735_i - dir), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glScalef((float)-0.25f, (float)-0.25f, (float)0.25f);
                String s = this.displayStrings[i];
                int i0 = fontRenderer.func_78256_a(s) / 2;
                fontRenderer.func_78276_b(s, -i0 / 2, -10, color);
                GL11.glPopMatrix();
            }
        }
        GL11.glPopMatrix();
    }

    private void renderLine(TileEntityMarker marker, float x, float y, float z) {
        if (marker.linePos == null) {
            marker.linePos = new float[marker.getRailMaps().length][][];
            for (int i = 0; i < marker.linePos.length; ++i) {
                RailMap rm = marker.getRailMaps()[i];
                RailPosition startRP = rm.getStartRP();
                if (!marker.getMarkerRP().equals(startRP)) continue;
                int max = (int)((float)rm.getLength() * 2.0f);
                double[] p2 = rm.getRailPos(max, 0);
                double h2 = rm.getRailHeight(max, 0);
                float[][] rp = new float[max + 1][5];
                marker.linePos[i] = new float[max + 1][];
                for (int j = 0; j < marker.linePos[i].length; ++j) {
                    double[] p1 = rm.getRailPos(max, j);
                    marker.linePos[i][j] = new float[]{(float)(p1[1] - p2[1]), (float)(rm.getRailHeight(max, j) - h2), (float)(p1[0] - p2[0])};
                }
            }
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)z);
        NGTTessellator tessellator = NGTTessellator.instance;
        for (int i = 0; i < marker.linePos.length; ++i) {
            if (marker.linePos[i] == null) continue;
            GL11.glPushMatrix();
            RailMap rm = marker.getRailMaps()[i];
            float x0 = (float)(rm.getStartRP().posX - marker.getMarkerRP().posX);
            float y0 = (float)(rm.getStartRP().posY - marker.getMarkerRP().posY);
            float z0 = (float)(rm.getStartRP().posZ - marker.getMarkerRP().posZ);
            GL11.glTranslatef((float)x0, (float)y0, (float)z0);
            tessellator.startDrawing(3);
            tessellator.setColorOpaque_I(16384);
            for (int j = 0; j < marker.linePos[i].length; ++j) {
                tessellator.addVertex(marker.linePos[i][j][0], marker.linePos[i][j][1], marker.linePos[i][j][2]);
            }
            tessellator.draw();
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    private void renderAnchor(TileEntityMarker marker, float x, float y, float z) {
        this.changeAnchor(marker);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)z);
        MarkerElement hoveredElement = MarkerElement.values()[marker.editMode];
        if (marker.editMode == 0) {
            hoveredElement = this.renderAnchorLine(marker, true, null);
        }
        if (marker.editMode == 0 && hoveredElement != MarkerElement.NONE && Mouse.isButtonDown((int)1)) {
            marker.editMode = hoveredElement.ordinal();
            marker.startPlayerPitch = NGTUtilClient.getMinecraft().field_71439_g.field_70125_A;
            marker.startPlayerYaw = NGTUtilClient.getMinecraft().field_71439_g.field_70759_as;
            marker.startMarkerHeight = marker.getMarkerRP().height;
        }
        this.renderAnchorLine(marker, false, hoveredElement);
        GL11.glPopMatrix();
    }

    private MarkerElement renderAnchorLine(TileEntityMarker marker, boolean isPickMode, MarkerElement hoveredElement) {
        int hits;
        int color;
        float lineWidth = (float)NGTUtilClient.getMinecraft().field_71440_d * 0.01f;
        if (isPickMode) {
            GLHelper.startMousePicking((float)(lineWidth * 2.0f));
        }
        GL11.glDisable((int)3553);
        float prevPointSize = GL11.glGetFloat((int)2833);
        float prevLineWidth = GL11.glGetFloat((int)2849);
        GL11.glPointSize((float)(lineWidth * 3.0f));
        GL11.glLineWidth((float)lineWidth);
        RailPosition rp = marker.getMarkerRP();
        int shadow = 0xC0C0C0;
        if (marker.getState(MarkerState.LINE2) && marker.isCoreMarker()) {
            GL11.glPushMatrix();
            GL11.glRotatef((float)rp.anchorYaw, (float)0.0f, (float)1.0f, (float)0.0f);
            if (isPickMode) {
                GL11.glLoadName((int)MarkerElement.CONST_LIMIT_WP.ordinal());
            }
            color = MarkerElement.CONST_LIMIT_WP.getColor();
            color = hoveredElement == MarkerElement.CONST_LIMIT_WP ? ColorUtil.multiplicating((int)color, (int)shadow) : color;
            RenderMarkerBlock.renderLine(rp.constLimitWP, rp.constLimitHN, 0.0f, rp.constLimitWP, rp.constLimitHP, 0.0f, color);
            if (isPickMode) {
                GL11.glLoadName((int)MarkerElement.CONST_LIMIT_WN.ordinal());
            }
            color = MarkerElement.CONST_LIMIT_WN.getColor();
            color = hoveredElement == MarkerElement.CONST_LIMIT_WN ? ColorUtil.multiplicating((int)color, (int)shadow) : color;
            RenderMarkerBlock.renderLine(rp.constLimitWN, rp.constLimitHP, 0.0f, rp.constLimitWN, rp.constLimitHN, 0.0f, color);
            if (isPickMode) {
                GL11.glLoadName((int)MarkerElement.CONST_LIMIT_HP.ordinal());
            }
            color = MarkerElement.CONST_LIMIT_HP.getColor();
            color = hoveredElement == MarkerElement.CONST_LIMIT_HP ? ColorUtil.multiplicating((int)color, (int)shadow) : color;
            RenderMarkerBlock.renderLine(rp.constLimitWP, rp.constLimitHP, 0.0f, rp.constLimitWN, rp.constLimitHP, 0.0f, color);
            if (isPickMode) {
                GL11.glLoadName((int)MarkerElement.CONST_LIMIT_HN.ordinal());
            }
            color = MarkerElement.CONST_LIMIT_HN.getColor();
            color = hoveredElement == MarkerElement.CONST_LIMIT_HN ? ColorUtil.multiplicating((int)color, (int)shadow) : color;
            RenderMarkerBlock.renderLine(rp.constLimitWN, rp.constLimitHN, 0.0f, rp.constLimitWP, rp.constLimitHN, 0.0f, color);
            GL11.glPopMatrix();
        }
        if (marker.getState(MarkerState.LINE1)) {
            GL11.glPushMatrix();
            if (isPickMode) {
                GL11.glLoadName((int)MarkerElement.HEIGHT.ordinal());
            }
            color = MarkerElement.HEIGHT.getColor();
            color = hoveredElement == MarkerElement.HEIGHT ? ColorUtil.multiplicating((int)color, (int)shadow) : color;
            RenderMarkerBlock.renderLine(0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, color);
            GL11.glRotatef((float)rp.anchorYaw, (float)0.0f, (float)1.0f, (float)0.0f);
            if (isPickMode) {
                GL11.glLoadName((int)MarkerElement.HORIZONTIAL.ordinal());
            }
            color = MarkerElement.HORIZONTIAL.getColor();
            color = hoveredElement == MarkerElement.HORIZONTIAL ? ColorUtil.multiplicating((int)color, (int)shadow) : color;
            RenderMarkerBlock.renderLine(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, rp.anchorLengthHorizontal, color);
            GL11.glPushMatrix();
            GL11.glRotatef((float)(-rp.anchorPitch), (float)1.0f, (float)0.0f, (float)0.0f);
            if (isPickMode) {
                GL11.glLoadName((int)MarkerElement.VERTICAL.ordinal());
            }
            color = MarkerElement.VERTICAL.getColor();
            color = hoveredElement == MarkerElement.VERTICAL ? ColorUtil.multiplicating((int)color, (int)shadow) : color;
            RenderMarkerBlock.renderLine(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, rp.anchorLengthVertical, color);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            float len = 1.0f;
            GL11.glRotatef((float)rp.cantEdge, (float)0.0f, (float)0.0f, (float)1.0f);
            if (isPickMode) {
                GL11.glLoadName((int)MarkerElement.CANT_EDGE.ordinal());
            }
            color = MarkerElement.CANT_EDGE.getColor();
            color = hoveredElement == MarkerElement.CANT_EDGE ? ColorUtil.multiplicating((int)color, (int)shadow) : color;
            RenderMarkerBlock.renderLine(0.0f, 0.0f, 0.0f, len, 0.0f, 0.0f, color);
            RenderMarkerBlock.renderLine(0.0f, 0.0f, 0.0f, -len, 0.0f, 0.0f, color);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            if (marker.isCoreMarker() && marker.getRailMaps() != null && marker.getRailMaps().length == 1) {
                RailMap rm = marker.getRailMaps()[0];
                int max = (int)((float)rm.getLength() * 2.0f);
                int index = max / 2;
                double[] pos0 = rm.getRailPos(max, 0);
                double[] pos = rm.getRailPos(max, index);
                double h0 = rm.getRailHeight(max, 0);
                double h = rm.getRailHeight(max, index);
                float yaw0 = rm.getRailRotation(max, 0);
                float yaw = rm.getRailRotation(max, index);
                GL11.glRotatef((float)(-rp.anchorYaw), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslatef((float)((float)(pos[1] - pos0[1])), (float)((float)(h - h0)), (float)((float)(pos[0] - pos0[0])));
                GL11.glRotatef((float)(rp.anchorYaw - (yaw0 - yaw)), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)rp.cantCenter, (float)0.0f, (float)0.0f, (float)1.0f);
                if (isPickMode) {
                    GL11.glLoadName((int)MarkerElement.CANT_CENTER.ordinal());
                }
                color = MarkerElement.CANT_CENTER.getColor();
                color = hoveredElement == MarkerElement.CANT_CENTER ? ColorUtil.multiplicating((int)color, (int)shadow) : color;
                RenderMarkerBlock.renderLine(0.0f, 0.0f, 0.0f, len, 0.0f, 0.0f, color);
                RenderMarkerBlock.renderLine(0.0f, 0.0f, 0.0f, -len, 0.0f, 0.0f, color);
            }
            GL11.glPopMatrix();
            GL11.glPopMatrix();
        }
        GL11.glPointSize((float)prevPointSize);
        GL11.glLineWidth((float)prevLineWidth);
        GL11.glEnable((int)3553);
        if (marker.getState(MarkerState.LINE1) && !isPickMode) {
            FontRenderer fontRenderer = NGTUtilClient.getMinecraft().func_175598_ae().func_78716_a();
            float scale = 0.04f;
            GL11.glPushMatrix();
            GL11.glRotatef((float)(-NGTUtilClient.getMinecraft().func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glScalef((float)(-scale), (float)(-scale), (float)scale);
            float x = 3.0f;
            float y = -34.0f;
            fontRenderer.func_175065_a(String.valueOf(rp.height), x, y, MarkerElement.HEIGHT.getColor(), false);
            fontRenderer.func_175065_a(String.valueOf(rp.anchorYaw), x, y += 6.0f, MarkerElement.HORIZONTIAL.getColor(), false);
            fontRenderer.func_175065_a(String.valueOf(rp.anchorPitch), x, y += 6.0f, MarkerElement.VERTICAL.getColor(), false);
            fontRenderer.func_175065_a(String.valueOf(rp.cantEdge), x, y += 6.0f, MarkerElement.CANT_EDGE.getColor(), false);
            fontRenderer.func_175065_a(String.valueOf(rp.cantCenter), x, y += 6.0f, MarkerElement.CANT_CENTER.getColor(), false);
            GL11.glPopMatrix();
        }
        if (isPickMode && (hits = GLHelper.finishMousePicking()) > 0) {
            int pickedId = GLHelper.getPickedObjId((int)0);
            return MarkerElement.values()[pickedId];
        }
        return MarkerElement.NONE;
    }

    public static void renderLine(float startX, float startY, float startZ, float endX, float endY, float endZ, int color) {
        NGTTessellator tessellator = NGTTessellator.instance;
        tessellator.startDrawing(1);
        tessellator.setColorOpaque_I(color);
        tessellator.addVertex(startX, startY, startZ);
        tessellator.addVertex(endX, endY, endZ);
        tessellator.draw();
        tessellator.startDrawing(0);
        tessellator.setColorOpaque_I(color);
        tessellator.addVertex(endX, endY, endZ);
        tessellator.draw();
    }

    private boolean changeAnchor(TileEntityMarker marker) {
        if (marker.editMode == 0 || marker.getCoreMarker() == null) {
            return false;
        }
        if (marker.editMode > 0 && Mouse.isButtonDown((int)1)) {
            marker.editMode = 0;
            RTMCore.NETWORK_WRAPPER.sendToServer((IMessage)new PacketMarkerRPClient(marker.getCoreMarker()));
        }
        MarkerElement curElm = MarkerElement.values()[marker.editMode];
        Minecraft mc = NGTUtilClient.getMinecraft();
        RailPosition rp = marker.getMarkerRP();
        float pitchDif = mc.field_71439_g.field_70125_A - marker.startPlayerPitch;
        float yawDif = mc.field_71439_g.field_70759_as - marker.startPlayerYaw;
        if (marker.getState(MarkerState.LINE1)) {
            if (curElm == MarkerElement.HEIGHT) {
                int height = marker.startMarkerHeight + (int)(-pitchDif / 1.0f);
                int n = height < 0 ? 0 : (height = height > 15 ? 15 : height);
                if (height != marker.getMarkerRP().height) {
                    rp.height = (byte)height;
                    rp.init();
                    marker.onChangeRailShape();
                    return true;
                }
                return false;
            }
            if (curElm == MarkerElement.CANT_EDGE) {
                float cantLimit = 80.0f;
                float cant = pitchDif < -cantLimit ? -cantLimit : (pitchDif > cantLimit ? cantLimit : pitchDif);
                RailPosition neighborRP = this.getNeighborRail(marker);
                if (neighborRP != null) {
                    cant = -neighborRP.cantEdge;
                }
                rp.cantEdge = cant;
                marker.onChangeRailShape();
                return true;
            }
            if (curElm == MarkerElement.CANT_CENTER) {
                float cant;
                float cantLimit = 80.0f;
                rp.cantCenter = cant = pitchDif < -cantLimit ? -cantLimit : (pitchDif > cantLimit ? cantLimit : pitchDif);
                marker.onChangeRailShape();
                return true;
            }
        }
        if (marker.getState(MarkerState.LINE2)) {
            RailMap map = marker.getRailMaps()[0];
            if (curElm == MarkerElement.CONST_LIMIT_HP) {
                float height = 3.0f + -pitchDif / 10.0f;
                map.getStartRP().constLimitHP = map.getEndRP().constLimitHP = (height = height < 1.9f ? 1.9f : height);
                marker.onChangeRailShape();
                return true;
            }
            if (curElm == MarkerElement.CONST_LIMIT_HN) {
                float height = -pitchDif / 10.0f;
                map.getStartRP().constLimitHN = map.getEndRP().constLimitHN = (height = height > 0.0f ? 0.0f : height);
                marker.onChangeRailShape();
                return true;
            }
            if (curElm == MarkerElement.CONST_LIMIT_WP) {
                float width = 1.5f + -yawDif / 10.0f;
                map.getStartRP().constLimitWP = map.getEndRP().constLimitWP = (width = width < 0.49f ? 0.49f : width);
                marker.onChangeRailShape();
                return true;
            }
            if (curElm == MarkerElement.CONST_LIMIT_WN) {
                float width = -1.5f + -yawDif / 10.0f;
                map.getStartRP().constLimitWN = map.getEndRP().constLimitWN = (width = width > -0.49f ? -0.49f : width);
                marker.onChangeRailShape();
                return true;
            }
        }
        if (marker.getState(MarkerState.LINE1)) {
            double dSq;
            RayTraceResult target = BlockUtil.getMOPFromPlayer((EntityPlayer)mc.field_71439_g, (double)128.0, (boolean)true);
            if (target == null || target.field_72313_a != RayTraceResult.Type.BLOCK) {
                return false;
            }
            Vec3d targetVec = target.field_72307_f;
            boolean fitOpposite = false;
            RailPosition oppositeRP = this.getOppositeRail(marker);
            if (oppositeRP != null && (dSq = NGTMath.getDistanceSq((double)targetVec.field_72450_a, (double)targetVec.field_72449_c, (double)oppositeRP.posX, (double)oppositeRP.posZ)) <= 4.0) {
                targetVec = new Vec3d(oppositeRP.posX, oppositeRP.posY, oppositeRP.posZ);
                fitOpposite = true;
            }
            if (marker.getState(MarkerState.ANCHOR21)) {
                double d0 = 0.6666666666666666;
                double x = (targetVec.field_72450_a - rp.posX) * d0 + rp.posX;
                double y = (targetVec.field_72448_b - rp.posY) * d0 + rp.posY;
                double z = (targetVec.field_72449_c - rp.posZ) * d0 + rp.posZ;
                targetVec = new Vec3d(x, y, z);
            }
            double dx = targetVec.field_72450_a - rp.posX;
            double dz = targetVec.field_72449_c - rp.posZ;
            if (dx != 0.0 && dz != 0.0) {
                RailPosition neighborRP = this.getNeighborRail(marker);
                float dirRad = (float)Math.atan2(dx, dz);
                float length = (float)(dx / (double)MathHelper.func_76126_a((float)dirRad));
                float yaw = NGTMath.toDegrees((float)dirRad);
                if (curElm == MarkerElement.HORIZONTIAL) {
                    if (neighborRP != null) {
                        yaw = MathHelper.func_76142_g((float)(neighborRP.anchorYaw + 180.0f));
                    }
                    rp.anchorYaw = yaw;
                    rp.anchorLengthHorizontal = length;
                } else if (curElm == MarkerElement.VERTICAL) {
                    float pitch = MathHelper.func_76142_g((float)(yaw - rp.anchorYaw));
                    if (neighborRP != null) {
                        pitch = -neighborRP.anchorPitch;
                    } else if (fitOpposite) {
                        double dy = targetVec.field_72448_b - rp.posY;
                        pitch = (float)NGTMath.toDegrees((double)Math.atan2(dy, NGTMath.firstSqrt((double)(dx * dx + dz * dz))));
                    }
                    rp.anchorPitch = pitch;
                    rp.anchorLengthVertical = length;
                }
                marker.onChangeRailShape();
                return true;
            }
        }
        return false;
    }

    private RailPosition getOppositeRail(TileEntityMarker tileEntity) {
        if (tileEntity.getRailMaps() == null) {
            return null;
        }
        RailPosition rp = tileEntity.getMarkerRP();
        RailPosition oppositeRP = null;
        for (RailMap map : tileEntity.getRailMaps()) {
            if (map.getStartRP().equals(rp)) {
                oppositeRP = map.getEndRP();
                break;
            }
            if (!map.getEndRP().equals(rp)) continue;
            oppositeRP = map.getStartRP();
            break;
        }
        return oppositeRP;
    }

    private RailPosition getNeighborRail(TileEntityMarker tileEntity) {
        byte markerDir = tileEntity.getMarkerRP().direction;
        BlockPos neighborPos = tileEntity.getMarkerRP().getNeighborBlockPos();
        TileEntity tile = tileEntity.func_145831_w().func_175625_s(neighborPos);
        if (!(tile instanceof TileEntityLargeRailBase)) {
            return null;
        }
        TileEntityLargeRailCore core = ((TileEntityLargeRailBase)tile).getRailCore();
        if (core == null) {
            return null;
        }
        double distanceSq = Double.MAX_VALUE;
        RailPosition rp = null;
        for (RailMap map : core.getAllRailMaps()) {
            double d2 = NGTMath.getDistanceSq((double)tileEntity.getMarkerRP().posX, (double)tileEntity.getMarkerRP().posZ, (double)map.getStartRP().posX, (double)map.getStartRP().posZ);
            if (d2 < distanceSq) {
                distanceSq = d2;
                rp = map.getStartRP();
            }
            if (!((d2 = NGTMath.getDistanceSq((double)tileEntity.getMarkerRP().posX, (double)tileEntity.getMarkerRP().posZ, (double)map.getEndRP().posX, (double)map.getEndRP().posZ)) < distanceSq)) continue;
            distanceSq = d2;
            rp = map.getEndRP();
        }
        return rp;
    }

    public static enum MarkerElement {
        NONE(0),
        HORIZONTIAL(65312),
        VERTICAL(0xFF8800),
        CANT_EDGE(0xFF00FF),
        CANT_CENTER(0xFF00FF),
        HEIGHT(0xFF1000),
        CONST_LIMIT_HP(1073407),
        CONST_LIMIT_HN(1073407),
        CONST_LIMIT_WP(1073407),
        CONST_LIMIT_WN(1073407);

        public final int color;

        private MarkerElement(int par2) {
            this.color = par2;
        }

        public int getColor() {
            return this.color;
        }
    }
}

