/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.rail;

import java.util.ArrayList;
import java.util.List;
import jp.ngt.ngtlib.math.AABBInt;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.rtm.rail.TileEntityLargeRailCore;
import jp.ngt.rtm.rail.util.RailMaker;
import jp.ngt.rtm.rail.util.RailMap;
import jp.ngt.rtm.rail.util.RailMapSwitch;
import jp.ngt.rtm.rail.util.RailPosition;
import jp.ngt.rtm.rail.util.SwitchType;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityLargeRailSwitchCore
extends TileEntityLargeRailCore {
    private SwitchType switchObj;
    private List<RailMapSwitch> openedRails = new ArrayList<RailMapSwitch>();

    @Override
    protected void readRailData(NBTTagCompound nbt) {
        int size = nbt.func_74771_c("Size");
        this.railPositions = new RailPosition[size];
        for (int i = 0; i < size; ++i) {
            this.railPositions[i] = RailPosition.readFromNBT(nbt.func_74775_l("RP" + i));
        }
    }

    private RailPosition getRP(int x, int y, int z, byte dir, boolean b) {
        RailPosition rp = new RailPosition(x, y, z, dir, (byte)(b ? 1 : 0));
        rp.anchorYaw = NGTMath.wrapAngle((float)((float)dir * 45.0f));
        return rp;
    }

    @Override
    protected void writeRailData(NBTTagCompound nbt) {
        nbt.func_74774_a("Size", (byte)this.railPositions.length);
        for (int i = 0; i < this.railPositions.length; ++i) {
            nbt.func_74782_a("RP" + i, (NBTBase)this.railPositions[i].writeToNBT());
        }
    }

    @Override
    public void setRailPositions(RailPosition[] par1) {
        super.setRailPositions(par1);
        this.onBlockChanged();
    }

    @Override
    public void createRailMap() {
        if (this.isLoaded() && this.switchObj == null) {
            this.switchObj = new RailMaker(this.func_145831_w(), this.railPositions).getSwitch();
        }
    }

    public SwitchType getSwitch() {
        if (this.switchObj == null) {
            this.createRailMap();
        }
        return this.switchObj;
    }

    @Override
    public byte getPacketType() {
        return 2;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.getSwitch() != null) {
            this.getSwitch().onUpdate(this.func_145831_w());
        }
    }

    public void onBlockChanged() {
        this.getSwitch().onBlockChanged(this.func_145831_w());
        if (!this.func_145831_w().field_72995_K) {
            this.sendPacket();
        }
    }

    @Override
    public RailMap getRailMap(Entity entity) {
        SwitchType st = this.getSwitch();
        if (st == null) {
            return null;
        }
        if (entity == null) {
            return this.getAllRailMaps()[0];
        }
        return st.getRailMap(entity);
    }

    public RailMapSwitch[] getAllRailMaps() {
        if (this.getSwitch() != null) {
            return this.getSwitch().getAllRailMap();
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected AxisAlignedBB getRenderAABB() {
        AABBInt box = this.getRailSize();
        AxisAlignedBB aabb = new AxisAlignedBB((double)(box.minX - 1), (double)box.minY, (double)(box.minZ - 1), (double)(box.maxX + 2), (double)(box.maxY + 2), (double)(box.maxZ + 2));
        boolean flag = aabb.field_72336_d - aabb.field_72340_a <= 3.0 && aabb.field_72334_f - aabb.field_72339_c <= 3.0;
        return flag ? null : aabb;
    }

    @Override
    public AABBInt getRailSize() {
        int minX = this.startPoint[0];
        int maxX = this.startPoint[0];
        int minY = this.func_174877_v().func_177956_o();
        int maxY = this.func_174877_v().func_177956_o();
        int minZ = this.startPoint[2];
        int maxZ = this.startPoint[2];
        for (RailPosition rp : this.railPositions) {
            minX = minX <= rp.blockX ? minX : rp.blockX;
            maxX = maxX >= rp.blockX ? maxX : rp.blockX;
            minZ = minZ <= rp.blockZ ? minZ : rp.blockZ;
            maxZ = maxZ >= rp.blockZ ? maxZ : rp.blockZ;
        }
        return new AABBInt(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Override
    public String getRailShapeName() {
        SwitchType st = this.getSwitch();
        AABBInt box = this.getRailSize();
        StringBuilder sb = new StringBuilder();
        sb.append("Type:Switch ").append(st.getName()).append(", ");
        sb.append("X:").append(box.sizeX()).append(", ");
        sb.append("Y:").append(box.sizeY()).append(", ");
        sb.append("Z:").append(box.sizeZ());
        return sb.toString();
    }
}

