/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.rail;

import java.util.List;
import jp.ngt.ngtlib.math.PooledVec3;
import jp.ngt.ngtlib.math.Vec3;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.entity.train.EntityTrainBase;
import jp.ngt.rtm.entity.train.util.BogieController;
import jp.ngt.rtm.network.PacketNotice;
import jp.ngt.rtm.rail.TileEntityLargeRailCore;
import jp.ngt.rtm.rail.util.RailMap;
import jp.ngt.rtm.rail.util.RailMapTurntable;
import jp.ngt.rtm.rail.util.RailPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityTurnTableCore
extends TileEntityLargeRailCore {
    public static final float ROTATION_INC = 0.5f;
    public static final float ROTATION_STEP = 15.0f;
    private boolean isGettingPower;
    private float rotation;

    @Override
    protected void readRailData(NBTTagCompound nbt) {
        super.readRailData(nbt);
        this.rotation = nbt.func_74760_g("Rotation");
    }

    @Override
    protected void writeRailData(NBTTagCompound nbt) {
        super.writeRailData(nbt);
        nbt.func_74776_a("Rotation", this.rotation);
    }

    @Override
    public void func_73660_a() {
        boolean b;
        super.func_73660_a();
        boolean bl = b = this.field_145850_b.func_175687_A(this.func_174877_v()) > 0;
        if (this.isGettingPower ^ b) {
            this.isGettingPower = b;
        }
        if (!this.func_145831_w().field_72995_K) {
            float f0 = this.rotation % 15.0f;
            if (this.isGettingPower || f0 != 0.0f) {
                this.rotation += 0.5f;
                if (this.rotation >= 360.0f) {
                    this.rotation = 0.0f;
                }
                RTMCore.NETWORK_WRAPPER.sendToAll((IMessage)new PacketNotice(1, "TT:" + this.getRotation(), (TileEntity)this));
                ((RailMapTurntable)this.getRailMap(null)).setRotation(this.rotation);
                this.updateTrainYaw();
            }
        }
    }

    private void updateTrainYaw() {
        List list = this.func_145831_w().func_72872_a(EntityTrainBase.class, new AxisAlignedBB((double)(this.getX() - 5), (double)this.getY(), (double)(this.getZ() - 5), (double)(this.getX() + 5), (double)(this.getY() + 3), (double)(this.getZ() + 5)));
        for (EntityTrainBase train : list) {
            Vec3 vec = PooledVec3.create((double)(train.field_70165_t - ((double)this.getX() + 0.5)), (double)0.0, (double)(train.field_70161_v - ((double)this.getZ() + 0.5)));
            vec = vec.rotateAroundY(0.5f);
            train.func_70080_a((double)this.getX() + 0.5 + vec.getX(), train.field_70163_u, (double)this.getZ() + 0.5 + vec.getZ(), train.field_70177_z + 0.5f, train.field_70125_A);
            train.bogieController.updateBogiePos(train, 0, BogieController.UpdateFlag.YAW);
            train.bogieController.updateBogiePos(train, 1, BogieController.UpdateFlag.YAW);
        }
    }

    @Override
    public void createRailMap() {
        if (this.isLoaded()) {
            RailPosition start = this.railPositions[0];
            RailPosition end = this.railPositions[1];
            int r = 0;
            if (start.blockX == end.blockX) {
                r = Math.abs(start.blockZ - end.blockZ) / 2;
            } else if (start.blockZ == end.blockZ) {
                r = Math.abs(start.blockX - end.blockX) / 2;
            }
            this.railmap = new RailMapTurntable(start, end, this.getX(), this.getY(), this.getZ(), r);
        }
    }

    public float getRotation() {
        return this.rotation;
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected AxisAlignedBB getRenderAABB() {
        if (this.isLoaded()) {
            int startX = this.railPositions[0].blockX;
            int startZ = this.railPositions[0].blockZ;
            int endX = this.railPositions[1].blockX;
            int endZ = this.railPositions[1].blockZ;
            int lenHalf = startX == endX ? Math.abs(endZ - startZ) / 2 : Math.abs(endX - startX) / 2;
            AxisAlignedBB aabb = new AxisAlignedBB((double)(this.getX() - lenHalf), (double)this.getY(), (double)(this.getZ() - lenHalf), (double)(this.getX() + lenHalf + 1), (double)(this.getY() + 3), (double)(this.getZ() + lenHalf + 1));
            return aabb;
        }
        return null;
    }

    @Override
    public void sendPacket() {
        super.sendPacket();
        if (this.field_145850_b == null || !this.field_145850_b.field_72995_K) {
            RTMCore.NETWORK_WRAPPER.sendToAll((IMessage)new PacketNotice(1, "TT:" + this.getRotation(), (TileEntity)this));
        }
    }

    @Override
    public String getRailShapeName() {
        RailMap map = this.getRailMap(null);
        StringBuilder sb = new StringBuilder();
        sb.append("Type:TurnTable, ");
        sb.append("X:").append(map.getEndRP().blockX - map.getStartRP().blockX).append(", ");
        sb.append("Y:").append(map.getEndRP().blockY - map.getStartRP().blockY).append(", ");
        sb.append("Z:").append(map.getEndRP().blockZ - map.getStartRP().blockZ);
        return sb.toString();
    }
}

