/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.rail.util;

import jp.ngt.ngtlib.math.BezierCurve;
import jp.ngt.ngtlib.math.ILine;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.math.StraightLine;
import jp.ngt.rtm.rail.util.RailMap;
import jp.ngt.rtm.rail.util.RailPosition;
import net.minecraft.world.World;

public class RailMapBasic
extends RailMap {
    protected final RailPosition startRP;
    protected final RailPosition endRP;
    protected double length;
    protected ILine lineHorizontal;
    protected ILine lineVertical;

    public RailMapBasic(RailPosition par1, RailPosition par2) {
        this.startRP = par1;
        this.endRP = par2;
        this.endRP.cantCenter = this.startRP.cantCenter;
        this.createLine();
    }

    protected void createLine() {
        boolean flagV1;
        boolean flag3;
        double x0 = this.startRP.posX;
        double y0 = this.startRP.posY;
        double z0 = this.startRP.posZ;
        double x1 = this.endRP.posX;
        double y1 = this.endRP.posY;
        double z1 = this.endRP.posZ;
        boolean flag1 = (this.endRP.direction - this.startRP.direction) % 4 == 0;
        boolean flag2 = z0 == z1 || x0 == x1;
        boolean bl = flag3 = Math.abs(z0 - z1) == Math.abs(x0 - x1) && this.startRP.direction % 2 != 0 && this.endRP.direction % 2 != 0;
        if (flag1 && (flag2 || flag3)) {
            this.lineHorizontal = new StraightLine(z0, x0, z1, x1);
        } else {
            double d1;
            boolean b0;
            double min;
            double ddx;
            double ddz = Math.abs(z1 - z0);
            double max = ddz >= (ddx = Math.abs(x1 - x0)) ? ddz : ddx;
            double d = min = ddz <= ddx ? ddz : ddx;
            if (this.startRP.anchorLengthHorizontal <= 0.0f) {
                b0 = this.startRP.direction % 2 == 0;
                d1 = b0 ? max : min;
                this.startRP.anchorLengthHorizontal = (float)(d1 * 0.5522847771644592);
            }
            if (this.endRP.anchorLengthHorizontal <= 0.0f) {
                b0 = this.endRP.direction % 2 == 0;
                d1 = b0 ? max : min;
                this.endRP.anchorLengthHorizontal = (float)(d1 * 0.5522847771644592);
            }
            double d12 = NGTMath.cos((float)this.startRP.anchorYaw) * this.startRP.anchorLengthHorizontal;
            double d2 = NGTMath.sin((float)this.startRP.anchorYaw) * this.startRP.anchorLengthHorizontal;
            double d3 = NGTMath.cos((float)this.endRP.anchorYaw) * this.endRP.anchorLengthHorizontal;
            double d4 = NGTMath.sin((float)this.endRP.anchorYaw) * this.endRP.anchorLengthHorizontal;
            this.lineHorizontal = new BezierCurve(z0, x0, z0 + d12, x0 + d2, z1 + d3, x1 + d4, z1, x1);
        }
        double lenXZ = Math.sqrt(NGTMath.pow((double)(x1 - x0), (int)2) + NGTMath.pow((double)(z1 - z0), (int)2));
        boolean bl2 = flagV1 = this.startRP.anchorLengthVertical == 0.0f && this.endRP.anchorLengthVertical == 0.0f;
        if (flagV1) {
            this.lineVertical = new StraightLine(0.0, y0, lenXZ, y1);
        } else {
            double d1 = NGTMath.cos((float)this.startRP.anchorPitch) * this.startRP.anchorLengthVertical;
            double d2 = NGTMath.sin((float)this.startRP.anchorPitch) * this.startRP.anchorLengthVertical;
            double d3 = NGTMath.cos((float)this.endRP.anchorPitch) * this.endRP.anchorLengthVertical;
            double d4 = NGTMath.sin((float)this.endRP.anchorPitch) * this.endRP.anchorLengthVertical;
            this.lineVertical = new BezierCurve(0.0, y0, d1, y0 + d2, lenXZ - d3, y1 + d4, lenXZ, y1);
        }
    }

    @Override
    public RailPosition getStartRP() {
        return this.startRP;
    }

    @Override
    public RailPosition getEndRP() {
        return this.endRP;
    }

    @Override
    public double getLength() {
        if (this.length <= 0.0) {
            double height = this.endRP.posY - this.startRP.posY;
            if (height == 0.0) {
                this.length = this.lineHorizontal.getLength();
            } else {
                double d0 = this.lineHorizontal.getLength();
                this.length = Math.sqrt(d0 * d0 + height * height);
            }
        }
        return this.length;
    }

    @Override
    public int getNearlestPoint(int par1, double par2, double par3) {
        return this.lineHorizontal.getNearlestPoint(par1, par2, par3);
    }

    @Override
    public double[] getRailPos(int par1, int par2) {
        return this.lineHorizontal.getPoint(par1, par2);
    }

    @Override
    public double getRailHeight(int par1, int par2) {
        float railWidth = 3.0f;
        double height = this.lineVertical.getPoint(par1, par2)[1];
        float cant = this.getCant(par1, par2);
        if (cant != 0.0f) {
            double h2 = Math.abs(NGTMath.sin((float)cant) * railWidth * 0.5f);
            height += h2;
        }
        return height;
    }

    @Override
    public float getRailYaw(int par1, int par2) {
        return NGTMath.toDegrees((float)((float)this.lineHorizontal.getSlope(par1, par2)));
    }

    @Override
    public float getRailPitch(int par1, int par2) {
        return NGTMath.toDegrees((float)((float)this.lineVertical.getSlope(par1, par2)));
    }

    @Override
    public float getRailRoll(int split, int t) {
        float ft = 2.0f * (float)t / (float)split;
        float c1 = ft <= 1.0f ? (1.0f - ft) * this.startRP.cantEdge : (ft - 1.0f) * -this.endRP.cantEdge;
        float c2 = ft <= 1.0f ? ft * this.startRP.cantCenter : (2.0f - ft) * this.startRP.cantCenter;
        float cunt = c1 + c2;
        float rand = 0.0f;
        if (this.startRP.cantRandom > 0.0f) {
            float x = (float)(this.getLength() * (double)t / (double)split) * this.startRP.cantRandom;
            float scale = 3.0f;
            rand = NGTMath.getSin((float)x) + NGTMath.getSin((float)(x * 0.51f)) + NGTMath.getSin((float)(x * 0.252f)) + NGTMath.getSin((float)(x * 0.1253f)) * 0.25f * scale;
        }
        return cunt + rand;
    }

    public boolean hasPoint(int x, int z) {
        boolean flag1 = this.startRP.blockX == x && this.startRP.blockZ == z;
        boolean flag2 = this.endRP.blockX == x && this.endRP.blockZ == z;
        return flag1 || flag2;
    }

    public boolean isGettingPowered(World world) {
        return this.startRP.checkRSInput(world) && this.endRP.checkRSInput(world);
    }
}

