/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.render;

import java.util.LinkedList;
import java.util.List;
import jp.ngt.ngtlib.renderer.model.IModelNGT;
import jp.ngt.rtm.electric.SignalLevel;
import jp.ngt.rtm.modelpack.cfg.SignalConfig;
import jp.ngt.rtm.modelpack.modelset.ModelSetSignal;
import jp.ngt.rtm.render.ModelObject;
import jp.ngt.rtm.render.RenderPass;
import jp.ngt.rtm.render.SignalPartsRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class BasicSignalPartsRenderer
extends SignalPartsRenderer {
    public final ModelSetSignal.LightParts[] lightParts;
    private List<String> lightList = new LinkedList<String>();

    public BasicSignalPartsRenderer(SignalConfig cfg, String ... args) {
        super(args);
        this.lightParts = ModelSetSignal.parseLightParts(cfg.lights);
    }

    @Override
    public void init(ModelSetSignal par1, ModelObject par2) {
        super.init(par1, par2);
    }

    @Override
    public void render(TileEntity entity, RenderPass pass, float par3) {
        GL11.glPushMatrix();
        this.lightList.clear();
        IModelNGT model = this.modelObj.model;
        SignalConfig cfg = (SignalConfig)((ModelSetSignal)this.modelSet).getConfig();
        boolean smoothing = cfg.smoothing;
        if (pass == RenderPass.NORMAL) {
            model.renderOnly(smoothing, cfg.modelPartsFixture.objects);
        }
        if (cfg.rotateBody) {
            float yaw = this.getRotation(entity) - this.getBlockDirection(entity);
            float[] fa1 = cfg.modelPartsBody.pos;
            GL11.glTranslatef((float)fa1[0], (float)fa1[1], (float)fa1[2]);
            GL11.glRotatef((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)(-fa1[0]), (float)(-fa1[1]), (float)(-fa1[2]));
        }
        if (pass == RenderPass.NORMAL) {
            model.renderOnly(smoothing, cfg.modelPartsBody.objects);
        } else if (pass == RenderPass.LIGHT) {
            int signal = this.getSignal(entity);
            if (signal > SignalLevel.HIGH_SPEED_PROCEED.level) {
                signal = SignalLevel.HIGH_SPEED_PROCEED.level;
            }
            boolean finish = false;
            int i0 = -1;
            for (int j = 0; j < 2; ++j) {
                if (j == 1) {
                    float f0 = 0.0625f;
                    GL11.glColor4f((float)f0, (float)f0, (float)f0, (float)1.0f);
                }
                for (int i = 0; i < this.lightParts.length; ++i) {
                    if (j == 0) {
                        boolean render = false;
                        if (!finish && signal > 0 && signal <= this.lightParts[i].signalLevel) {
                            finish = true;
                            render = true;
                            int itv = this.lightParts[i].interval;
                            if (itv > 0) {
                                boolean bl = render = this.getTick(entity) / itv % 2 == 0;
                            }
                        }
                        if (!render) continue;
                        i0 = i;
                        String[] stringArray = this.lightParts[i].parts;
                        int n = stringArray.length;
                        for (int k = 0; k < n; ++k) {
                            String s = stringArray[k];
                            model.renderPart(smoothing, s);
                            this.lightList.add(s);
                        }
                        continue;
                    }
                    for (String s : this.lightParts[i].parts) {
                        if (this.lightList.contains(s)) continue;
                        model.renderPart(smoothing, s);
                    }
                }
            }
        }
        GL11.glPopMatrix();
    }
}

