/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.render;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jp.ngt.ngtlib.renderer.model.GroupObject;
import jp.ngt.ngtlib.renderer.model.NGTOModel;
import jp.ngt.ngtlib.util.NGTUtil;
import jp.ngt.rtm.modelpack.cfg.ModelConfig;
import jp.ngt.rtm.modelpack.cfg.VehicleBaseConfig;
import jp.ngt.rtm.modelpack.modelset.ModelSetVehicleBase;
import jp.ngt.rtm.render.ModelObject;
import jp.ngt.rtm.render.Parts;
import jp.ngt.rtm.render.PartsWithChildren;
import jp.ngt.rtm.render.RenderPass;
import jp.ngt.rtm.render.VehiclePartsRenderer;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class BasicVehiclePartsRenderer
extends VehiclePartsRenderer {
    private Parts body;
    private PartsWithChildren[] doorLeft;
    private PartsWithChildren[] doorRight;
    private PartsWithChildren[] pantographFront;
    private PartsWithChildren[] pantographBack;

    public BasicVehiclePartsRenderer(String ... par1) {
        super(par1);
    }

    @Override
    public void init(ModelSetVehicleBase par1, ModelObject par2) {
        ModelConfig cfg = par1.getConfig();
        ArrayList<String> list = new ArrayList<String>();
        this.doorLeft = ((VehicleBaseConfig)cfg).door_left != null ? this.getParts(list, ((VehicleBaseConfig)cfg).door_left) : new PartsWithChildren[]{};
        this.doorRight = ((VehicleBaseConfig)cfg).door_right != null ? this.getParts(list, ((VehicleBaseConfig)cfg).door_right) : new PartsWithChildren[]{};
        this.pantographFront = ((VehicleBaseConfig)cfg).pantograph_front != null ? this.getParts(list, ((VehicleBaseConfig)cfg).pantograph_front) : new PartsWithChildren[]{};
        this.pantographBack = ((VehicleBaseConfig)cfg).pantograph_back != null ? this.getParts(list, ((VehicleBaseConfig)cfg).pantograph_back) : new PartsWithChildren[]{};
        List goList = par2.model.getGroupObjects();
        ArrayList<String> bodyParts = new ArrayList<String>();
        for (GroupObject obj : goList) {
            if (list.contains(obj.name)) continue;
            bodyParts.add(obj.name);
        }
        if (bodyParts.isEmpty() && par2.model instanceof NGTOModel) {
            bodyParts.add("default");
        }
        this.body = new Parts(bodyParts.toArray(new String[list.size()]));
        this.partsList.addAll(Arrays.asList(this.doorLeft));
        this.partsList.addAll(Arrays.asList(this.doorRight));
        this.partsList.addAll(Arrays.asList(this.pantographFront));
        this.partsList.addAll(Arrays.asList(this.pantographBack));
        this.partsList.add(this.body);
        super.init(par1, par2);
    }

    private PartsWithChildren[] getParts(List<String> list, VehicleBaseConfig.VehicleParts[] parts) {
        PartsWithChildren[] array = new PartsWithChildren[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            array[i] = new PartsWithChildren(parts[i].objects);
            NGTUtil.addArray(list, (Object[])parts[i].objects);
            if (parts[i].childParts == null) continue;
            NGTUtil.addArray(array[i].childParts, (Object[])this.getParts(list, parts[i].childParts));
        }
        return array;
    }

    @Override
    public void render(Entity entity, RenderPass pass, float par3) {
        int j;
        float move;
        this.body.render(this);
        ModelConfig cfg = ((ModelSetVehicleBase)this.modelSet).getConfig();
        if (((VehicleBaseConfig)cfg).door_left != null) {
            move = this.getDoorMovementL(entity);
            for (j = 0; j < ((VehicleBaseConfig)cfg).door_left.length; ++j) {
                this.renderParts(this.sigmoid(move), ((VehicleBaseConfig)cfg).door_left[j], this.doorLeft[j]);
            }
        }
        if (((VehicleBaseConfig)cfg).door_right != null) {
            move = this.getDoorMovementR(entity);
            for (j = 0; j < ((VehicleBaseConfig)cfg).door_right.length; ++j) {
                this.renderParts(this.sigmoid(move), ((VehicleBaseConfig)cfg).door_right[j], this.doorRight[j]);
            }
        }
        if (((VehicleBaseConfig)cfg).pantograph_front != null) {
            move = this.getPantographMovementFront(entity);
            for (j = 0; j < ((VehicleBaseConfig)cfg).pantograph_front.length; ++j) {
                this.renderParts(move, ((VehicleBaseConfig)cfg).pantograph_front[j], this.pantographFront[j]);
            }
        }
        if (((VehicleBaseConfig)cfg).pantograph_back != null) {
            move = this.getPantographMovementBack(entity);
            for (j = 0; j < ((VehicleBaseConfig)cfg).pantograph_back.length; ++j) {
                this.renderParts(move, ((VehicleBaseConfig)cfg).pantograph_back[j], this.pantographBack[j]);
            }
        }
    }

    private void renderParts(float move, VehicleBaseConfig.VehicleParts parts, PartsWithChildren parts2) {
        int i;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)parts.pos[0], (float)parts.pos[1], (float)parts.pos[2]);
        for (i = 0; i < parts.transform.length; ++i) {
            float[] fa = parts.transform[i];
            if (fa.length == 3) {
                GL11.glTranslatef((float)(fa[0] * move), (float)(fa[1] * move), (float)(fa[2] * move));
                continue;
            }
            if (fa.length != 4) continue;
            GL11.glRotatef((float)(fa[0] * move), (float)fa[1], (float)fa[2], (float)fa[3]);
        }
        GL11.glTranslatef((float)(-parts.pos[0]), (float)(-parts.pos[1]), (float)(-parts.pos[2]));
        parts2.render(this);
        if (parts.childParts != null) {
            for (i = 0; i < parts.childParts.length; ++i) {
                this.renderParts(move, parts.childParts[i], (PartsWithChildren)parts2.childParts.get(i));
            }
        }
        GL11.glPopMatrix();
    }
}

