/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.render;

import jp.ngt.ngtlib.math.PooledVec3;
import jp.ngt.ngtlib.math.Vec3;
import jp.ngt.rtm.RTMBlock;
import jp.ngt.rtm.block.tileentity.TileEntityCrossingGate;
import jp.ngt.rtm.block.tileentity.TileEntityLight;
import jp.ngt.rtm.block.tileentity.TileEntityMachineBase;
import jp.ngt.rtm.block.tileentity.TileEntityPoint;
import jp.ngt.rtm.block.tileentity.TileEntityTurnstile;
import jp.ngt.rtm.modelpack.modelset.ModelSetMachine;
import jp.ngt.rtm.render.TileEntityPartsRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector3f;

@SideOnly(value=Side.CLIENT)
public class MachinePartsRenderer
extends TileEntityPartsRenderer<ModelSetMachine> {
    private static Vector3f VEC3F_TMP = new Vector3f();
    private static final double[] BUF = new double[3];

    public MachinePartsRenderer(String ... par1) {
        super(par1);
    }

    public float getMovingCount(TileEntity par1) {
        if (par1 != null) {
            if (par1.func_145838_q() == RTMBlock.crossingGate) {
                TileEntityCrossingGate gate = (TileEntityCrossingGate)par1;
                return (float)gate.barMoveCount / 90.0f;
            }
            if (par1.func_145838_q() == RTMBlock.turnstile) {
                TileEntityTurnstile turnstile = (TileEntityTurnstile)par1;
                return turnstile.canThrough() ? 0.0f : 1.0f;
            }
            if (par1.func_145838_q() == RTMBlock.point) {
                TileEntityPoint point = (TileEntityPoint)par1;
                return point.isActivated() ? 1.0f : 0.0f;
            }
        }
        return 0.0f;
    }

    public int getLightState(TileEntity par1) {
        if (par1 != null) {
            if (par1.func_145838_q() == RTMBlock.crossingGate) {
                TileEntityCrossingGate gate = (TileEntityCrossingGate)par1;
                return gate.lightCount;
            }
            if (par1.func_145838_q() == RTMBlock.light) {
                TileEntityLight light = (TileEntityLight)par1;
                return light.isGettingPower ? 1 : -1;
            }
        }
        return -1;
    }

    public int getLodState(TileEntity par1) {
        if (par1 != null && par1.func_145838_q() == RTMBlock.point) {
            TileEntityPoint point = (TileEntityPoint)par1;
            return point.getMove() > 0.0f ? 1 : -1;
        }
        return 0;
    }

    public int getTick(TileEntity par1) {
        return par1 == null ? 0 : ((TileEntityMachineBase)par1).tick;
    }

    public float getPitch(TileEntity par1) {
        if (par1 != null) {
            TileEntityMachineBase machine = (TileEntityMachineBase)par1;
            return machine.getPitch();
        }
        return 0.0f;
    }

    public float getYaw(TileEntity par1) {
        if (par1 != null) {
            TileEntityMachineBase machine = (TileEntityMachineBase)par1;
            return machine.getRotation();
        }
        return 0.0f;
    }

    public Vector3f getNormal(TileEntity par1, float x, float y, float z, float pitch, float yaw) {
        if (par1 != null) {
            TileEntityMachineBase machine = (TileEntityMachineBase)par1;
            Vec3 vec = machine.getNormal(x, y, z, pitch, yaw);
            vec = vec.rotateAroundX(pitch).rotateAroundY(yaw);
            VEC3F_TMP.set((float)vec.getX(), (float)vec.getY(), (float)vec.getZ());
        }
        return VEC3F_TMP;
    }

    public double[] getLightPos(TileEntity par1, float x, float y, float z, float pitch, float yaw) {
        double posX = 0.0;
        double posY = 0.0;
        double posZ = 0.0;
        if (par1 != null) {
            TileEntityMachineBase machine = (TileEntityMachineBase)par1;
            Vec3 vec = PooledVec3.create((double)x, (double)y, (double)z);
            vec = MachinePartsRenderer.rotateVec(vec, machine.func_145832_p(), pitch, yaw);
            BlockPos pos = par1.func_174877_v();
            posX = (double)pos.func_177958_n() + 0.5 + vec.getX();
            posY = (double)pos.func_177956_o() + 0.5 + vec.getY();
            posZ = (double)pos.func_177952_p() + 0.5 + vec.getZ();
        }
        MachinePartsRenderer.BUF[0] = posX;
        MachinePartsRenderer.BUF[1] = posY;
        MachinePartsRenderer.BUF[2] = posZ;
        return BUF;
    }

    public static Vec3 rotateVec(Vec3 vec, int dir, float pitch, float yaw) {
        switch (dir) {
            case 0: {
                vec = vec.rotateAroundX(pitch);
                vec = vec.rotateAroundY(yaw);
                break;
            }
            case 1: {
                vec = vec.rotateAroundX(-pitch);
                vec = vec.rotateAroundY(yaw);
                break;
            }
            case 2: {
                vec = vec.rotateAroundX(-pitch + 90.0f);
                vec = vec.rotateAroundY(yaw);
                vec = vec.rotateAroundX(90.0f);
                break;
            }
            case 3: {
                vec = vec.rotateAroundX(-pitch + 90.0f);
                vec = vec.rotateAroundY(yaw);
                vec = vec.rotateAroundX(-90.0f);
                break;
            }
            case 4: {
                vec = vec.rotateAroundX(-pitch + 90.0f);
                vec = vec.rotateAroundY(yaw);
                vec = vec.rotateAroundZ(-90.0f);
                break;
            }
            case 5: {
                vec = vec.rotateAroundX(-pitch + 90.0f);
                vec = vec.rotateAroundY(yaw);
                vec = vec.rotateAroundZ(90.0f);
            }
        }
        return vec;
    }
}

