/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.render;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jp.ngt.ngtlib.io.FileType;
import jp.ngt.ngtlib.io.NGTText;
import jp.ngt.ngtlib.io.ResourceLocationCustom;
import jp.ngt.ngtlib.renderer.GLHelper;
import jp.ngt.ngtlib.renderer.model.IModelNGT;
import jp.ngt.ngtlib.renderer.model.MCModel;
import jp.ngt.ngtlib.renderer.model.Material;
import jp.ngt.ngtlib.renderer.model.ModelLoader;
import jp.ngt.ngtlib.renderer.model.TextureSet;
import jp.ngt.ngtlib.renderer.model.VecAccuracy;
import jp.ngt.ngtlib.util.NGTUtilClient;
import jp.ngt.rtm.entity.train.EntityBogie;
import jp.ngt.rtm.modelpack.IResourceSelector;
import jp.ngt.rtm.modelpack.ModelPackManager;
import jp.ngt.rtm.modelpack.cfg.ModelConfig;
import jp.ngt.rtm.modelpack.modelset.ModelSetBase;
import jp.ngt.rtm.render.BasicPartsRenderer;
import jp.ngt.rtm.render.MCModelRenderer;
import jp.ngt.rtm.render.MCVehicleRenderer;
import jp.ngt.rtm.render.PartsRenderer;
import jp.ngt.rtm.render.RTMRenderers;
import jp.ngt.rtm.render.RenderPass;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ModelObject {
    private static ModelObject DUMMY;
    public final IModelNGT model;
    public final TextureSet[] textures;
    public final PartsRenderer renderer;
    public final boolean light;
    public final boolean alphaBlend;
    private final boolean useTexture;
    private String vshPath;
    private String fshPath;
    public boolean useShader;
    private int program;

    public ModelObject(ModelConfig.ModelSource par1, ModelSetBase par2, PartsRenderer par3, Object ... args) {
        String filePath = par1.modelFile;
        this.model = ModelPackManager.INSTANCE.loadModel(filePath, 4, true, (ModelConfig)par2.getConfig(), par2.md5);
        Material[] materials = this.getMaterials(this.getTextureMap(par1.textures));
        this.textures = new TextureSet[materials.length];
        boolean useLight = false;
        boolean useAlpha = false;
        int size = materials.length != par1.textures.length ? 1 : materials.length;
        for (int i = 0; i < size; ++i) {
            Material mat = materials[i];
            String[] sa = par1.textures[size == 1 ? (byte)0 : mat.id];
            String texOption = sa.length >= 3 ? sa[2] : "";
            boolean flagLight = texOption.contains("Light");
            boolean flagAlpha = texOption.contains("AlphaBlend");
            boolean disableSubTex = texOption.contains("OneTex");
            int texSize = flagLight && !disableSubTex ? 3 : 0;
            String[] lightTextureNames = new String[sa.length >= 4 ? sa.length - 3 : 0];
            if (lightTextureNames.length > 0) {
                for (int j = 0; j < lightTextureNames.length; ++j) {
                    lightTextureNames[j] = sa[j + 3];
                }
                texSize = lightTextureNames.length;
            }
            this.textures[mat.id] = new TextureSet(mat, texSize, flagAlpha, flagLight, lightTextureNames);
            useLight |= flagLight;
            useAlpha |= flagAlpha;
        }
        this.light = useLight;
        this.alphaBlend = useAlpha;
        boolean bl = this.useTexture = this.model.getType() != FileType.NGTO && this.model.getType() != FileType.NGTZ;
        if (this.textures[0] == null) {
            this.textures[0] = new TextureSet(new Material(0, new ResourceLocation("hoge")), 0, false, false, new String[0]);
        }
        this.renderer = par3 == null ? this.getPartsRenderer(par1.rendererPath, this.model, args) : par3;
        this.renderer.init(par2, this);
        this.vshPath = par1.vertexShaderPath;
        this.fshPath = par1.fragmentShaderPath;
    }

    public ModelObject(IModelNGT par1, TextureSet[] par2) {
        this.model = par1;
        this.textures = par2;
        this.light = false;
        this.alphaBlend = false;
        this.useTexture = true;
        this.renderer = this.getPartsRenderer(null, par1, new Object[0]);
    }

    public static ModelObject getDummy() {
        if (DUMMY == null) {
            DUMMY = new ModelObject((IModelNGT)ModelLoader.loadModel((ResourceLocation)new ResourceLocationCustom("models/ModelContainer_19g.obj"), (VecAccuracy)VecAccuracy.LOW, (Object[])new Object[0]), new TextureSet[]{new TextureSet(new Material(0, ModelPackManager.INSTANCE.getResource("textures/container/19g_JRF_0.png")), 0, false, false, new String[0])});
        }
        return DUMMY;
    }

    private PartsRenderer getPartsRenderer(String path, IModelNGT par2, Object ... args) {
        boolean b0;
        boolean bl = b0 = args.length < 1 || !"isBogie".equals(args[0]);
        if (path != null) {
            return RTMRenderers.getRendererWithScript(ModelPackManager.INSTANCE.getResource(path), String.valueOf(b0));
        }
        if (par2 instanceof MCModel) {
            if (args.length >= 1 && "vehicle".equals(args[0])) {
                return new MCVehicleRenderer(String.valueOf(b0));
            }
            return new MCModelRenderer(String.valueOf(b0));
        }
        return new BasicPartsRenderer(new String[0]);
    }

    private void initShader() {
        if (this.vshPath != null && this.fshPath != null) {
            try {
                String vsh = NGTText.getText((ResourceLocation)new ResourceLocation(this.vshPath), (boolean)true);
                String fsh = NGTText.getText((ResourceLocation)new ResourceLocation(this.fshPath), (boolean)true);
                this.program = GLHelper.getShaderProgram((String)vsh, (String)fsh);
                this.useShader = this.program > 0;
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.program = -1;
    }

    public void render(Object entity, ModelConfig cfg, int pass, float partialTick) {
        this.preRender();
        GL11.glPushMatrix();
        if (!(entity instanceof EntityBogie)) {
            float[] fa = cfg.offset;
            GL11.glTranslated((double)fa[0], (double)fa[1], (double)fa[2]);
        }
        boolean isSelector = entity instanceof IResourceSelector;
        boolean canUseColor = cfg.useCustomColor && isSelector;
        this.renderer.preRender(entity, cfg.smoothing, cfg.doCulling, partialTick);
        if (!cfg.doCulling) {
            GL11.glDisable((int)2884);
        }
        if (cfg.smoothing) {
            GL11.glShadeModel((int)7425);
        }
        if (canUseColor) {
            GLHelper.setColor((int)((IResourceSelector)entity).getResourceState().color, (int)255);
        }
        if (pass == 0) {
            this.renderWithTexture(entity, RenderPass.NORMAL, partialTick);
        } else if (pass == 1) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            this.renderWithTexture(entity, RenderPass.TRANSPARENT, partialTick);
            GL11.glDisable((int)3042);
            GLHelper.disableLighting();
            GLHelper.setLightmapMaxBrightness();
            this.renderWithTexture(entity, RenderPass.LIGHT, partialTick);
            if (this.renderer.shouldRenderOutline(entity)) {
                this.renderWithTexture(entity, RenderPass.OUTLINE, partialTick);
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GLHelper.enableLighting();
        }
        if (canUseColor) {
            GLHelper.setColor((int)0xFFFFFF, (int)255);
        }
        if (cfg.smoothing) {
            GL11.glShadeModel((int)7424);
        }
        GL11.glEnable((int)2884);
        this.renderer.postRender(entity, cfg.smoothing, cfg.doCulling, partialTick);
        GL11.glPopMatrix();
        this.postRender();
    }

    public void preRender() {
        if (!this.useShader && this.program == 0) {
            this.initShader();
        }
        if (this.useShader) {
            ARBShaderObjects.glUseProgramObjectARB((int)this.program);
        }
    }

    public void postRender() {
        if (this.useShader) {
            ARBShaderObjects.glUseProgramObjectARB((int)0);
        }
    }

    public void renderWithTexture(Object entity, RenderPass pass, float partialTick) {
        for (int i = 0; i < this.textures.length; ++i) {
            if (this.useTexture) {
                ResourceLocation texture = null;
                if (pass == RenderPass.NORMAL) {
                    texture = this.textures[i].material.texture;
                } else if (pass == RenderPass.TRANSPARENT) {
                    if (!this.textures[i].doAlphaBlend) continue;
                    texture = this.textures[i].material.texture;
                } else if (pass == RenderPass.LIGHT || pass == RenderPass.LIGHT_FRONT || pass == RenderPass.LIGHT_BACK) {
                    if (!this.textures[i].doLighting) continue;
                    texture = this.textures[i].subTextures != null ? this.textures[i].subTextures[pass.id - 2] : this.textures[i].material.texture;
                } else {
                    texture = this.textures[i].material.texture;
                }
                NGTUtilClient.bindTexture((ResourceLocation)texture);
                if (this.useShader) {
                    ARBShaderObjects.glUniform1iARB((int)ARBShaderObjects.glGetUniformLocationARB((int)this.program, (CharSequence)"texture"), (int)0);
                    int time = (int)(System.currentTimeMillis() % 1200000L);
                    ARBShaderObjects.glUniform1iARB((int)ARBShaderObjects.glGetUniformLocationARB((int)this.program, (CharSequence)"time"), (int)time);
                }
            }
            this.renderer.currentMatId = this.textures[i].material.id;
            this.renderer.render(entity, pass, partialTick);
        }
    }

    public Material[] getMaterials(Map<String, String> map) {
        Material[] materials;
        Map matMap = this.model.getMaterials();
        if (matMap.isEmpty()) {
            materials = new Material[]{new Material(0, ModelPackManager.INSTANCE.getResource(map.get("default")))};
        } else {
            materials = new Material[matMap.size()];
            Iterator iterator = matMap.entrySet().iterator();
            int i = 0;
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String matName = map.get(entry.getKey());
                if (matName == null) {
                    matName = map.get("default");
                }
                materials[i] = new Material(((Material)entry.getValue()).id, ModelPackManager.INSTANCE.getResource(matName));
                ++i;
            }
        }
        return materials;
    }

    protected Map<String, String> getTextureMap(String[][] par1) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String[] sa : par1) {
            map.put(sa[0], sa[1]);
        }
        return map;
    }
}

