/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.render;

import jp.ngt.ngtlib.util.NGTUtilClient;
import jp.ngt.rtm.entity.train.EntityBogie;
import jp.ngt.rtm.entity.train.EntityTrainBase;
import jp.ngt.rtm.entity.vehicle.EntityVehicleBase;
import jp.ngt.rtm.modelpack.modelset.ModelSetVehicleBase;
import jp.ngt.rtm.render.EntityPartsRenderer;
import jp.ngt.rtm.render.ModelObject;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class VehiclePartsRenderer
extends EntityPartsRenderer<ModelSetVehicleBase> {
    private boolean isvehicle;

    public VehiclePartsRenderer(String ... par1) {
        super(par1);
        if (par1.length >= 1) {
            if ("true".equals(par1[0])) {
                this.isvehicle = true;
            } else if ("false".equals(par1[0])) {
                this.isvehicle = false;
            }
        }
    }

    @Override
    public void init(ModelSetVehicleBase par1, ModelObject par2) {
        super.init(par1, par2);
    }

    public float getWheelRotationR(Entity entity) {
        return this.getWheelRotation(entity, 1);
    }

    public float getWheelRotationL(Entity entity) {
        return this.getWheelRotation(entity, 0);
    }

    private float getWheelRotation(Entity entity, int id) {
        if (!this.isvehicle && entity instanceof EntityBogie) {
            EntityBogie bogie = (EntityBogie)entity;
            EntityTrainBase train = bogie.getTrain();
            if (train != null) {
                float f0 = id == 0 ? train.wheelRotationL : train.wheelRotationR;
                return f0 * (bogie.getBogieId() == 0 ? 1.0f : -1.0f);
            }
        } else if (entity instanceof EntityVehicleBase) {
            EntityVehicleBase vehicle = (EntityVehicleBase)entity;
            return id == 0 ? vehicle.wheelRotationL : vehicle.wheelRotationR;
        }
        return 0.0f;
    }

    public float getDoorMovementR(Entity entity) {
        return this.getDoorMovement(entity, 1);
    }

    public float getDoorMovementL(Entity entity) {
        return this.getDoorMovement(entity, 0);
    }

    private float getDoorMovement(Entity entity, int id) {
        if (this.isvehicle && entity instanceof EntityVehicleBase) {
            EntityVehicleBase vehicle = (EntityVehicleBase)entity;
            float f0 = id == 0 ? (float)vehicle.doorMoveL : (float)vehicle.doorMoveR;
            return f0 / 60.0f;
        }
        return 0.0f;
    }

    public float getPantographMovementFront(Entity entity) {
        return this.getPantographMovement(entity, 0);
    }

    public float getPantographMovementBack(Entity entity) {
        return this.getPantographMovement(entity, 1);
    }

    private float getPantographMovement(Entity entity, int id) {
        if (this.isvehicle && entity instanceof EntityVehicleBase) {
            EntityVehicleBase vehicle = (EntityVehicleBase)entity;
            float f0 = id == 0 ? (float)vehicle.pantograph_F : (float)vehicle.pantograph_B;
            return f0 / 40.0f;
        }
        return 0.0f;
    }

    public float getPlayerYaw(Entity entity) {
        if (this.isRidden(entity)) {
            Entity rider = (Entity)entity.func_184188_bt().get(0);
            return -rider.field_70177_z;
        }
        return 0.0f;
    }

    public boolean isRidden(Entity entity) {
        if (entity != null && entity.func_184207_aI()) {
            boolean isHostPlayer = NGTUtilClient.getMinecraft().field_71439_g == entity.func_184188_bt().get(0);
            return isHostPlayer;
        }
        return false;
    }
}

