/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.sound;

import jp.ngt.ngtlib.util.NGTUtil;
import jp.ngt.rtm.ClientProxy;
import jp.ngt.rtm.sound.MovingSoundMaker;
import jp.ngt.rtm.sound.MovingSoundTileEntity;
import net.minecraft.tileentity.TileEntity;

public class SoundPlayer {
    private SoundPlayer() {
    }

    public void playSound(TileEntity tile, String sound, boolean repeat) {
    }

    public void stopSound() {
    }

    public boolean isPlaying() {
        return false;
    }

    public static SoundPlayer create() {
        return NGTUtil.isServer() ? new SoundPlayer() : new SoundPlayerClient();
    }

    private static class SoundPlayerClient
    extends SoundPlayer {
        private MovingSoundTileEntity sound;

        private SoundPlayerClient() {
        }

        @Override
        public void playSound(TileEntity tile, String sound, boolean repeat) {
            if (this.sound != null) {
                this.stopSound();
            }
            this.sound = MovingSoundMaker.create(tile, sound, repeat);
            if (this.sound != null) {
                this.sound.setVolume(10.0f);
                ClientProxy.playSound(this.sound, 10.0f, 1.0f);
            }
        }

        @Override
        public void stopSound() {
            if (this.sound != null) {
                this.sound.stop();
                this.sound = null;
            }
        }

        @Override
        public boolean isPlaying() {
            return this.sound != null;
        }
    }
}

