/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.world;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import jp.ngt.ngtlib.block.BlockUtil;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.world.IChunkLoader;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public final class RTMChunkManager
implements ForgeChunkManager.LoadingCallback,
ForgeChunkManager.OrderedLoadingCallback,
ForgeChunkManager.PlayerOrderedLoadingCallback {
    public static final RTMChunkManager INSTANCE = new RTMChunkManager();

    private RTMChunkManager() {
    }

    @SubscribeEvent
    public void entityEnteredChunk(EntityEvent.EnteringChunk event) {
        IChunkLoader loader;
        if (event.getEntity() instanceof IChunkLoader && (loader = (IChunkLoader)event.getEntity()).isChunkLoaderEnable()) {
            loader.forceChunkLoading(event.getNewChunkX(), event.getNewChunkZ());
        }
    }

    public void getChunksAround(Set<ChunkPos> set, int xChunk, int zChunk, int radius) {
        set.clear();
        for (int xx = xChunk - radius; xx <= xChunk + radius; ++xx) {
            for (int zz = zChunk - radius; zz <= zChunk + radius; ++zz) {
                set.add(new ChunkPos(xx, zz));
            }
        }
    }

    public ForgeChunkManager.Ticket getNewTicket(World world, ForgeChunkManager.Type type) {
        return ForgeChunkManager.requestTicket((Object)RTMCore.instance, (World)world, (ForgeChunkManager.Type)type);
    }

    public List<ForgeChunkManager.Ticket> ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world, int maxTicketCount) {
        HashSet<ForgeChunkManager.Ticket> set = new HashSet<ForgeChunkManager.Ticket>();
        for (ForgeChunkManager.Ticket ticket : tickets) {
            if (ticket.getEntity() instanceof IChunkLoader) {
                set.add(ticket);
                continue;
            }
            NBTTagCompound nbt = ticket.getModData();
            if (!nbt.func_74764_b("TYPE")) continue;
            set.add(ticket);
        }
        LinkedList<ForgeChunkManager.Ticket> ticketList = new LinkedList<ForgeChunkManager.Ticket>();
        ticketList.addAll(set);
        return ticketList;
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        for (ForgeChunkManager.Ticket ticket : tickets) {
            TileEntity tile;
            IChunkLoader loader = null;
            if (ticket.getEntity() instanceof IChunkLoader) {
                Entity entity = ticket.getEntity();
                loader = (IChunkLoader)entity;
                NGTLog.debug((String)("[RTM] Chunk loader found at " + entity.field_70165_t + ", " + entity.field_70163_u + ", " + entity.field_70161_v));
            } else if (ticket.getModData().func_74764_b("TYPE") && (tile = RTMChunkManager.getTileEntity(world, ticket)) instanceof IChunkLoader) {
                loader = (IChunkLoader)tile;
                NGTLog.debug((String)("[RTM] Chunk loader found at " + tile.func_174877_v().toString()));
            }
            if (loader == null) continue;
            loader.setChunkTicket(ticket);
            loader.forceChunkLoading();
        }
    }

    public ListMultimap<String, ForgeChunkManager.Ticket> playerTicketsLoaded(ListMultimap<String, ForgeChunkManager.Ticket> tickets, World world) {
        return LinkedListMultimap.create();
    }

    public static void writeData(ForgeChunkManager.Ticket ticket, TileEntity tile) {
        NBTTagCompound nbt = ticket.getModData();
        nbt.func_74778_a("TYPE", "TileEntity");
        nbt.func_74768_a("BlockX", tile.func_174877_v().func_177958_n());
        nbt.func_74768_a("BlockY", tile.func_174877_v().func_177956_o());
        nbt.func_74768_a("BlockZ", tile.func_174877_v().func_177952_p());
    }

    public static TileEntity getTileEntity(World world, ForgeChunkManager.Ticket ticket) {
        NBTTagCompound nbt = ticket.getModData();
        int x = nbt.func_74762_e("BlockX");
        int y = nbt.func_74762_e("BlockY");
        int z = nbt.func_74762_e("BlockZ");
        return BlockUtil.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z);
    }
}

