var renderClass = "jp.ngt.rtm.render.MachinePartsRenderer";
importPackage(Packages.org.lwjgl.opengl);
importPackage(Packages.jp.ngt.rtm.render);
importPackage(Packages.jp.ngt.ngtlib.math);

var turnR;

function init(par1, par2)
{
	main = renderer.registerParts(new Parts('base', 'head', 'zvonok2', 'lightC', 'light'));
	lightL = renderer.registerParts(new Parts('lightL'));
	lightR = renderer.registerParts(new Parts('lightR'));
	bar = renderer.registerParts(new Parts('bar'));

	turnR = (renderer.getModelName().equals("Crossgate-OLD"));
}

function render(entity, pass, par3)
{
	GL11.glPushMatrix();

	var light = renderer.getLightState(entity);

	if(pass == 0)
	{
		main.render(renderer);
	
		GL11.glPushMatrix();
		var move = renderer.getMovingCount(entity) * (turnR ? 90.0 : -90.0);
		renderer.rotate(move, 'Z', 0.0, 0.805, -0.24);
		bar.render(renderer);
		GL11.glPopMatrix();

		switch(light)
		{
		case 0: lightL.render(renderer);break;
		case 1: lightR.render(renderer);break;
		}
	}
	else if(pass == 2)//発光
	{
		switch(light)
		{
		case 0: lightR.render(renderer);break;
		case 1: lightL.render(renderer);break;
		}
	}

	GL11.glPopMatrix();
}
