/*
 * Decompiled with CFR 0.152.
 */
package rzk.wirelessredstone.block;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class BlockRedstoneDevice
extends Block {
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");

    public BlockRedstoneDevice(Material material) {
        super(material);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected boolean isInputSide(IBlockState state, EnumFacing side) {
        return false;
    }

    protected boolean isOutputSide(IBlockState state, EnumFacing side) {
        return false;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        if (side != null) {
            return this.isInputSide(state, side.func_176734_d()) || this.isOutputSide(state, side.func_176734_d());
        }
        return false;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    protected int getInputPower(World world, BlockPos pos, EnumFacing side) {
        BlockPos blockpos = pos.func_177972_a(side);
        int i = world.func_175651_c(blockpos, side);
        if (i >= 15) {
            return 15;
        }
        IBlockState state = world.func_180495_p(blockpos);
        return Math.max(i, state.func_177230_c().equals(Blocks.field_150488_af) ? (Integer)state.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O) : 0);
    }

    protected boolean isGettingPowered(World world, BlockPos pos, EnumFacing ... sides) {
        if (sides == null || sides.length == 0) {
            return this.isGettingPowered(world, pos, EnumFacing.values());
        }
        for (EnumFacing side : sides) {
            if (this.getInputPower(world, pos, side) <= 0) continue;
            return true;
        }
        return false;
    }

    protected boolean shouldUpdate(World world, BlockPos pos) {
        return this.isGettingPowered(world, pos, new EnumFacing[0]) != ((Boolean)world.func_180495_p(pos).func_177229_b((IProperty)POWERED)).booleanValue();
    }

    protected int getOutputPower(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return (Boolean)state.func_177229_b((IProperty)POWERED) != false && this.isOutputSide(state, side) ? 15 : 0;
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.getOutputPower(state, world, pos, side.func_176734_d());
    }

    public int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.getOutputPower(state, world, pos, side.func_176734_d());
    }

    protected void updateNeighborsInFront(IBlockState state, World world, BlockPos pos, EnumFacing side) {
        BlockPos blockpos = pos.func_177972_a(side);
        if (ForgeEventFactory.onNeighborNotify((World)world, (BlockPos)pos, (IBlockState)world.func_180495_p(pos), EnumSet.of(side), (boolean)false).isCanceled()) {
            return;
        }
        world.func_190524_a(blockpos, (Block)this, pos);
        world.func_175695_a(blockpos, (Block)this, side.func_176734_d());
    }

    public void setPoweredState(IBlockState state, World world, BlockPos pos, boolean powered) {
        if (state.func_177230_c() instanceof BlockRedstoneDevice) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(powered)), 2);
            for (EnumFacing side : EnumFacing.values()) {
                if (!this.isOutputSide(state, side)) continue;
                this.updateNeighborsInFront(state, world, pos, side);
            }
        }
    }

    protected void onInputChanged(IBlockState state, World world, BlockPos pos, BlockPos neighbor, EnumFacing side) {
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos neighbor) {
        EnumFacing side = EnumFacing.func_176737_a((float)(neighbor.func_177958_n() - pos.func_177958_n()), (float)(neighbor.func_177956_o() - pos.func_177956_o()), (float)(neighbor.func_177952_p() - pos.func_177952_p()));
        if (this.isInputSide(state, side)) {
            this.onInputChanged(state, world, pos, neighbor, side);
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(meta == 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)POWERED) != false ? 1 : 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{POWERED});
    }
}

