/*
 * Decompiled with CFR 0.152.
 */
package rzk.wirelessredstone.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import rzk.wirelessredstone.block.BlockFrequency;
import rzk.wirelessredstone.rsnetwork.Device;
import rzk.wirelessredstone.rsnetwork.RedstoneNetwork;
import rzk.wirelessredstone.tile.TileFrequency;
import rzk.wirelessredstone.tile.TileTransmitter;

public class BlockTransmitter
extends BlockFrequency {
    @Override
    protected void onInputChanged(IBlockState state, World world, BlockPos pos, BlockPos neighbor, EnumFacing side) {
        if (!world.field_72995_K && this.shouldUpdate(world, pos)) {
            boolean powered = this.isGettingPowered(world, pos, new EnumFacing[0]);
            this.setPoweredState(state, world, pos, powered);
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof Device) {
                Device device = (Device)tile;
                RedstoneNetwork network = RedstoneNetwork.get(world);
                if (powered) {
                    network.addDevice(device);
                } else {
                    network.removeDevice(device);
                }
            }
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            RedstoneNetwork network = RedstoneNetwork.get(world);
            TileEntity tile = world.func_175625_s(pos);
            if (this.isGettingPowered(world, pos, new EnumFacing[0])) {
                this.setPoweredState(state, world, pos, true);
                if (tile instanceof TileFrequency) {
                    network.addDevice((TileFrequency)tile);
                }
            }
        }
    }

    @Override
    protected boolean isInputSide(IBlockState state, EnumFacing side) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileTransmitter();
    }
}

