/*
 * Decompiled with CFR 0.152.
 */
package rzk.wirelessredstone.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import rzk.wirelessredstone.WirelessRedstone;
import rzk.wirelessredstone.item.ItemFrequency;
import rzk.wirelessredstone.tile.TileFrequency;

public class PacketFrequency
implements IMessage {
    private short frequency;
    private boolean extended;
    private BlockPos pos;
    private EnumHand hand;
    private Type type;

    public PacketFrequency() {
    }

    private PacketFrequency(short frequency, boolean extended) {
        this.frequency = frequency;
        this.extended = extended;
    }

    private PacketFrequency(short frequency, EntityPlayer player) {
        this(frequency, false);
        NBTTagCompound nbt = player.getEntityData();
        if (nbt.func_74764_b("wirelessredstone.extended")) {
            this.extended = nbt.func_74767_n("wirelessredstone.extended");
        }
    }

    public PacketFrequency(short frequency, boolean extended, BlockPos pos) {
        this(frequency, extended);
        this.pos = pos;
        this.type = Type.BLOCK;
    }

    public PacketFrequency(short frequency, boolean extended, EnumHand hand) {
        this(frequency, extended);
        this.hand = hand;
        this.type = Type.ITEM;
    }

    public void fromBytes(ByteBuf buf) {
        this.frequency = buf.readShort();
        this.extended = buf.readBoolean();
        this.type = Type.byIndex(buf.readInt());
        switch (this.type) {
            case BLOCK: {
                this.pos = BlockPos.func_177969_a((long)buf.readLong());
                break;
            }
            case ITEM: {
                this.hand = buf.readBoolean() ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeShort((int)this.frequency);
        buf.writeBoolean(this.extended);
        buf.writeInt(this.type.getIndex());
        switch (this.type) {
            case BLOCK: {
                buf.writeLong(this.pos.func_177986_g());
                break;
            }
            case ITEM: {
                buf.writeBoolean(this.hand == EnumHand.MAIN_HAND);
            }
        }
    }

    public short getFrequency() {
        return this.frequency;
    }

    public boolean isExtended() {
        return this.extended;
    }

    public Type getType() {
        return this.type;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public EnumHand getHand() {
        return this.hand;
    }

    public static enum Type {
        BLOCK(0),
        ITEM(1);

        private int index;

        private Type(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public static Type byIndex(int index) {
            for (Type type : Type.values()) {
                if (type.index != index) continue;
                return type;
            }
            return null;
        }
    }

    public static class PacketFrequencyOpenGuiHandler
    implements IMessageHandler<PacketFrequency, IMessage> {
        public IMessage onMessage(PacketFrequency message, MessageContext ctx) {
            if (ctx.side.isClient()) {
                WirelessRedstone.proxy.openFrequencyGui(message);
            }
            return null;
        }
    }

    public static class PacketFrequencyHandler
    implements IMessageHandler<PacketFrequency, IMessage> {
        public IMessage onMessage(PacketFrequency message, MessageContext ctx) {
            if (ctx.side.isServer()) {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                WorldServer world = player.func_71121_q();
                world.func_152344_a(() -> {
                    switch (message.type) {
                        case BLOCK: {
                            TileEntity tile = world.func_175625_s(message.pos);
                            if (!(tile instanceof TileFrequency)) break;
                            ((TileFrequency)tile).setFrequency(message.frequency);
                            break;
                        }
                        case ITEM: {
                            ItemStack stack = player.func_184586_b(message.hand);
                            if (!(stack.func_77973_b() instanceof ItemFrequency)) break;
                            ItemFrequency.setFrequency(stack, message.frequency);
                        }
                    }
                    NBTTagCompound nbt = player.getEntityData();
                    nbt.func_74757_a("wirelessredstone.extended", message.extended);
                });
            }
            return null;
        }
    }
}

