/*
 * Decompiled with CFR 0.152.
 */
package rzk.wirelessredstone.rsnetwork;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.util.math.BlockPos;
import rzk.wirelessredstone.rsnetwork.Device;

public class Channel {
    private final short frequency;
    private String name;
    private final ObjectSet<BlockPos> transmitters;
    private final ObjectSet<BlockPos> receivers;
    private short remotes;

    private Channel(short frequency, String name) {
        this.frequency = frequency;
        this.name = name;
        this.transmitters = new ObjectOpenHashSet();
        this.receivers = new ObjectOpenHashSet();
        this.remotes = 0;
    }

    public static Channel create(short frequency, String name) {
        return new Channel(frequency, name);
    }

    public static Channel create(short frequency) {
        return Channel.create(frequency, null);
    }

    public void clear() {
        this.transmitters.clear();
        this.remotes = 0;
    }

    public short getFrequency() {
        return this.frequency;
    }

    public ObjectSet<BlockPos> getTransmitters() {
        return this.transmitters;
    }

    public ObjectSet<BlockPos> getReceivers() {
        return this.receivers;
    }

    public short getRemotes() {
        return this.remotes;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addDevice(Device device) {
        if (device == null) {
            return;
        }
        switch (device.getType()) {
            case TRANSMITTER: {
                this.transmitters.add((Object)((Device.Block)device).getFreqPos());
                break;
            }
            case RECEIVER: {
                this.receivers.add((Object)((Device.Block)device).getFreqPos());
                break;
            }
            case REMOTE: {
                this.remotes = (short)(this.remotes + 1);
            }
        }
    }

    public void removeDevice(Device device) {
        if (device == null) {
            return;
        }
        switch (device.getType()) {
            case TRANSMITTER: {
                this.transmitters.remove((Object)((Device.Block)device).getFreqPos());
                break;
            }
            case RECEIVER: {
                this.receivers.remove((Object)((Device.Block)device).getFreqPos());
                break;
            }
            case REMOTE: {
                if (this.remotes <= 0) break;
                this.remotes = (short)(this.remotes - 1);
            }
        }
    }

    public byte getRedstonePower() {
        return 0;
    }

    public boolean isActive() {
        return !this.transmitters.isEmpty() || this.remotes > 0;
    }

    public boolean isEmpty() {
        return this.transmitters.isEmpty() && this.receivers.isEmpty() && this.remotes <= 0 && (this.name == null || this.name.trim().isEmpty());
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList transmitterNBT = new NBTTagList();
        NBTTagList receiverNBT = new NBTTagList();
        for (BlockPos transmitter : this.transmitters) {
            transmitterNBT.func_74742_a((NBTBase)new NBTTagLong(transmitter.func_177986_g()));
        }
        for (BlockPos receiver : this.receivers) {
            receiverNBT.func_74742_a((NBTBase)new NBTTagLong(receiver.func_177986_g()));
        }
        if (this.name != null && !this.name.trim().isEmpty()) {
            nbt.func_74778_a("name", this.name);
        }
        nbt.func_74777_a("frequency", this.frequency);
        nbt.func_74782_a("transmitters", (NBTBase)transmitterNBT);
        nbt.func_74782_a("receivers", (NBTBase)receiverNBT);
        nbt.func_74777_a("remotes", this.remotes);
        return nbt;
    }

    public static Channel fromNBT(NBTTagCompound nbt) {
        if (nbt.func_82582_d() || !nbt.func_74764_b("frequency")) {
            return null;
        }
        short frequency = nbt.func_74765_d("frequency");
        Channel channel = Channel.create(frequency);
        if (nbt.func_74764_b("name")) {
            channel.name = nbt.func_74779_i("name");
        }
        if (nbt.func_150297_b("transmitters", 9)) {
            for (NBTBase transmitter : nbt.func_150295_c("transmitters", 4)) {
                channel.addDevice(Device.createTransmitter(frequency, BlockPos.func_177969_a((long)((NBTTagLong)transmitter).func_150291_c())));
            }
        }
        if (nbt.func_150297_b("receivers", 9)) {
            for (NBTBase receiver : nbt.func_150295_c("receivers", 4)) {
                channel.addDevice(Device.createReceiver(frequency, BlockPos.func_177969_a((long)((NBTTagLong)receiver).func_150291_c())));
            }
        }
        channel.remotes = nbt.func_74765_d("remotes");
        return channel;
    }
}

