/*
 * Decompiled with CFR 0.152.
 */
package rzk.wirelessredstone.util;

import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import rzk.wirelessredstone.api.IChunkLoadListener;
import rzk.wirelessredstone.item.ItemRemote;

public class WREventHandler {
    private static void powerOffRemote(World world, ItemStack stack) {
        if (!world.field_72995_K && stack.func_77973_b() instanceof ItemRemote && ItemRemote.isPowered(stack)) {
            ItemRemote.setPowered(world, stack, false);
        }
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load event) {
        Map tiles = event.getChunk().func_177434_r();
        for (TileEntity tile : tiles.values()) {
            if (!(tile instanceof IChunkLoadListener)) continue;
            ((IChunkLoadListener)tile).onChunkLoad();
        }
    }

    @SubscribeEvent
    public static void onPlayerToss(ItemTossEvent event) {
        World world = event.getPlayer().func_130014_f_();
        WREventHandler.powerOffRemote(world, event.getEntityItem().func_92059_d());
    }

    @SubscribeEvent
    public static void onPlayerDrops(PlayerDropsEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        World world = player.func_130014_f_();
        WREventHandler.powerOffRemote(world, player.func_184607_cu());
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        EntityPlayer player = event.player;
        World world = player.func_130014_f_();
        WREventHandler.powerOffRemote(world, player.func_184607_cu());
    }
}

