/*
 * Decompiled with CFR 0.152.
 */
package com.anatawa12.fixRtm.jarInJar;

import LZMA.LzmaInputStream;
import com.anatawa12.fixRtm.jarInJar.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.fml.common.discovery.ContainerType;
import net.minecraftforge.fml.common.discovery.ModCandidate;
import net.minecraftforge.fml.common.discovery.ModDiscoverer;
import net.minecraftforge.fml.relauncher.CoreModManager;
import net.minecraftforge.fml.relauncher.FMLInjectionData;

public class JarInJarModLoader {
    public static final long revision = 10000000999999999L;
    public static final String versionName = "1.0.0-SNAPSHOT-99999-99-99";
    private static final Logger LOGGER = Logger.getLogger("JarInJarModLoader-1.0.0-SNAPSHOT-99999-99-99");
    private static final Path minecraftDir = ((File)FMLInjectionData.data()[6]).toPath();
    private static final Path cacheDir = minecraftDir.resolve("jar-mods-cache").resolve("v1");
    private static final String modsBlackboardKey = "com.anatawa12.jarInJar.JarInJarModLoader.v1.mods";
    private static final String ignoredBlackboardKey = "com.anatawa12.jarInJar.JarInJarModLoader.v1.ignored";
    private static final String loaderBlackboardKey = "com.anatawa12.jarInJar.JarInJarModLoader.v1.value";

    public static void load() {
        Path jar;
        JarInJarModLoader.checkVersion();
        LOGGER.info("loading JarInJar by " + "com.anatawa12.fixRtm.jarInJar.JarInJarModLoader");
        try {
            URI uri = JarInJarModLoader.class.getProtectionDomain().getCodeSource().getLocation().toURI();
            if (uri.getScheme().equals("jar")) {
                uri = new URI(uri.toString().substring(4, uri.toString().indexOf("!/")));
            }
            jar = Paths.get(uri);
            System.out.println("jar: " + jar);
            if (!jar.toString().endsWith(".jar") && !jar.toString().endsWith(".zip")) {
                throw new IllegalStateException("jar-in-jar must contain in jar or zip file");
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        String key = null;
        try {
            key = minecraftDir.relativize(jar).toString();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (key == null || key.startsWith("..")) {
            key = JarInJarModLoader.sha256(jar.getParent().toString()) + File.separatorChar + jar.getName(jar.getNameCount() - 1);
        }
        JarInJarModLoader.getModsSet().add(key);
        Path extracted = JarInJarModLoader.cacheJar(key, jar, JarInJarModLoader.getSha256Digest());
        JarInJarModLoader.loadCoreModIfNecessary(key, jar, extracted);
    }

    private static void loadCoreModIfNecessary(String key, Path jar, Path extracted) {
        Attributes mfAttributes;
        try (ZipFile file = new ZipFile(jar.toFile());){
            ZipEntry manifestEntry = file.getEntry("core.mf");
            if (manifestEntry == null) {
                return;
            }
            try (InputStream stream = file.getInputStream(manifestEntry);){
                mfAttributes = new Manifest(stream).getMainAttributes();
            }
        }
        catch (IOException ignored) {
            return;
        }
        JarInJarModLoader.checkAndLoadCoreMod(mfAttributes, key, jar.getName(jar.getNameCount() - 1).toString(), extracted);
    }

    private static void checkAndLoadCoreMod(Attributes mfAttributes, String key, String jarName, Path extracted) {
        String fmlCorePlugin = mfAttributes.getValue("FMLCorePlugin");
        if (fmlCorePlugin == null) {
            LOGGER.debug("Not found coremod data in {}", jarName);
            return;
        }
        LaunchClassLoader classLoader = (LaunchClassLoader)JarInJarModLoader.class.getClassLoader();
        try {
            classLoader.addURL(extracted.toUri().toURL());
        }
        catch (MalformedURLException e) {
            LOGGER.error("Unable to convert file into a URL. weird", e);
            return;
        }
        if (!mfAttributes.containsKey("FMLCorePluginContainsFMLMod")) {
            LOGGER.debug("Adding {} to the list of known coremods, it will not be examined again", jarName);
            JarInJarModLoader.getIgnoredSet().add(key);
        } else {
            LOGGER.warn("Found FMLCorePluginContainsFMLMod marker in {}. This is not recommended by FML, @Mods should be in a separate jar from the coremod.", jarName);
        }
        try {
            Method loadCoreMod = CoreModManager.class.getDeclaredMethod("loadCoreMod", LaunchClassLoader.class, String.class, File.class);
            loadCoreMod.setAccessible(true);
            for (String className : fmlCorePlugin.split(";")) {
                if (className.isEmpty()) continue;
                loadCoreMod.invoke(null, classLoader, className, extracted.toFile());
            }
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw JarInJarModLoader.handleInvocationTargetException(e);
        }
    }

    private static RuntimeException handleInvocationTargetException(InvocationTargetException e) {
        Throwable t = e.getTargetException();
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new RuntimeException(t);
    }

    private static String sha256(String parent) {
        MessageDigest sha256Digest = JarInJarModLoader.getSha256Digest();
        return JarInJarModLoader.toHex(sha256Digest.digest(parent.getBytes(StandardCharsets.UTF_8)));
    }

    private static String toHex(byte[] data) {
        char[] hash = new char[data.length * 2];
        for (int i = 0; i < data.length; ++i) {
            hash[i * 2] = "0123456789abcdef".charAt(data[i] >> 4 & 0xF);
            hash[i * 2 + 1] = "0123456789abcdef".charAt(data[i] & 0xF);
        }
        return new String(hash);
    }

    public static void identifyMods(Object discoverer) {
        Set<Path> filesInDir;
        LOGGER.info("identifyMods JarInJar by " + "com.anatawa12.fixRtm.jarInJar.JarInJarModLoader");
        try {
            filesInDir = Files.walk(cacheDir, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(cacheDir::relativize).collect(Collectors.toSet());
        }
        catch (IOException e) {
            e.printStackTrace();
            filesInDir = Collections.emptySet();
        }
        Set<String> modsMap = JarInJarModLoader.getModsSet();
        LOGGER.info("mods will be loaded: " + modsMap);
        filesInDir.removeIf(path -> modsMap.contains(path.toString()));
        LOGGER.info("deleting unused files " + filesInDir);
        for (Path path2 : filesInDir) {
            cacheDir.resolve(path2).toFile().delete();
        }
        try {
            Field candidates = ModDiscoverer.class.getDeclaredField("candidates");
            candidates.setAccessible(true);
            List objects = (List)candidates.get(discoverer);
            MessageDigest sha256Digest = JarInJarModLoader.getSha256Digest();
            for (String aModInfo : modsMap) {
                File jarFileFile = cacheDir.resolve(aModInfo).toFile();
                objects.add(new ModCandidate(jarFileFile, jarFileFile, ContainerType.JAR));
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private static MessageDigest getSha256Digest() {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static Set<String> getModsSet() {
        HashSet value = (HashSet)Launch.blackboard.get(modsBlackboardKey);
        if (value == null) {
            value = new HashSet();
            Launch.blackboard.put(modsBlackboardKey, value);
        }
        return value;
    }

    private static Set<String> getIgnoredSet() {
        HashSet value = (HashSet)Launch.blackboard.get(ignoredBlackboardKey);
        if (value == null) {
            value = new HashSet();
            Launch.blackboard.put(ignoredBlackboardKey, value);
        }
        return value;
    }

    private static void checkVersion() {
        Class clazz = (Class)Launch.blackboard.get(loaderBlackboardKey);
        if (clazz == null || JarInJarModLoader.getStaticField(clazz, "revision", Long.TYPE) < 10000000999999999L) {
            Launch.blackboard.put(loaderBlackboardKey, JarInJarModLoader.class);
        }
    }

    public static <T> T getStaticField(Class<?> clazz, String fieldName, Class<T> expects) {
        try {
            Field f = clazz.getDeclaredField(fieldName);
            f.setAccessible(true);
            return (T)f.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isLatest() {
        return Launch.blackboard.get(loaderBlackboardKey) == JarInJarModLoader.class;
    }

    private static Path cacheJar(String key, Path modJar, MessageDigest sha256Digest) {
        try {
            Path extractedFile;
            block40: {
                extractedFile = cacheDir.resolve(key);
                try (ZipFile jarFile = new ZipFile(modJar.toFile());){
                    ZipEntry jarEntry = jarFile.getEntry("core.jar.lzma");
                    byte[] sha256 = new byte[]{-38, -74, -46, -17, 125, -48, -68, -79, -53, -10, -27, 106, 121, -118, 113, 4, -7, 112, -124, 103, -14, -31, 39, -47, 97, 105, -27, 51, 63, 12, 93, -30};
                    if (Files.exists(extractedFile, new LinkOption[0]) && JarInJarModLoader.checkCache(extractedFile, jarEntry, sha256, sha256Digest)) break block40;
                    sha256Digest.reset();
                    Files.createDirectories(extractedFile.getParent(), new FileAttribute[0]);
                    try (LzmaInputStream jarReading = new LzmaInputStream(jarFile.getInputStream(jarEntry));
                         OutputStream jarWriting = Files.newOutputStream(extractedFile, new OpenOption[0]);){
                        int read;
                        byte[] buf = new byte[1024];
                        while ((read = jarReading.read(buf)) != -1) {
                            sha256Digest.update(buf, 0, read);
                            jarWriting.write(buf, 0, read);
                        }
                    }
                    if (!Arrays.equals(sha256Digest.digest(), sha256)) {
                        throw new IllegalStateException("reading invalid jar-in-jar: hash mismatch: " + modJar);
                    }
                }
            }
            return extractedFile;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean checkCache(Path extracted, ZipEntry jarEntry, byte[] sha256, MessageDigest sha256Digest) throws IOException {
        if (Files.size(extracted) != jarEntry.getSize()) {
            return false;
        }
        sha256Digest.reset();
        try (InputStream extractedStream = Files.newInputStream(extracted, new OpenOption[0]);){
            int read;
            byte[] buf = new byte[1024];
            while ((read = extractedStream.read(buf)) != -1) {
                sha256Digest.update(buf, 0, read);
            }
        }
        return Arrays.equals(sha256Digest.digest(), sha256);
    }
}

