/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.client.event;

import melonslise.locks.client.util.LocksClientUtil;
import melonslise.locks.common.capability.ILockableStorage;
import melonslise.locks.common.capability.ISelection;
import melonslise.locks.common.config.LocksConfig;
import melonslise.locks.common.init.LocksCapabilities;
import melonslise.locks.common.init.LocksItems;
import melonslise.locks.common.util.AttachFace;
import melonslise.locks.common.util.Cuboid6i;
import melonslise.locks.common.util.Lockable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.culling.ClippingHelperImpl;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="locks", value={Side.CLIENT})
public final class LocksClientEvents {
    public static final ItemStack LOCK_STACK = new ItemStack(LocksItems.LOCK);

    private LocksClientEvents() {
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        for (Item item : LocksItems.ITEMS) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.END || mc.field_71441_e == null || mc.func_147113_T()) {
            return;
        }
        ((ILockableStorage)mc.field_71441_e.getCapability(LocksCapabilities.LOCKABLES, null)).get().values().forEach(lockable -> {
            if (lockable.box.loaded((World)mc.field_71441_e)) {
                lockable.tick();
            }
        });
    }

    @SubscribeEvent
    public static void onRenderWorld(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        Vec3d origin = new Vec3d(TileEntityRendererDispatcher.field_147554_b, TileEntityRendererDispatcher.field_147555_c, TileEntityRendererDispatcher.field_147552_d);
        BlockPos.MutableBlockPos mutPos = new BlockPos.MutableBlockPos();
        ILockableStorage lockables = (ILockableStorage)mc.field_71441_e.getCapability(LocksCapabilities.LOCKABLES, null);
        for (Lockable lockable : lockables.get().values()) {
            Lockable.State state = lockable.getLockState((World)mc.field_71441_e);
            if (state == null || !state.inRange(origin) || !state.inView(ClippingHelperImpl.func_78558_a(), origin)) continue;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(state.pos.field_72450_a - origin.field_72450_a), (double)(state.pos.field_72448_b - origin.field_72448_b), (double)(state.pos.field_72449_c - origin.field_72449_c));
            GlStateManager.func_179114_b((float)(-state.orient.dir.func_185119_l() - 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            if (state.orient.face != AttachFace.WALL) {
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            GlStateManager.func_179137_b((double)0.0, (double)0.1, (double)0.0);
            GlStateManager.func_179114_b((float)(MathHelper.func_76126_a((float)(LocksClientUtil.cubicBezier1d(1.0f, 1.0f, LocksClientUtil.lerp(lockable.maxShakeTicks - lockable.prevShakeTicks, lockable.maxShakeTicks - lockable.shakeTicks, event.getPartialTicks()) / (float)lockable.maxShakeTicks) * (float)lockable.maxShakeTicks / 5.0f * 3.14f)) * 10.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)0.0, (double)-0.1, (double)0.0);
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
            int light = mc.field_71441_e.func_175626_b((BlockPos)mutPos.func_189532_c(state.pos.field_72450_a, state.pos.field_72448_b, state.pos.field_72449_c), 0);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)(light % 65536), (float)(light / 65536));
            mc.field_71460_t.func_180436_i();
            mc.func_175599_af().func_181564_a(LOCK_STACK, ItemCameraTransforms.TransformType.FIXED);
            GlStateManager.func_179121_F();
        }
        ISelection select = (ISelection)mc.field_71439_g.getCapability(LocksCapabilities.LOCK_SELECTION, null);
        BlockPos pos1 = select.get();
        if (pos1 == null) {
            return;
        }
        BlockPos pos2 = mc.field_71476_x.func_178782_a() != null ? mc.field_71476_x.func_178782_a() : pos1;
        Cuboid6i box = new Cuboid6i(pos1, pos2);
        float r = 0.0f;
        float g = 0.0f;
        LocksConfig.Server cfg = LocksConfig.getServer((World)mc.field_71441_e);
        if (box.volume() > cfg.maxLockableVolume || !cfg.canLock((World)mc.field_71441_e, pos2)) {
            r = 1.0f;
        } else {
            g = 1.0f;
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_187441_d((float)1.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179097_i();
        mc.field_71460_t.func_175072_h();
        RenderGlobal.func_189694_a((double)((double)box.x1 - origin.field_72450_a), (double)((double)box.y1 - origin.field_72448_b), (double)((double)box.z1 - origin.field_72449_c), (double)((double)box.x2 - origin.field_72450_a), (double)((double)box.y2 - origin.field_72448_b), (double)((double)box.z2 - origin.field_72449_c), (float)r, (float)g, (float)0.0f, (float)0.5f);
        GlStateManager.func_179126_j();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
    }
}

