/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.client.gui;

import java.io.IOException;
import melonslise.locks.client.gui.sprite.LockPickSprite;
import melonslise.locks.client.gui.sprite.PinSprite;
import melonslise.locks.client.gui.sprite.Texture;
import melonslise.locks.common.container.LockPickingContainer;
import melonslise.locks.common.init.LocksNetworks;
import melonslise.locks.common.network.toserver.CheckPinPacket;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class LockPickingGui
extends GuiContainer {
    public static final ResourceLocation TEXTURE = new ResourceLocation("locks", "textures/gui/lockpicking.png");
    public static final ITextComponent HINT = new TextComponentTranslation("locks.gui.lockpicking.open", new Object[0]);
    protected Texture outerLock = new Texture(24, 0, 24, 120, 256, 256);
    protected Texture innerLock = new Texture(0, 0, 24, 64, 256, 256);
    protected Texture spring = new Texture(48, 48, 12, 24, 256, 256);
    protected Texture edge = new Texture(0, 0, 12, 64, 256, 256);
    protected Texture pin = new Texture(48, 0, 12, 48, 256, 256);
    protected LockPickSprite lockPick = new LockPickSprite(new Texture(60, 0, 192, 24, 256, 256));
    protected PinSprite[] pins;
    protected int length;
    protected int currentPin;

    public LockPickingGui(LockPickingContainer container) {
        super((Container)container);
        this.setLength(container.lockable.lock.getLength());
    }

    public void setLength(int length) {
        this.length = length;
        this.field_146999_f = 12 + this.length * 24 + 12;
        this.field_147000_g = 120;
        this.pins = new PinSprite[length];
        for (int a = 0; a < this.pins.length; ++a) {
            this.pins[a] = new PinSprite(this.pin);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTick) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTick);
    }

    public void func_146976_a(float partialTick, int mouseX, int mouseY) {
        int a;
        float pt = this.field_146297_k.func_184121_ak();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        int cornerX = (this.field_146294_l - this.field_146999_f) / 2;
        int cornerY = (this.field_146295_m - this.field_147000_g) / 2;
        for (a = 0; a < this.length + 1; ++a) {
            this.outerLock.draw(cornerX + a * 24, cornerY);
        }
        for (a = 0; a < this.length; ++a) {
            this.innerLock.draw(cornerX + a * 24 + 12, cornerY + 48);
        }
        this.edge.draw(cornerX + this.length * 24 + 12, cornerY + 48);
        this.lockPick.draw(cornerX - 156, cornerY + 72, pt);
        for (a = 0; a < this.pins.length; ++a) {
            this.spring.draw(cornerX + a * 24 + 18, cornerY);
            this.pins[a].draw(cornerX + a * 24 + 18, cornerY + 24, pt);
        }
        this.edge.draw(cornerX, cornerY + 48);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(LockPickingContainer.TITLE.func_150254_d(), 0, -this.field_146289_q.field_78288_b, 0xFFFFFF);
        if (((LockPickingContainer)this.field_147002_h).isOpen()) {
            this.field_146289_q.func_78276_b(HINT.func_150254_d(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(HINT.func_150254_d()) / 2, this.field_147000_g + 10, 0xFFFFFF);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.lockPick.update();
        this.boundLockPick();
        for (int a = 0; a < this.length; ++a) {
            this.pins[a].update();
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_146282_l() throws IOException {
        super.func_146282_l();
        int code = Keyboard.getEventKey();
        if (Keyboard.getEventKeyState()) {
            this.keyPressed(code);
        } else {
            this.keyReleased(code);
        }
    }

    public void keyPressed(int code) {
        if (code == this.field_146297_k.field_71474_y.field_74370_x.func_151463_i()) {
            this.lockPick.motionX = -6.0f;
        } else if (code == this.field_146297_k.field_71474_y.field_74366_z.func_151463_i()) {
            this.lockPick.motionX = 6.0f;
        } else if (code == this.field_146297_k.field_71474_y.field_74351_w.func_151463_i() && this.lockPick.rotation == 0.0f) {
            this.rotateLockPick(-6);
            this.pullPin(this.getSelectedPin());
        }
    }

    public void keyReleased(int code) {
        if (code == this.field_146297_k.field_71474_y.field_74370_x.func_151463_i() || code == this.field_146297_k.field_71474_y.field_74366_z.func_151463_i()) {
            this.lockPick.motionX = 0.0f;
        }
    }

    protected void boundLockPick() {
        this.lockPick.shiftX = MathHelper.func_76131_a((float)this.lockPick.shiftX, (float)0.0f, (float)((this.length - 1) * 24));
    }

    protected void rotateLockPick(int deg) {
        int motion = 2 * Integer.signum(deg);
        this.lockPick.rotate(motion, deg / motion);
    }

    protected int getSelectedPin() {
        return (int)((this.lockPick.shiftX + 12.0f) / 24.0f);
    }

    protected void pullPin(int pin) {
        if (this.pins[pin].isPulled) {
            return;
        }
        this.currentPin = pin;
        LocksNetworks.MAIN.sendToServer((IMessage)new CheckPinPacket((byte)pin));
    }

    public void handlePin(boolean correct, boolean reset) {
        this.pins[this.currentPin].moveY(-8.0f, 3);
        if (correct) {
            this.pins[this.currentPin].isPulled = true;
        }
        if (reset) {
            this.reset();
        }
    }

    public void reset() {
        this.lockPick.reset();
        for (PinSprite pin : this.pins) {
            pin.isPulled = false;
        }
    }
}

