/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.capability;

import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Observable;
import melonslise.locks.common.capability.ILockableStorage;
import melonslise.locks.common.config.LocksConfig;
import melonslise.locks.common.init.LocksNetworks;
import melonslise.locks.common.network.toclient.AddLockablePacket;
import melonslise.locks.common.network.toclient.RemoveLockablePacket;
import melonslise.locks.common.network.toclient.UpdateLockablePacket;
import melonslise.locks.common.util.Lockable;
import melonslise.locks.common.util.LocksUtil;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class LockableStorage
implements ILockableStorage {
    public static final ResourceLocation ID = new ResourceLocation("locks", "lockables");
    public final World world;
    protected Int2ObjectMap<Lockable> lockables = new Int2ObjectLinkedOpenHashMap();

    public LockableStorage(World world) {
        this.world = world;
    }

    @Override
    public void set(Int2ObjectMap<Lockable> lockables) {
        this.lockables = lockables;
    }

    @Override
    public Int2ObjectMap<Lockable> get() {
        return new Int2ObjectLinkedOpenHashMap(this.lockables);
    }

    @Override
    public boolean add(Lockable lockable) {
        if (lockable == null || lockable.box == null || lockable.lock == null || lockable.orient == null || lockable.box.volume() > LocksConfig.getServer((World)this.world).maxLockableVolume || this.lockables.values().stream().anyMatch(other -> other.box.intersects(lockable.box))) {
            return false;
        }
        this.lockables.put(lockable.networkID, (Object)lockable);
        lockable.addObserver(this);
        if (this.world.field_72995_K) {
            lockable.shake(10);
        } else {
            LocksNetworks.MAIN.sendToDimension((IMessage)new AddLockablePacket(lockable), this.world.field_73011_w.getDimension());
        }
        return true;
    }

    @Override
    public boolean remove(int networkID) {
        Lockable lockable = (Lockable)this.lockables.remove(networkID);
        if (lockable == this.lockables.defaultReturnValue()) {
            return false;
        }
        lockable.deleteObserver(this);
        if (this.world.field_72995_K) {
            return true;
        }
        LocksNetworks.MAIN.sendToDimension((IMessage)new RemoveLockablePacket(networkID), this.world.field_73011_w.getDimension());
        return true;
    }

    @Override
    public void update(Observable observable, Object data) {
        if (this.world.field_72995_K || !(observable instanceof Lockable)) {
            return;
        }
        Lockable lockable = (Lockable)observable;
        LocksNetworks.MAIN.sendToDimension((IMessage)new UpdateLockablePacket(lockable.networkID, lockable.lock.isLocked()), this.world.field_73011_w.getDimension());
    }

    public NBTTagList serializeNBT() {
        NBTTagList list = new NBTTagList();
        for (Lockable lockable : this.lockables.values()) {
            list.func_74742_a((NBTBase)LocksUtil.writeLockableToNBT(lockable));
        }
        return list;
    }

    public void deserializeNBT(NBTTagList list) {
        for (int a = 0; a < list.func_74745_c(); ++a) {
            Lockable lockable = LocksUtil.readLockableFromNBT(list.func_150305_b(a));
            this.lockables.put(lockable.networkID, (Object)lockable);
            lockable.addObserver(this);
        }
    }
}

