/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.container;

import melonslise.locks.client.gui.LockPickingGui;
import melonslise.locks.common.init.LocksItems;
import melonslise.locks.common.init.LocksNetworks;
import melonslise.locks.common.init.LocksSoundEvents;
import melonslise.locks.common.item.LockPickItem;
import melonslise.locks.common.network.toclient.CheckPinResultPacket;
import melonslise.locks.common.util.Lockable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LockPickingContainer
extends Container {
    public static final ITextComponent TITLE = new TextComponentTranslation("locks.gui.lockpicking.title", new Object[0]);
    public EntityPlayer player;
    public Vec3d pos;
    public Lockable lockable;
    protected int currentIndex = 0;

    public LockPickingContainer(EntityPlayer player, Lockable lockable) {
        this.player = player;
        this.lockable = lockable;
        Lockable.State state = lockable.getLockState(player.field_70170_p);
        this.pos = state == null ? lockable.box.center() : state.pos;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public boolean func_75145_c(EntityPlayer player) {
        for (ItemStack stack : player.func_184214_aD()) {
            if (stack.func_77973_b() != LocksItems.LOCK_PICK) continue;
            return true;
        }
        return false;
    }

    public void checkPin(int currentPin) {
        if (this.isOpen()) {
            return;
        }
        boolean correct = false;
        boolean reset = false;
        if (this.lockable.lock.checkPin(this.currentIndex, currentPin)) {
            ++this.currentIndex;
            correct = true;
            this.player.field_70170_p.func_184148_a(null, this.pos.field_72450_a, this.pos.field_72448_b, this.pos.field_72449_c, LocksSoundEvents.PIN_MATCH, SoundCategory.BLOCKS, 1.0f, 1.0f);
        } else if (!this.breakPick(this.player)) {
            this.player.field_70170_p.func_184148_a(null, this.pos.field_72450_a, this.pos.field_72448_b, this.pos.field_72449_c, LocksSoundEvents.PIN_FAIL, SoundCategory.BLOCKS, 1.0f, 1.0f);
        } else {
            reset = true;
            this.reset();
        }
        LocksNetworks.MAIN.sendTo((IMessage)new CheckPinResultPacket(correct, reset), (EntityPlayerMP)this.player);
    }

    @SideOnly(value=Side.CLIENT)
    public void handlePin(boolean correct, boolean reset) {
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof LockPickingGui) {
            ((LockPickingGui)screen).handlePin(correct, reset);
        }
        if (correct) {
            ++this.currentIndex;
        }
        if (reset) {
            this.reset();
        }
    }

    public boolean isOpen() {
        return this.currentIndex == this.lockable.lock.getLength();
    }

    protected void reset() {
        this.currentIndex = 0;
    }

    protected boolean breakPick(EntityPlayer player) {
        for (ItemStack stack : player.func_184214_aD()) {
            if (stack.func_77973_b() != LocksItems.LOCK_PICK) continue;
            if (player.field_70170_p.field_73012_v.nextFloat() < LockPickItem.getOrSetStrength(stack)) {
                return false;
            }
            this.player.func_70669_a(stack);
            stack.func_190918_g(1);
            return true;
        }
        return false;
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (!this.isOpen() || !this.lockable.lock.isLocked()) {
            return;
        }
        this.lockable.lock.setLocked(!this.lockable.lock.isLocked());
        this.player.field_70170_p.func_184148_a(player, this.pos.field_72450_a, this.pos.field_72448_b, this.pos.field_72449_c, LocksSoundEvents.LOCK_OPEN, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }
}

