/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.event;

import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import melonslise.locks.common.capability.ILockableStorage;
import melonslise.locks.common.capability.ISelection;
import melonslise.locks.common.config.LocksConfig;
import melonslise.locks.common.init.LocksCapabilities;
import melonslise.locks.common.init.LocksItems;
import melonslise.locks.common.init.LocksNetworks;
import melonslise.locks.common.init.LocksSoundEvents;
import melonslise.locks.common.item.LockItem;
import melonslise.locks.common.network.toclient.AddLockablePacket;
import melonslise.locks.common.network.toclient.ConfigSyncPacket;
import melonslise.locks.common.util.Cuboid6i;
import melonslise.locks.common.util.Lock;
import melonslise.locks.common.util.Lockable;
import melonslise.locks.common.util.LocksPredicates;
import melonslise.locks.common.util.LocksUtil;
import melonslise.locks.common.util.Orientation;
import melonslise.locks.common.world.LocksWorldEventListener;
import net.minecraft.block.BlockChest;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber(modid="locks")
public final class LocksEvents {
    public static final LocksWorldEventListener LISTENER = new LocksWorldEventListener();
    public static final ITextComponent LOCKED_MESSAGE = new TextComponentTranslation("locks.status.locked", new Object[0]);

    private LocksEvents() {
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        LocksItems.register(event);
    }

    @SubscribeEvent
    public static void registerSoundEvents(RegistryEvent.Register<SoundEvent> event) {
        LocksSoundEvents.register(event);
    }

    @SubscribeEvent
    public static void attachCapabilitiesToWorld(AttachCapabilitiesEvent<World> event) {
        LocksCapabilities.attachToWorld(event);
    }

    @SubscribeEvent
    public static void attachCapabilitiesToEntity(AttachCapabilitiesEvent<Entity> event) {
        LocksCapabilities.attachToEntity(event);
    }

    @SubscribeEvent
    public static void onConfigChange(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (!event.getModID().equals("locks")) {
            return;
        }
        ConfigManager.sync((String)"locks", (Config.Type)Config.Type.INSTANCE);
        LocksConfig.SERVER.init();
        LocksConfig.getServerClient().init();
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server == null) {
            return;
        }
        server.func_152344_a(() -> LocksNetworks.MAIN.sendToAll((IMessage)new ConfigSyncPacket(LocksConfig.SERVER)));
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        event.getWorld().func_72954_a((IWorldEventListener)LISTENER);
    }

    @SubscribeEvent
    public static void onChunkPopulate(PopulateChunkEvent.Post event) {
        World world = event.getWorld();
        Random rand = event.getRand();
        double ch = LocksConfig.COMMON.generationChance;
        if (ch == 0.0 || rand.nextDouble() > ch) {
            return;
        }
        ILockableStorage lockables = (ILockableStorage)world.getCapability(LocksCapabilities.LOCKABLES, null);
        for (Map.Entry entry : world.func_72964_e(event.getChunkX(), event.getChunkZ()).func_177434_r().entrySet()) {
            BlockPos pos = (BlockPos)entry.getKey();
            if (!(entry.getValue() instanceof TileEntityChest) || lockables.get().values().stream().anyMatch(lockable1 -> lockable1.box.intersects(pos))) continue;
            BlockPos adjPos = LocksUtil.getAdjacentChest((TileEntityChest)entry.getValue());
            lockables.add(new Lockable(new Cuboid6i(pos, adjPos == null ? pos : adjPos), new Lock(rand.nextInt(), LocksConfig.COMMON.randLockLen(rand), true), Orientation.fromDirection((EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)BlockChest.field_176459_a), EnumFacing.NORTH)));
        }
    }

    public static void syncLockables(World world, int dimId) {
        ((ILockableStorage)world.getCapability(LocksCapabilities.LOCKABLES, null)).get().values().forEach(lockable -> LocksNetworks.MAIN.sendToDimension((IMessage)new AddLockablePacket((Lockable)lockable), dimId));
    }

    public static void syncLockables(World world) {
        LocksEvents.syncLockables(world, world.field_73011_w.getDimension());
    }

    @SubscribeEvent
    public static void onPlayerLogIn(PlayerEvent.PlayerLoggedInEvent event) {
        LocksEvents.syncLockables(event.player.field_70170_p);
        LocksNetworks.MAIN.sendTo((IMessage)new ConfigSyncPacket(LocksConfig.SERVER), (EntityPlayerMP)event.player);
    }

    @SubscribeEvent
    public static void onPlayerChangeDim(PlayerEvent.PlayerChangedDimensionEvent event) {
        LocksEvents.syncLockables(event.player.field_70170_p, event.toDim);
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        LocksEvents.syncLockables(event.player.field_70170_p);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        ISelection select = (ISelection)event.player.getCapability(LocksCapabilities.LOCK_SELECTION, null);
        if (select.get() == null) {
            return;
        }
        for (ItemStack stack : event.player.func_184214_aD()) {
            if (!(stack.func_77973_b() instanceof LockItem)) continue;
            return;
        }
        select.set(null);
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos = event.getPos();
        World world = event.getWorld();
        EntityPlayer player = event.getEntityPlayer();
        ILockableStorage lockables = (ILockableStorage)world.getCapability(LocksCapabilities.LOCKABLES, null);
        List intersecting = lockables.get().values().stream().filter(lockable1 -> lockable1.box.intersects(pos)).collect(Collectors.toList());
        if (intersecting.isEmpty()) {
            return;
        }
        if (event.getHand() != EnumHand.MAIN_HAND) {
            event.setUseBlock(Event.Result.DENY);
            return;
        }
        if (intersecting.stream().anyMatch(LocksPredicates.LOCKED)) {
            intersecting.stream().filter(LocksPredicates.LOCKED).forEach(lockable -> lockable.shake(20));
            event.setUseBlock(Event.Result.DENY);
            world.func_184133_a(null, pos, LocksSoundEvents.LOCK_RATTLE, SoundCategory.BLOCKS, 1.0f, 1.0f);
            player.func_184609_a(EnumHand.MAIN_HAND);
            if (world.field_72995_K && LocksConfig.CLIENT.deafMode) {
                player.func_146105_b(LOCKED_MESSAGE, true);
            }
            return;
        }
        if (LocksConfig.getServer((World)world).allowRemovingLocks && player.func_70093_af() && event.getItemStack().func_190926_b()) {
            List matching = intersecting.stream().filter(LocksPredicates.NOT_LOCKED).collect(Collectors.toList());
            if (matching.isEmpty()) {
                return;
            }
            event.setUseBlock(Event.Result.DENY);
            world.func_184133_a(null, pos, SoundEvents.field_187635_cQ, SoundCategory.BLOCKS, 0.8f, 0.8f + world.field_73012_v.nextFloat() * 0.4f);
            player.func_184609_a(EnumHand.MAIN_HAND);
            if (world.field_72995_K) {
                return;
            }
            for (Lockable lockable2 : matching) {
                world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, LockItem.from(lockable2.lock)));
                lockables.remove(lockable2.networkID);
            }
        }
    }

    public static boolean canBreakLockable(EntityPlayer player, BlockPos pos) {
        ILockableStorage lockables = (ILockableStorage)player.field_70170_p.getCapability(LocksCapabilities.LOCKABLES, null);
        return !LocksConfig.getServer((World)player.field_70170_p).protectLockables || player.func_184812_l_() || !lockables.get().values().stream().anyMatch(lockable1 -> lockable1.lock.isLocked() && lockable1.box.intersects(pos));
    }

    @SubscribeEvent
    public static void onBlockBreaking(PlayerEvent.BreakSpeed event) {
        if (!LocksEvents.canBreakLockable(event.getEntityPlayer(), event.getPos())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (!LocksEvents.canBreakLockable(event.getPlayer(), event.getPos())) {
            event.setCanceled(true);
        }
    }
}

