/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.item;

import java.util.List;
import javax.annotation.Nullable;
import melonslise.locks.common.capability.ILockableStorage;
import melonslise.locks.common.capability.ISelection;
import melonslise.locks.common.config.LocksConfig;
import melonslise.locks.common.init.LocksCapabilities;
import melonslise.locks.common.init.LocksItems;
import melonslise.locks.common.init.LocksSoundEvents;
import melonslise.locks.common.item.LockingItem;
import melonslise.locks.common.util.Cuboid6i;
import melonslise.locks.common.util.Lock;
import melonslise.locks.common.util.Lockable;
import melonslise.locks.common.util.LocksUtil;
import melonslise.locks.common.util.Orientation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LockItem
extends LockingItem {
    public static final String KEY_LENGTH = "Length";

    public static ItemStack from(Lock lock) {
        ItemStack stack = new ItemStack(LocksItems.LOCK);
        NBTTagCompound nbt = LocksUtil.getTag(stack);
        nbt.func_74768_a("id", lock.id);
        nbt.func_74774_a(KEY_LENGTH, (byte)lock.getLength());
        return stack;
    }

    public static byte getOrSetLength(ItemStack stack) {
        NBTTagCompound nbt = LocksUtil.getTag(stack);
        if (!nbt.func_74764_b(KEY_LENGTH)) {
            nbt.func_74774_a(KEY_LENGTH, (byte)LocksConfig.SERVER.defaultLockLength);
        }
        return nbt.func_74771_c(KEY_LENGTH);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing face, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        ILockableStorage lockables = (ILockableStorage)world.getCapability(LocksCapabilities.LOCKABLES, null);
        ISelection select = (ISelection)player.getCapability(LocksCapabilities.LOCK_SELECTION, null);
        if (!LocksConfig.getServer(world).canLock(world, pos) || lockables.get().values().stream().anyMatch(lockable1 -> lockable1.box.intersects(pos))) {
            return EnumActionResult.PASS;
        }
        BlockPos pos1 = select.get();
        if (pos1 == null) {
            select.set(pos);
        } else {
            select.set(null);
            world.func_184133_a(player, pos, LocksSoundEvents.LOCK_CLOSE, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (world.field_72995_K) {
                return EnumActionResult.SUCCESS;
            }
            if (!lockables.add(new Lockable(new Cuboid6i(pos1, pos), Lock.from(stack), Orientation.fromDirection(face, player.func_174811_aO().func_176734_d())))) {
                return EnumActionResult.PASS;
            }
            if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> lines, ITooltipFlag flag) {
        super.func_77624_a(stack, world, lines, flag);
        int length = LocksUtil.hasKey(stack, KEY_LENGTH) ? (int)stack.func_77978_p().func_74771_c(KEY_LENGTH) : LocksConfig.getServerClient().defaultLockLength;
        TextComponentTranslation txt = new TextComponentTranslation("locks.tooltip.length", new Object[]{ItemStack.field_111284_a.format(length)});
        txt.func_150256_b().func_150238_a(TextFormatting.DARK_GREEN);
        lines.add(txt.func_150254_d());
    }
}

