/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.item;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import melonslise.locks.Locks;
import melonslise.locks.common.capability.ILockableStorage;
import melonslise.locks.common.config.LocksConfig;
import melonslise.locks.common.init.LocksCapabilities;
import melonslise.locks.common.util.Lockable;
import melonslise.locks.common.util.LocksPredicates;
import melonslise.locks.common.util.LocksUtil;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LockPickItem
extends Item {
    public static final String KEY_STRENGTH = "Strength";

    public static float getOrSetStrength(ItemStack stack) {
        NBTTagCompound nbt = LocksUtil.getTag(stack);
        if (!nbt.func_74764_b(KEY_STRENGTH)) {
            nbt.func_74776_a(KEY_STRENGTH, (float)LocksConfig.SERVER.defaultLockPickStrength);
        }
        return nbt.func_74760_g(KEY_STRENGTH);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing face, float hitX, float hitY, float hitZ) {
        ILockableStorage lockables = (ILockableStorage)world.getCapability(LocksCapabilities.LOCKABLES, null);
        List matching = lockables.get().values().stream().filter(LocksPredicates.LOCKED.and(lockable1 -> lockable1.box.intersects(pos))).collect(Collectors.toList());
        if (matching.isEmpty()) {
            return EnumActionResult.PASS;
        }
        if (world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        player.openGui((Object)Locks.instance, 1, world, ((Lockable)matching.get((int)0)).networkID, 0, 0);
        return EnumActionResult.SUCCESS;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> lines, ITooltipFlag flag) {
        super.func_77624_a(stack, world, lines, flag);
        float strength = LocksUtil.hasKey(stack, KEY_STRENGTH) ? stack.func_77978_p().func_74760_g(KEY_STRENGTH) : (float)LocksConfig.getServerClient().defaultLockPickStrength;
        TextComponentTranslation txt = new TextComponentTranslation("locks.tooltip.strength", new Object[]{ItemStack.field_111284_a.format(strength)});
        txt.func_150256_b().func_150238_a(TextFormatting.DARK_GREEN);
        lines.add(txt.func_150254_d());
    }
}

