/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.util;

import java.util.Objects;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class Cuboid6i {
    public final int x1;
    public final int y1;
    public final int z1;
    public final int x2;
    public final int y2;
    public final int z2;
    public StructureBoundingBox temp = null;

    public Cuboid6i(int x1, int y1, int z1, int x2, int y2, int z2) {
        this.x1 = Math.min(x1, x2);
        this.y1 = Math.min(y1, y2);
        this.z1 = Math.min(z1, z2);
        this.x2 = Math.max(x1, x2);
        this.y2 = Math.max(y1, y2);
        this.z2 = Math.max(z1, z2);
    }

    public Cuboid6i(BlockPos pos1, BlockPos pos2) {
        this.x1 = Math.min(pos1.func_177958_n(), pos2.func_177958_n());
        this.y1 = Math.min(pos1.func_177956_o(), pos2.func_177956_o());
        this.z1 = Math.min(pos1.func_177952_p(), pos2.func_177952_p());
        this.x2 = Math.max(pos1.func_177958_n(), pos2.func_177958_n()) + 1;
        this.y2 = Math.max(pos1.func_177956_o(), pos2.func_177956_o()) + 1;
        this.z2 = Math.max(pos1.func_177952_p(), pos2.func_177952_p()) + 1;
    }

    public Cuboid6i(BlockPos pos) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), pos.func_177958_n() + 1, pos.func_177956_o() + 1, pos.func_177952_p() + 1);
    }

    public Cuboid6i offset(int x, int y, int z) {
        return new Cuboid6i(this.x1 + x, this.y1 + y, this.z1 + z, this.x2 + x, this.y2 + y, this.z2 + z);
    }

    public Cuboid6i offset(BlockPos pos) {
        return this.offset(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public boolean intersects(Cuboid6i other) {
        return this.intersects(other.x1, other.y1, other.z1, other.x2, other.y2, other.z2);
    }

    public boolean intersects(BlockPos pos) {
        return this.intersects(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), pos.func_177958_n() + 1, pos.func_177956_o() + 1, pos.func_177952_p() + 1);
    }

    public boolean intersects(int x1, int y1, int z1, int x2, int y2, int z2) {
        return this.x1 < x2 && this.x2 > x1 && this.y1 < y2 && this.y2 > y1 && this.z1 < z2 && this.z2 > z1;
    }

    public boolean contains(Cuboid6i other) {
        return this.contains(other.x1, other.y1, other.z1) && this.contains(other.x2, other.y2, other.z2);
    }

    public boolean contains(int x, int y, int z) {
        return x >= this.x1 && x < this.x2 && y >= this.y1 && y < this.y2 && z >= this.z1 && z < this.z2;
    }

    public Cuboid6i intersection(Cuboid6i other) {
        return new Cuboid6i(Math.max(this.x1, other.x1), Math.max(this.y1, other.y1), Math.max(this.z1, other.z1), Math.min(this.x2, other.x2), Math.min(this.y2, other.y2), Math.min(this.z2, other.z2));
    }

    public Cuboid6i union(Cuboid6i other) {
        return new Cuboid6i(Math.min(this.x1, other.x1), Math.min(this.y1, other.y1), Math.min(this.z1, other.z1), Math.max(this.x2, other.x2), Math.max(this.y2, other.y2), Math.max(this.z2, other.z2));
    }

    public int volume() {
        return (this.x2 - this.x1) * (this.y2 - this.y1) * (this.z2 - this.z1);
    }

    public Vec3d center() {
        return new Vec3d((double)(this.x2 + this.x1) / 2.0, (double)(this.y2 + this.y1) / 2.0, (double)(this.z2 + this.z1) / 2.0);
    }

    public Iterable<BlockPos.MutableBlockPos> getContainedBlockPositions() {
        return BlockPos.func_191531_b((int)this.x1, (int)this.y1, (int)this.z1, (int)(this.x2 - 1), (int)(this.y2 - 1), (int)(this.z2 - 1));
    }

    public Vec3d getSideCenter(EnumFacing side) {
        switch (side) {
            case DOWN: {
                return new Vec3d((double)(this.x1 + this.x2) / 2.0, (double)this.y1, (double)(this.z1 + this.z2) / 2.0);
            }
            case UP: {
                return new Vec3d((double)(this.x1 + this.x2) / 2.0, (double)this.y2, (double)(this.z1 + this.z2) / 2.0);
            }
            case NORTH: {
                return new Vec3d((double)(this.x1 + this.x2) / 2.0, (double)(this.y1 + this.y2) / 2.0, (double)this.z1);
            }
            case SOUTH: {
                return new Vec3d((double)(this.x1 + this.x2) / 2.0, (double)(this.y1 + this.y2) / 2.0, (double)this.z2);
            }
            case WEST: {
                return new Vec3d((double)this.x1, (double)(this.y1 + this.y2) / 2.0, (double)(this.z1 + this.z2) / 2.0);
            }
            case EAST: {
                return new Vec3d((double)this.x2, (double)(this.y1 + this.y2) / 2.0, (double)(this.z1 + this.z2) / 2.0);
            }
        }
        return null;
    }

    public AxisAlignedBB toAABB() {
        return new AxisAlignedBB((double)this.x1, (double)this.y1, (double)this.z1, (double)this.x2, (double)this.y2, (double)this.z2);
    }

    public boolean loaded(World world) {
        if (this.temp == null) {
            this.temp = new StructureBoundingBox(this.x1, this.y1, this.z1, this.x2, this.y2, this.z2);
        }
        return world.func_175711_a(this.temp);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Cuboid6i)) {
            return false;
        }
        Cuboid6i box = (Cuboid6i)object;
        return this.x1 == box.x1 && this.x2 == box.x2 && this.y1 == box.y1 && this.y2 == box.y2 && this.z1 == box.z1 && this.z2 == box.z2;
    }

    public int hashCode() {
        return Objects.hash(this.x1, this.y1, this.z1, this.x2, this.y2, this.z2);
    }

    public String toString() {
        return "Box{" + this.x1 + ", " + this.y1 + ", " + this.z1 + ", " + this.x2 + ", " + this.y2 + ", " + this.z2 + "}";
    }
}

