/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.util;

import io.netty.buffer.ByteBuf;
import io.netty.util.internal.ThreadLocalRandom;
import java.util.Random;
import melonslise.locks.common.util.AttachFace;
import melonslise.locks.common.util.Cuboid6i;
import melonslise.locks.common.util.Lock;
import melonslise.locks.common.util.Lockable;
import melonslise.locks.common.util.Orientation;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public final class LocksUtil {
    public static final String KEY_X1 = "x1";
    public static final String KEY_Y1 = "y1";
    public static final String KEY_Z1 = "z1";
    public static final String KEY_X2 = "x2";
    public static final String KEY_Y2 = "y2";
    public static final String KEY_Z2 = "z2";
    public static final String KEY_ID = "id";
    public static final String KEY_LENGTH = "length";
    public static final String KEY_OLD_CODE = "code";
    public static final String KEY_OLD_COMBINATION = "combination";
    public static final String KEY_LOCKED = "locked";
    public static final String KEY_BOX = "box";
    public static final String KEY_LOCK = "lock";
    public static final String KEY_ORIENTATION = "orientation";
    public static final String KEY_OLD_SIDE = "side";

    private LocksUtil() {
    }

    public static void shuffle(byte[] array, Random rng) {
        for (int a = array.length - 1; a > 0; --a) {
            int index = rng.nextInt(a + 1);
            byte temp = array[index];
            array[index] = array[a];
            array[a] = temp;
        }
    }

    public static BlockPos getAdjacentChest(TileEntityChest te) {
        BlockPos pos = null;
        te.func_145979_i();
        if (te.field_145991_k != null) {
            pos = te.field_145991_k.func_174877_v();
        } else if (te.field_145990_j != null) {
            pos = te.field_145990_j.func_174877_v();
        } else if (te.field_145992_i != null) {
            pos = te.field_145992_i.func_174877_v();
        } else if (te.field_145988_l != null) {
            pos = te.field_145988_l.func_174877_v();
        }
        return pos;
    }

    public static AttachFace faceFromDir(EnumFacing dir) {
        return dir == EnumFacing.UP ? AttachFace.CEILING : (dir == EnumFacing.DOWN ? AttachFace.FLOOR : AttachFace.WALL);
    }

    public static NBTTagCompound getTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    public static boolean hasKey(ItemStack stack, String key) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(key);
    }

    public static Cuboid6i readBoxFromNBT(NBTTagCompound nbt) {
        return new Cuboid6i(nbt.func_74762_e(KEY_X1), nbt.func_74762_e(KEY_Y1), nbt.func_74762_e(KEY_Z1), nbt.func_74762_e(KEY_X2), nbt.func_74762_e(KEY_Y2), nbt.func_74762_e(KEY_Z2));
    }

    public static NBTTagCompound writeBoxToNBT(Cuboid6i box) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a(KEY_X1, box.x1);
        nbt.func_74768_a(KEY_Y1, box.y1);
        nbt.func_74768_a(KEY_Z1, box.z1);
        nbt.func_74768_a(KEY_X2, box.x2);
        nbt.func_74768_a(KEY_Y2, box.y2);
        nbt.func_74768_a(KEY_Z2, box.z2);
        return nbt;
    }

    public static Lock readLockFromNBT(NBTTagCompound nbt) {
        int id;
        int n = id = nbt.func_186855_b(KEY_ID) ? ThreadLocalRandom.current().nextInt() : nbt.func_74762_e(KEY_ID);
        int length = nbt.func_74764_b(KEY_LENGTH) ? nbt.func_74771_c(KEY_LENGTH) : (nbt.func_74764_b(KEY_OLD_CODE) ? nbt.func_74770_j(KEY_OLD_CODE).length : nbt.func_74770_j(KEY_OLD_COMBINATION).length);
        return new Lock(id, length, nbt.func_74767_n(KEY_LOCKED));
    }

    public static NBTTagCompound writeLockToNBT(Lock lock) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a(KEY_ID, lock.id);
        nbt.func_74774_a(KEY_LENGTH, (byte)lock.combination.length);
        nbt.func_74757_a(KEY_LOCKED, lock.locked);
        return nbt;
    }

    public static Lockable readLockableFromNBT(NBTTagCompound nbt) {
        Orientation orient = nbt.func_74764_b(KEY_ORIENTATION) ? Orientation.values()[nbt.func_74771_c(KEY_ORIENTATION)] : Orientation.fromDirection(EnumFacing.func_82600_a((int)nbt.func_74771_c(KEY_OLD_SIDE)), EnumFacing.NORTH);
        return new Lockable(LocksUtil.readBoxFromNBT(nbt.func_74775_l(KEY_BOX)), LocksUtil.readLockFromNBT(nbt.func_74775_l(KEY_LOCK)), orient);
    }

    public static NBTTagCompound writeLockableToNBT(Lockable lockable) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a(KEY_BOX, (NBTBase)LocksUtil.writeBoxToNBT(lockable.box));
        nbt.func_74782_a(KEY_LOCK, (NBTBase)LocksUtil.writeLockToNBT(lockable.lock));
        nbt.func_74774_a(KEY_ORIENTATION, (byte)lockable.orient.ordinal());
        return nbt;
    }

    public static <T extends Enum<T>> T readEnumFromBuffer(ByteBuf buffer, Class<T> c) {
        return (T)((Enum[])c.getEnumConstants())[buffer.readByte()];
    }

    public static void writeEnumToBuffer(ByteBuf buffer, Enum<?> value) {
        buffer.writeByte((int)((byte)value.ordinal()));
    }

    public static Cuboid6i readBoxFromBuffer(ByteBuf buf) {
        return new Cuboid6i(buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt());
    }

    public static void writeBoxToBuffer(ByteBuf buf, Cuboid6i box) {
        buf.writeInt(box.x1);
        buf.writeInt(box.y1);
        buf.writeInt(box.z1);
        buf.writeInt(box.x2);
        buf.writeInt(box.y2);
        buf.writeInt(box.z2);
    }

    public static Lock readLockFromBuffer(ByteBuf buf) {
        return new Lock(buf.readInt(), buf.readByte(), buf.readBoolean());
    }

    public static void writeLockToBuffer(ByteBuf buf, Lock lock) {
        buf.writeInt(lock.id);
        buf.writeByte(lock.getLength());
        buf.writeBoolean(lock.isLocked());
    }

    public static Lockable readLockableFromBuffer(ByteBuf buf) {
        return new Lockable(LocksUtil.readBoxFromBuffer(buf), LocksUtil.readLockFromBuffer(buf), LocksUtil.readEnumFromBuffer(buf, Orientation.class), buf.readInt());
    }

    public static void writeLockableToBuffer(ByteBuf buf, Lockable lockable) {
        LocksUtil.writeBoxToBuffer(buf, lockable.box);
        LocksUtil.writeLockToBuffer(buf, lockable.lock);
        LocksUtil.writeEnumToBuffer(buf, lockable.orient);
        buf.writeInt(lockable.networkID);
    }

    public static AxisAlignedBB rotateY(AxisAlignedBB bb) {
        return new AxisAlignedBB(bb.field_72339_c, bb.field_72338_b, bb.field_72340_a, bb.field_72334_f, bb.field_72337_e, bb.field_72336_d);
    }

    public static AxisAlignedBB rotateX(AxisAlignedBB bb) {
        return new AxisAlignedBB(bb.field_72340_a, bb.field_72339_c, bb.field_72338_b, bb.field_72336_d, bb.field_72334_f, bb.field_72337_e);
    }

    public static boolean intersectsInclusive(AxisAlignedBB box1, AxisAlignedBB box2) {
        return box1.field_72340_a <= box2.field_72336_d && box1.field_72336_d >= box2.field_72340_a && box1.field_72338_b <= box2.field_72337_e && box1.field_72337_e >= box2.field_72338_b && box1.field_72339_c <= box2.field_72334_f && box1.field_72334_f >= box2.field_72339_c;
    }

    public static Vec3d getAABBSideCenter(AxisAlignedBB box, EnumFacing side) {
        switch (side) {
            case DOWN: {
                return new Vec3d((box.field_72340_a + box.field_72336_d) / 2.0, box.field_72338_b, (box.field_72339_c + box.field_72334_f) / 2.0);
            }
            case UP: {
                return new Vec3d((box.field_72340_a + box.field_72336_d) / 2.0, box.field_72337_e, (box.field_72339_c + box.field_72334_f) / 2.0);
            }
            case NORTH: {
                return new Vec3d((box.field_72340_a + box.field_72336_d) / 2.0, (box.field_72338_b + box.field_72337_e) / 2.0, box.field_72339_c);
            }
            case SOUTH: {
                return new Vec3d((box.field_72340_a + box.field_72336_d) / 2.0, (box.field_72338_b + box.field_72337_e) / 2.0, box.field_72334_f);
            }
            case WEST: {
                return new Vec3d(box.field_72340_a, (box.field_72338_b + box.field_72337_e) / 2.0, (box.field_72339_c + box.field_72334_f) / 2.0);
            }
            case EAST: {
                return new Vec3d(box.field_72336_d, (box.field_72338_b + box.field_72337_e) / 2.0, (box.field_72339_c + box.field_72334_f) / 2.0);
            }
        }
        return null;
    }
}

