/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import wile.rsgauges.blocks.BlockSwitch;
import wile.rsgauges.blocks.RsBlock;
import wile.rsgauges.detail.ModAuxiliaries;
import wile.rsgauges.detail.ModConfig;
import wile.rsgauges.detail.ModResources;
import wile.rsgauges.items.ItemSwitchLinkPearl;

public class BlockAutoSwitch
extends BlockSwitch {
    public BlockAutoSwitch(String registryName, AxisAlignedBB unrotatedBB, long config, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound, @Nullable Material material) {
        super(registryName, unrotatedBB, null, config, powerOnSound, powerOffSound, material);
    }

    public BlockAutoSwitch(String registryName, AxisAlignedBB unrotatedBB, long config, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound) {
        super(registryName, unrotatedBB, null, config, powerOnSound, powerOffSound, null);
    }

    @Override
    public boolean onLinkRequest(ItemSwitchLinkPearl.SwitchLink link, long req, World world, BlockPos pos, @Nullable EntityPlayer player) {
        if (world == null || (this.config & 0x200000000000000L) == 0L || world.field_72995_K) {
            return false;
        }
        if ((this.config & 0x200000000L) == 0L) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state == null || !(state.func_177230_c() instanceof BlockAutoSwitch)) {
            return false;
        }
        TileEntityAutoSwitch te = this.getTe((IBlockAccess)world, pos);
        if (te == null || !te.check_link_request(link)) {
            return false;
        }
        te.updateSwitchState(state, this, (Boolean)state.func_177229_b((IProperty)POWERED) == false, 0);
        return true;
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        if ((this.config & 0xC00000000L) != 0L) {
            return new TileEntityDetectorSwitch();
        }
        if ((this.config & 0x7100000000L) != 0L) {
            return new TileEntityEnvironmentalSensorSwitch();
        }
        if ((this.config & 0x200000000L) != 0L) {
            return new TileEntityIntervalTimerSwitch();
        }
        return new TileEntityAutoSwitch();
    }

    @Override
    public TileEntityAutoSwitch getTe(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof TileEntityAutoSwitch)) {
            return null;
        }
        return (TileEntityAutoSwitch)te;
    }

    public static class TileEntityIntervalTimerSwitch
    extends TileEntityAutoSwitch
    implements ITickable {
        private static final int ramp_max = 5;
        private static final int t_max = 12000;
        private static final int t_min = 5;
        private int p_set_ = 15;
        private int t_on_ = 20;
        private int t_off_ = 20;
        private int ramp_ = 0;
        private int update_timer_ = 0;
        private int p_ = 0;
        private boolean s_ = false;

        public TileEntityIntervalTimerSwitch() {
            this.p_set(15);
            this.t_on(20);
            this.t_off(20);
            this.ramp(0);
        }

        public void restart() {
            this.update_timer_ = 0;
            this.p_ = 0;
            this.s_ = false;
        }

        public int p_set() {
            return this.p_set_;
        }

        public int t_on() {
            return this.t_on_;
        }

        public int t_off() {
            return this.t_off_;
        }

        public int ramp() {
            return this.ramp_;
        }

        public void p_set(int v) {
            this.p_set_ = v < 1 ? 1 : (v > 15 ? 15 : v);
        }

        public void t_on(int v) {
            this.t_on_ = v < 0 ? 0 : (v > 12000 ? 12000 : v);
        }

        public void t_off(int v) {
            this.t_off_ = v < 0 ? 0 : (v > 12000 ? 12000 : v);
        }

        public void ramp(int v) {
            this.ramp_ = v < 0 ? 0 : (v > 5 ? 5 : v);
        }

        protected void func_190201_b(World world) {
            super.func_190201_b(world);
            this.p_set(15);
            this.t_on(20);
            this.t_off(20);
            this.ramp(0);
        }

        @Override
        public void writeNbt(NBTTagCompound nbt, boolean updatePacket) {
            super.writeNbt(nbt, updatePacket);
            nbt.func_74768_a("pset", this.p_set());
            nbt.func_74768_a("toff", this.t_off());
            nbt.func_74768_a("ton", this.t_on());
            nbt.func_74768_a("ramp", this.ramp());
        }

        @Override
        public void readNbt(NBTTagCompound nbt, boolean updatePacket) {
            super.readNbt(nbt, updatePacket);
            this.p_set(nbt.func_74762_e("pset"));
            this.t_off(nbt.func_74762_e("toff"));
            this.t_on(nbt.func_74762_e("ton"));
            this.ramp(nbt.func_74762_e("ramp"));
        }

        private int next_higher_interval_setting(int ticks) {
            ticks = ticks < 100 ? (ticks += 5) : (ticks < 200 ? (ticks += 10) : (ticks < 400 ? (ticks += 20) : (ticks < 600 ? (ticks += 40) : (ticks < 800 ? (ticks += 100) : (ticks < 2400 ? (ticks += 200) : (ticks += 600))))));
            return ticks > 12000 ? 12000 : ticks;
        }

        private int next_lower_interval_setting(int ticks) {
            ticks = ticks < 100 ? (ticks -= 5) : (ticks < 200 ? (ticks -= 10) : (ticks < 400 ? (ticks -= 20) : (ticks < 600 ? (ticks -= 40) : (ticks < 800 ? (ticks -= 100) : (ticks < 2400 ? (ticks -= 200) : (ticks -= 600))))));
            return ticks < 5 ? 5 : ticks;
        }

        @Override
        public boolean activation_config(IBlockState state, @Nullable EntityPlayer player, double x, double y) {
            boolean selected;
            int direction;
            if (state == null) {
                return false;
            }
            int n = y >= 13.0 ? 1 : (direction = y <= 2.0 ? -1 : 0);
            int field = x >= 2.0 && x <= 3.95 ? 1 : (x >= 4.25 && x <= 7.0 ? 2 : (x >= 8.0 && x <= 10.0 ? 3 : (x >= 11.0 && x <= 13.0 ? 4 : 0)));
            boolean bl = selected = direction != 0 && field != 0;
            if (selected) {
                switch (field) {
                    case 1: {
                        this.t_on(direction > 0 ? this.next_higher_interval_setting(this.t_on()) : this.next_lower_interval_setting(this.t_on()));
                        break;
                    }
                    case 2: {
                        this.t_off(direction > 0 ? this.next_higher_interval_setting(this.t_off()) : this.next_lower_interval_setting(this.t_off()));
                        break;
                    }
                    case 3: {
                        this.ramp(this.ramp() + direction);
                        break;
                    }
                    case 4: {
                        this.p_set((this.p_set() <= 0 ? 15 : this.p_set()) + direction);
                    }
                }
                this.func_70296_d();
            }
            boolean switch_state = false;
            try {
                switch_state = (Boolean)state.func_177229_b((IProperty)BlockSwitch.POWERED);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!selected) {
                switch_state = !switch_state;
            }
            this.updateSwitchState(state, (BlockAutoSwitch)state.func_177230_c(), switch_state, 0);
            TextComponentString separator = new TextComponentString(" | ");
            separator.func_150256_b().func_150238_a(TextFormatting.GRAY);
            ArrayList<Object> tr = new ArrayList<Object>();
            tr.add(ModAuxiliaries.localizable("switchconfig.intervaltimer.t_on", TextFormatting.BLUE, ModAuxiliaries.ticksToSecondsString(this.t_on())));
            tr.add(separator.func_150259_f().func_150257_a((ITextComponent)ModAuxiliaries.localizable("switchconfig.intervaltimer.t_off", TextFormatting.YELLOW, ModAuxiliaries.ticksToSecondsString(this.t_off()))));
            tr.add(separator.func_150259_f().func_150257_a((ITextComponent)ModAuxiliaries.localizable("switchconfig.intervaltimer.output_power", TextFormatting.RED, this.p_set())));
            if (this.ramp() > 0) {
                tr.add(separator.func_150259_f().func_150257_a((ITextComponent)ModAuxiliaries.localizable("switchconfig.intervaltimer.ramp", TextFormatting.DARK_GREEN, this.ramp())));
            }
            if (!switch_state) {
                tr.add(separator.func_150259_f().func_150257_a((ITextComponent)ModAuxiliaries.localizable("switchconfig.intervaltimer.standby", TextFormatting.AQUA, new Object[0])));
            }
            while (tr.size() < 5) {
                tr.add(new TextComponentString(""));
            }
            ModAuxiliaries.playerStatusMessage(player, ModAuxiliaries.localizable("switchconfig.intervaltimer", TextFormatting.RESET, tr.toArray()));
            return selected;
        }

        @Override
        public int power(IBlockState state, boolean strong) {
            return this.nooutput() || (Boolean)state.func_177229_b((IProperty)BlockSwitch.POWERED) == false || strong && this.weak() ? 0 : this.on_power();
        }

        public void func_73660_a() {
            if (ModConfig.zmisc.without_timer_switch_update) {
                return;
            }
            if (!this.func_145830_o() || this.func_145831_w().field_72995_K || --this.update_timer_ > 0) {
                return;
            }
            int p = this.p_;
            if (this.t_on() <= 0 || this.t_off() <= 0 || this.p_set() <= 0) {
                this.p_ = 0;
                this.update_timer_ = 20;
            } else if (!this.s_) {
                this.update_timer_ = this.t_on();
                if (this.ramp() <= 0 || (this.p_ += this.ramp()) >= this.p_set()) {
                    this.p_ = this.p_set();
                    this.s_ = true;
                } else {
                    this.update_timer_ = 5;
                }
            } else {
                this.update_timer_ = this.t_off();
                if (this.ramp() <= 0 || (this.p_ -= this.ramp()) <= 0) {
                    this.p_ = 0;
                    this.s_ = false;
                } else {
                    this.update_timer_ = 5;
                }
            }
            if (p != this.p_) {
                this.on_power(this.inverted() ? 15 - this.p_ : this.p_);
                IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
                if (state == null || !(state.func_177230_c() instanceof BlockAutoSwitch) || !((Boolean)state.func_177229_b((IProperty)BlockSwitch.POWERED)).booleanValue()) {
                    this.update_timer_ = 200 + (int)(Math.random() * 10.0);
                    this.on_power(this.inverted() ? 15 : 0);
                }
                this.field_145850_b.func_175685_c(this.field_174879_c, state.func_177230_c(), false);
                this.field_145850_b.func_175685_c(this.field_174879_c.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)RsBlock.FACING)).func_176734_d()), state.func_177230_c(), false);
            }
        }
    }

    public static class TileEntityEnvironmentalSensorSwitch
    extends TileEntityAutoSwitch
    implements ITickable {
        protected static final int debounce_max = 10;
        protected int update_interval_ = 10;
        protected double threshold0_on_ = 0.0;
        protected double threshold0_off_ = 0.0;
        protected int debounce_ = 0;
        protected int update_timer_ = 0;
        protected int debounce_counter_ = 0;

        public double threshold0_on() {
            return this.threshold0_on_;
        }

        public double threshold0_off() {
            return this.threshold0_off_;
        }

        public int debounce() {
            return this.debounce_;
        }

        public void threshold0_on(double v) {
            this.threshold0_on_ = v < 0.0 ? 0.0 : (v > 15.0 ? 15.0 : v);
        }

        public void threshold0_off(double v) {
            this.threshold0_off_ = v < 0.0 ? 0.0 : (v > 15.0 ? 15.0 : v);
        }

        public void debounce(int v) {
            this.debounce_ = v < 0 ? 0 : (v > 10 ? 10 : v);
        }

        @Override
        public void writeNbt(NBTTagCompound nbt, boolean updatePacket) {
            super.writeNbt(nbt, updatePacket);
            nbt.func_74780_a("threshold0_on", this.threshold0_on());
            nbt.func_74780_a("threshold0_off", this.threshold0_off());
            nbt.func_74768_a("debounce", this.debounce());
        }

        @Override
        public void readNbt(NBTTagCompound nbt, boolean updatePacket) {
            super.readNbt(nbt, updatePacket);
            this.threshold0_on(nbt.func_74769_h("threshold0_on"));
            this.threshold0_off(nbt.func_74769_h("threshold0_off"));
            this.debounce(nbt.func_74762_e("debounce"));
        }

        @Override
        public boolean activation_config(IBlockState state, @Nullable EntityPlayer player, double x, double y) {
            int field;
            int direction;
            if (state == null) {
                return false;
            }
            BlockSwitch block = (BlockSwitch)state.func_177230_c();
            int n = y >= 13.0 ? 1 : (direction = y <= 2.0 ? -1 : 0);
            int n2 = x >= 2.0 && x <= 3.95 ? 1 : (x >= 4.25 && x <= 7.0 ? 2 : (x >= 8.0 && x <= 10.0 ? 3 : (field = x >= 11.0 && x <= 13.0 ? 4 : 0)));
            if (direction == 0 || field == 0) {
                return false;
            }
            if ((block.config & 0x1000000000L) != 0L) {
                switch (field) {
                    case 1: {
                        this.threshold0_on(this.threshold0_on() + (double)direction);
                        if (!(this.threshold0_off() > this.threshold0_on())) break;
                        this.threshold0_off(this.threshold0_on());
                        break;
                    }
                    case 2: {
                        this.threshold0_off(this.threshold0_off() + (double)direction);
                        if (!(this.threshold0_on() < this.threshold0_off())) break;
                        this.threshold0_on(this.threshold0_off());
                        break;
                    }
                    case 3: {
                        this.debounce(this.debounce() + direction);
                        break;
                    }
                    case 4: {
                        this.on_power(this.on_power() + direction);
                    }
                }
                if (this.threshold0_on() < 1.0) {
                    this.threshold0_on(1.0);
                }
                if (this.on_power() < 1) {
                    this.on_power(1);
                }
                ArrayList<Object> tr = new ArrayList<Object>();
                TextComponentTranslation trunit = ModAuxiliaries.localizable("switchconfig.lightsensor.lightunit", null, new Object[0]);
                TextComponentString separator = new TextComponentString(" | ");
                separator.func_150256_b().func_150238_a(TextFormatting.GRAY);
                tr.add(ModAuxiliaries.localizable("switchconfig.lightsensor.threshold_on", TextFormatting.BLUE, (int)this.threshold0_on(), trunit));
                tr.add(separator.func_150259_f().func_150257_a((ITextComponent)ModAuxiliaries.localizable("switchconfig.lightsensor.threshold_off", TextFormatting.YELLOW, (int)this.threshold0_off(), trunit)));
                tr.add(separator.func_150259_f().func_150257_a((ITextComponent)ModAuxiliaries.localizable("switchconfig.lightsensor.output_power", TextFormatting.RED, this.on_power())));
                if (this.debounce() > 0) {
                    tr.add(separator.func_150259_f().func_150257_a((ITextComponent)ModAuxiliaries.localizable("switchconfig.lightsensor.debounce", TextFormatting.DARK_GREEN, this.debounce())));
                } else {
                    tr.add(new TextComponentString(""));
                }
                ModAuxiliaries.playerStatusMessage(player, ModAuxiliaries.localizable("switchconfig.lightsensor", TextFormatting.RESET, tr.toArray()));
            } else if ((block.config & 0x100000000L) != 0L) {
                double time_scaling = 0.3125;
                switch (field) {
                    case 1: {
                        double v = this.threshold0_on() + 0.3125 * (double)direction;
                        if (v < 0.0) {
                            v += 15.0;
                        } else if (v > 15.0) {
                            v = 0.0;
                        }
                        this.threshold0_on(v);
                        break;
                    }
                    case 2: {
                        double v = this.threshold0_off() + 0.3125 * (double)direction;
                        if (v < 0.0) {
                            v += 15.0;
                        } else if (v > 15.0) {
                            v = 0.0;
                        }
                        this.threshold0_off(v);
                        break;
                    }
                    case 3: {
                        this.debounce(this.debounce() + direction);
                        break;
                    }
                    case 4: {
                        this.on_power(this.on_power() + direction);
                    }
                }
                if (this.on_power() < 1) {
                    this.on_power(1);
                }
                TextComponentString separator = new TextComponentString(" | ");
                separator.func_150256_b().func_150238_a(TextFormatting.GRAY);
                ArrayList<Object> tr = new ArrayList<Object>();
                tr.add(ModAuxiliaries.localizable("switchconfig.daytimerclock.daytime_on", TextFormatting.BLUE, ModAuxiliaries.daytimeToString((long)(this.threshold0_on() * 24000.0 / 15.0))));
                tr.add(separator.func_150259_f().func_150257_a((ITextComponent)ModAuxiliaries.localizable("switchconfig.daytimerclock.daytime_off", TextFormatting.YELLOW, ModAuxiliaries.daytimeToString((long)(this.threshold0_off() * 24000.0 / 15.0)))));
                tr.add(separator.func_150259_f().func_150257_a((ITextComponent)ModAuxiliaries.localizable("switchconfig.daytimerclock.output_power", TextFormatting.RED, this.on_power())));
                if (this.debounce() > 0) {
                    tr.add(separator.func_150259_f().func_150257_a((ITextComponent)ModAuxiliaries.localizable("switchconfig.daytimerclock.random", TextFormatting.DARK_GREEN, this.debounce())));
                } else {
                    tr.add(new TextComponentString(""));
                }
                tr.add(separator.func_150259_f().func_150257_a((ITextComponent)ModAuxiliaries.localizable("switchconfig.daytimerclock.output_power", TextFormatting.RED, this.on_power())));
                ModAuxiliaries.playerStatusMessage(player, ModAuxiliaries.localizable("switchconfig.daytimerclock", TextFormatting.RESET, tr.toArray()));
            } else if ((block.config & 0x6000000000L) != 0L) {
                switch (field) {
                    case 4: {
                        this.on_power(this.on_power() + direction);
                    }
                }
                if (this.on_power() < 1) {
                    this.on_power(1);
                }
                if ((block.config & 0x2000000000L) != 0L) {
                    ModAuxiliaries.playerStatusMessage(player, ModAuxiliaries.localizable("switchconfig.rainsensor.output_power", TextFormatting.RED, this.on_power()));
                } else {
                    ModAuxiliaries.playerStatusMessage(player, ModAuxiliaries.localizable("switchconfig.thundersensor.output_power", TextFormatting.RED, this.on_power()));
                }
            }
            this.func_70296_d();
            return true;
        }

        public void func_73660_a() {
            if (ModConfig.zmisc.without_environmental_switch_update) {
                return;
            }
            if (!this.func_145830_o() || this.func_145831_w().field_72995_K || --this.update_timer_ > 0) {
                return;
            }
            if (this.update_interval_ < 10) {
                this.update_interval_ = 10;
            }
            this.update_timer_ = this.update_interval_ + (int)(Math.random() * 5.0);
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            if (state == null || !(state.func_177230_c() instanceof BlockAutoSwitch)) {
                return;
            }
            BlockAutoSwitch block = (BlockAutoSwitch)state.func_177230_c();
            boolean active = (Boolean)state.func_177229_b((IProperty)BlockSwitch.POWERED);
            if ((block.config & 0x100000000L) != 0L) {
                long wt = this.field_145850_b.func_72820_D() % 24000L;
                double t = 6.25E-4 * (double)wt;
                boolean active_setpoint = false;
                if (this.threshold0_on() == this.threshold0_off()) {
                    active_setpoint = false;
                } else if (this.threshold0_on() < this.threshold0_off()) {
                    active_setpoint = t >= this.threshold0_on() && t <= this.threshold0_off();
                } else {
                    boolean bl = active_setpoint = t >= this.threshold0_on() && t <= 15.0 || t >= 0.0 && t <= this.threshold0_off();
                }
                if (active != active_setpoint) {
                    if (this.debounce() <= 0) {
                        active = active_setpoint;
                    } else {
                        double d1 = (1.0 - (double)this.debounce() / 9.0) * 0.7;
                        d1 *= d1;
                        if (Math.random() <= d1) {
                            active = active_setpoint;
                        }
                    }
                }
            } else if ((block.config & 0x1000000000L) != 0L) {
                if (this.threshold0_on() == 0.0 && this.threshold0_off() == 0.0) {
                    this.threshold0_on(7.0);
                    this.threshold0_off(6.0);
                } else {
                    double value = this.func_145831_w().func_175721_c(this.field_174879_c, false);
                    int measurement = 0;
                    if (this.threshold0_off() >= this.threshold0_on()) {
                        measurement += value == this.threshold0_on() ? 1 : -1;
                    } else {
                        if (value >= this.threshold0_on()) {
                            measurement = 1;
                        }
                        if (value <= this.threshold0_off()) {
                            measurement = -1;
                        }
                    }
                    if (this.debounce() <= 0) {
                        if (measurement != 0) {
                            active = measurement > 0;
                        }
                        this.debounce_counter_ = 0;
                    } else {
                        this.debounce_counter_ += measurement;
                        if (this.debounce_counter_ <= 0) {
                            active = false;
                            this.debounce_counter_ = 0;
                        } else if (this.debounce_counter_ >= this.debounce_) {
                            active = true;
                            this.debounce_counter_ = this.debounce_;
                        }
                    }
                }
            } else if ((block.config & 0x2000000000L) != 0L) {
                if (state.func_177229_b((IProperty)RsBlock.FACING) != EnumFacing.UP && state.func_177229_b((IProperty)RsBlock.FACING) != EnumFacing.DOWN) {
                    this.debounce_counter_ += this.func_145831_w().func_175727_C(this.func_174877_v().func_177967_a(EnumFacing.UP, 1)) ? 1 : -1;
                    if (this.debounce_counter_ <= 0) {
                        this.debounce_counter_ = 0;
                        active = false;
                    } else if (this.debounce_counter_ >= 4) {
                        this.debounce_counter_ = 4;
                        active = true;
                    }
                }
            } else if ((block.config & 0x4000000000L) != 0L) {
                this.debounce_counter_ += this.func_145831_w().func_72911_I() && (this.func_145831_w().func_175727_C(this.func_174877_v()) || this.func_145831_w().func_175727_C(this.func_174877_v().func_177967_a(EnumFacing.UP, 20))) ? 1 : -1;
                if (this.debounce_counter_ <= 0) {
                    this.debounce_counter_ = 0;
                    active = false;
                } else if (this.debounce_counter_ >= 4) {
                    this.debounce_counter_ = 4;
                    active = true;
                }
            }
            this.updateSwitchState(state, block, active, this.configured_on_time());
        }
    }

    public static class TileEntityDetectorSwitch
    extends TileEntityAutoSwitch
    implements ITickable {
        public static final Class<?>[] filter_classes = new Class[]{EntityLivingBase.class, EntityPlayer.class, EntityMob.class, EntityAnimal.class, EntityVillager.class, EntityItem.class, Entity.class};
        public static final String[] filter_class_names = new String[]{"creatures", "players", "mobs", "animals", "villagers", "objects", "everything"};
        private static final int max_sensor_range_ = 16;
        private int sensor_entity_count_threshold_ = 1;
        private int sensor_range_ = 5;
        private int filter_ = 0;
        private AxisAlignedBB area_ = null;
        private int update_interval_ = 8;
        private int update_timer_ = 0;

        public int filter() {
            return this.filter_;
        }

        public void filter(int sel) {
            this.filter_ = sel < 0 ? 0 : (sel >= filter_classes.length ? filter_classes.length - 1 : sel);
        }

        public Class<?> filter_class() {
            return this.filter_ <= 0 ? filter_classes[0] : (this.filter_ >= filter_classes.length ? filter_classes[filter_classes.length - 1] : filter_classes[this.filter_]);
        }

        public void sensor_entity_threshold(int count) {
            this.sensor_entity_count_threshold_ = count < 1 ? 1 : count;
        }

        public int sensor_entity_threshold() {
            return this.sensor_entity_count_threshold_;
        }

        public void sensor_range(int r) {
            this.sensor_range_ = r < 1 ? 1 : (r > 16 ? 16 : r);
        }

        public int sensor_range() {
            return this.sensor_range_;
        }

        @Override
        public void writeNbt(NBTTagCompound nbt, boolean updatePacket) {
            super.writeNbt(nbt, updatePacket);
            nbt.func_74768_a("range", this.sensor_range_);
            nbt.func_74768_a("entitythreshold", this.sensor_entity_count_threshold_);
            nbt.func_74768_a("filter", this.filter_);
        }

        @Override
        public void readNbt(NBTTagCompound nbt, boolean updatePacket) {
            super.readNbt(nbt, updatePacket);
            this.sensor_range(nbt.func_74762_e("range"));
            this.sensor_entity_threshold(nbt.func_74762_e("entitythreshold"));
            this.filter(nbt.func_74762_e("filter"));
        }

        @Override
        public void reset() {
            super.reset();
            this.update_timer_ = 0;
            this.area_ = null;
            this.sensor_range_ = 5;
            this.filter_ = 0;
        }

        @Override
        public boolean activation_config(IBlockState state, @Nullable EntityPlayer player, double x, double y) {
            int field;
            int direction;
            if (state == null) {
                return false;
            }
            int n = y >= 12.0 ? 1 : (direction = y <= 5.0 ? -1 : 0);
            int n2 = x >= 2.0 && x <= 3.95 ? 1 : (x >= 4.25 && x <= 7.0 ? 2 : (x >= 8.0 && x <= 10.0 ? 3 : (field = x >= 11.0 && x <= 13.0 ? 4 : 0)));
            if (direction == 0 || field == 0) {
                return false;
            }
            switch (field) {
                case 1: {
                    this.sensor_range(this.sensor_range() + direction);
                    this.area_ = null;
                    ModAuxiliaries.playerStatusMessage(player, ModAuxiliaries.localizable("switchconfig.detector.sensor_range", TextFormatting.BLUE, this.sensor_range()));
                    break;
                }
                case 2: {
                    this.sensor_entity_threshold(this.sensor_entity_threshold() + direction);
                    ModAuxiliaries.playerStatusMessage(player, ModAuxiliaries.localizable("switchconfig.detector.entity_threshold", TextFormatting.YELLOW, this.sensor_entity_threshold()));
                    break;
                }
                case 3: {
                    this.filter(this.filter() + direction);
                    ModAuxiliaries.playerStatusMessage(player, ModAuxiliaries.localizable("switchconfig.detector.entity_filter", TextFormatting.DARK_GREEN, new TextComponentTranslation("rsgauges.switchconfig.detector.entity_filter." + filter_class_names[this.filter()], new Object[0])));
                    break;
                }
                case 4: {
                    this.on_power(this.on_power() + direction);
                    if (this.on_power() < 1) {
                        this.on_power(1);
                    }
                    ModAuxiliaries.playerStatusMessage(player, ModAuxiliaries.localizable("switchconfig.detector.output_power", TextFormatting.RED, this.on_power()));
                }
            }
            this.func_70296_d();
            return true;
        }

        public void func_73660_a() {
            if (ModConfig.zmisc.without_detector_switch_update) {
                return;
            }
            if (this.func_145831_w().field_72995_K || --this.update_timer_ > 0) {
                return;
            }
            this.update_timer_ = this.update_interval_;
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            if (state == null || !(state.func_177230_c() instanceof BlockAutoSwitch)) {
                return;
            }
            BlockAutoSwitch block = (BlockAutoSwitch)state.func_177230_c();
            if (this.update_interval_ == 0) {
                this.update_interval_ = (block.config & 0x800000000L) != 0L ? ModConfig.tweaks.autoswitch_linear_update_interval : ModConfig.tweaks.autoswitch_volumetric_update_interval;
            }
            if (this.area_ == null) {
                int size = this.sensor_range();
                AxisAlignedBB range_bb = (block.config & 0x400000000L) != 0L ? new AxisAlignedBB(0.0, -2.0, (double)(-size), (double)size, 2.0, (double)size) : ((block.config & 0x800000000L) != 0L ? new AxisAlignedBB(-0.5, -0.5, -0.5, (double)size, 0.5, 0.5) : new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0, 0.0));
                EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)RsBlock.FACING);
                AxisAlignedBB bb = ModAuxiliaries.transform_forward(range_bb, facing).func_186670_a(this.func_174877_v()).func_72321_a(1.0, 1.0, 1.0);
                this.area_ = new AxisAlignedBB(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
            }
            boolean active = false;
            List hits = this.field_145850_b.func_72872_a(this.filter_class(), this.area_);
            if (hits.size() >= this.sensor_entity_count_threshold_) {
                int num_seen = 0;
                Vec3d switch_position = new Vec3d((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5);
                for (Entity e : hits) {
                    if (this.field_145850_b.func_147447_a(new Vec3d(e.field_70165_t - 0.2, e.field_70163_u + (double)e.func_70047_e(), e.field_70161_v - 0.2), switch_position, true, false, false) != null && this.field_145850_b.func_147447_a(new Vec3d(e.field_70165_t + 0.2, e.field_70163_u + (double)e.func_70047_e(), e.field_70161_v + 0.2), switch_position, true, false, false) != null || ++num_seen < this.sensor_entity_count_threshold_) continue;
                    active = true;
                    break;
                }
            }
            this.updateSwitchState(state, block, active, this.configured_on_time());
        }
    }

    public static class TileEntityAutoSwitch
    extends BlockSwitch.TileEntitySwitch {
        protected final void updateSwitchState(IBlockState state, BlockAutoSwitch block, boolean active, int hold_time) {
            if (active) {
                this.on_timer_reset(hold_time);
                if (!((Boolean)state.func_177229_b((IProperty)BlockSwitch.POWERED)).booleanValue()) {
                    if (this instanceof TileEntityIntervalTimerSwitch) {
                        ((TileEntityIntervalTimerSwitch)this).restart();
                    }
                    state = state.func_177226_a((IProperty)BlockSwitch.POWERED, (Comparable)Boolean.valueOf(true));
                    this.field_145850_b.func_180501_a(this.field_174879_c, state, 3);
                    block.power_on_sound.play(this.field_145850_b, this.field_174879_c);
                    this.field_145850_b.func_175685_c(this.field_174879_c, (Block)block, false);
                    this.field_145850_b.func_175685_c(this.field_174879_c.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)RsBlock.FACING)).func_176734_d()), (Block)block, false);
                    if ((block.config & 0x100000000000000L) != 0L && !this.activate_links(1)) {
                        ModResources.BlockSoundEvents.SWITCHLINK_LINK_PEAL_USE_FAILED.play(this.field_145850_b, this.field_174879_c);
                    }
                }
            } else if (((Boolean)state.func_177229_b((IProperty)BlockSwitch.POWERED)).booleanValue() && (hold_time <= 0 || this.on_time_remaining() <= 0)) {
                state = state.func_177226_a((IProperty)BlockSwitch.POWERED, (Comparable)Boolean.valueOf(false));
                this.field_145850_b.func_175656_a(this.field_174879_c, state);
                block.power_off_sound.play(this.field_145850_b, this.field_174879_c);
                this.field_145850_b.func_175685_c(this.field_174879_c, (Block)block, false);
                this.field_145850_b.func_175685_c(this.field_174879_c.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)RsBlock.FACING)).func_176734_d()), (Block)block, false);
                if ((block.config & 0x100000000000000L) != 0L && !this.activate_links(2)) {
                    ModResources.BlockSoundEvents.SWITCHLINK_LINK_PEAL_USE_FAILED.play(this.field_145850_b, this.field_174879_c);
                }
            }
        }
    }
}

