/*
 * Decompiled with CFR 0.152.
 */
package com.clussmanproductions.trafficcontrol.blocks;

import com.clussmanproductions.trafficcontrol.ModBlocks;
import com.clussmanproductions.trafficcontrol.ModItems;
import com.clussmanproductions.trafficcontrol.ModTrafficControl;
import com.clussmanproductions.trafficcontrol.blocks.BlockHorizontalPole;
import com.clussmanproductions.trafficcontrol.blocks.BlockSign;
import com.clussmanproductions.trafficcontrol.item.BaseItemTrafficLightFrame;
import com.clussmanproductions.trafficcontrol.tileentity.BaseTrafficLightTileEntity;
import com.clussmanproductions.trafficcontrol.util.CustomAngleCalculator;
import com.clussmanproductions.trafficcontrol.util.EnumTrafficLightBulbTypes;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class BlockBaseTrafficLight
extends Block {
    public static PropertyInteger ROTATION = PropertyInteger.func_177719_a((String)"rotation", (int)0, (int)15);
    public static PropertyBool VALIDHORIZONTALBAR = PropertyBool.func_177716_a((String)"validhorizontalbar");
    public static PropertyBool VALIDBACKBAR = PropertyBool.func_177716_a((String)"validbackbar");

    public BlockBaseTrafficLight(String name) {
        super(Material.field_151573_f);
        this.setRegistryName(name);
        this.func_149663_c("trafficcontrol." + name);
        this.func_149711_c(2.0f);
        this.setHarvestLevel("pickaxe", 2);
        this.func_149647_a(ModTrafficControl.CREATIVE_TAB);
    }

    public abstract void initModel();

    public int func_176201_c(IBlockState state) {
        return CustomAngleCalculator.rotationToMeta((Integer)state.func_177229_b((IProperty)ROTATION));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)ROTATION, (Comparable)Integer.valueOf(CustomAngleCalculator.metaToRotation(meta)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ROTATION, VALIDBACKBAR, VALIDHORIZONTALBAR});
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    public float func_185485_f(IBlockState state) {
        return 1.0f;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        boolean hasValidHorizontalBar = false;
        boolean hasValidBackBar = false;
        int rotation = (Integer)state.func_177229_b((IProperty)ROTATION);
        boolean isCardinal = CustomAngleCalculator.isCardinal(rotation);
        if (isCardinal) {
            if (CustomAngleCalculator.isNorth(rotation)) {
                hasValidHorizontalBar = BlockBaseTrafficLight.getValidStateForAttachableSubModels(worldIn.func_180495_p(pos.func_177976_e()), EnumFacing.WEST, EnumFacing.EAST) || BlockBaseTrafficLight.getValidStateForAttachableSubModels(worldIn.func_180495_p(pos.func_177974_f()), EnumFacing.WEST, EnumFacing.EAST);
                hasValidBackBar = BlockBaseTrafficLight.getValidStateForAttachableSubModels(worldIn.func_180495_p(pos.func_177978_c()), EnumFacing.NORTH, EnumFacing.SOUTH);
            } else if (CustomAngleCalculator.isSouth(rotation)) {
                hasValidHorizontalBar = BlockBaseTrafficLight.getValidStateForAttachableSubModels(worldIn.func_180495_p(pos.func_177976_e()), EnumFacing.WEST, EnumFacing.EAST) || BlockBaseTrafficLight.getValidStateForAttachableSubModels(worldIn.func_180495_p(pos.func_177974_f()), EnumFacing.WEST, EnumFacing.EAST);
                hasValidBackBar = BlockBaseTrafficLight.getValidStateForAttachableSubModels(worldIn.func_180495_p(pos.func_177968_d()), EnumFacing.NORTH, EnumFacing.SOUTH);
            } else if (CustomAngleCalculator.isWest(rotation)) {
                hasValidHorizontalBar = BlockBaseTrafficLight.getValidStateForAttachableSubModels(worldIn.func_180495_p(pos.func_177978_c()), EnumFacing.NORTH, EnumFacing.SOUTH) || BlockBaseTrafficLight.getValidStateForAttachableSubModels(worldIn.func_180495_p(pos.func_177968_d()), EnumFacing.NORTH, EnumFacing.SOUTH);
                hasValidBackBar = BlockBaseTrafficLight.getValidStateForAttachableSubModels(worldIn.func_180495_p(pos.func_177976_e()), EnumFacing.WEST, EnumFacing.EAST);
            } else if (CustomAngleCalculator.isEast(rotation)) {
                hasValidHorizontalBar = BlockBaseTrafficLight.getValidStateForAttachableSubModels(worldIn.func_180495_p(pos.func_177978_c()), EnumFacing.NORTH, EnumFacing.SOUTH) || BlockBaseTrafficLight.getValidStateForAttachableSubModels(worldIn.func_180495_p(pos.func_177968_d()), EnumFacing.NORTH, EnumFacing.SOUTH);
                hasValidBackBar = BlockBaseTrafficLight.getValidStateForAttachableSubModels(worldIn.func_180495_p(pos.func_177974_f()), EnumFacing.WEST, EnumFacing.EAST);
            }
        }
        return state.func_177226_a((IProperty)VALIDHORIZONTALBAR, (Comparable)Boolean.valueOf(hasValidHorizontalBar)).func_177226_a((IProperty)VALIDBACKBAR, (Comparable)Boolean.valueOf(hasValidBackBar));
    }

    public static boolean getValidStateForAttachableSubModels(IBlockState state, EnumFacing ... validFacings) {
        if (state.func_177230_c() == ModBlocks.horizontal_pole) {
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockHorizontalPole.FACING);
            if (Arrays.stream(validFacings).anyMatch(f -> f.equals((Object)facing))) {
                return true;
            }
        }
        if (state.func_177230_c() == ModBlocks.crossing_gate_pole) {
            return true;
        }
        if (state.func_177230_c() instanceof BlockBaseTrafficLight) {
            int rotation = (Integer)state.func_177229_b((IProperty)ROTATION);
            if (!CustomAngleCalculator.isCardinal(rotation)) {
                return false;
            }
            EnumFacing facing = CustomAngleCalculator.getFacingFromRotation(rotation);
            return Arrays.stream(validFacings).noneMatch(f -> f == facing);
        }
        if (state.func_177230_c() == ModBlocks.sign) {
            int signRotation = (Integer)state.func_177229_b((IProperty)BlockSign.ROTATION);
            if (!CustomAngleCalculator.isCardinal(signRotation)) {
                return false;
            }
            EnumFacing facing = CustomAngleCalculator.getFacingFromRotation(signRotation);
            return Arrays.stream(validFacings).noneMatch(vf -> vf.equals((Object)facing));
        }
        return false;
    }

    private ItemStack getItemVersionOfBlock(IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof BaseTrafficLightTileEntity)) {
            return new ItemStack((Item)this.getItemVersionOfBlock());
        }
        BaseTrafficLightTileEntity trafficLight = (BaseTrafficLightTileEntity)tileEntity;
        ItemStack frameStack = new ItemStack((Item)this.getItemVersionOfBlock());
        IItemHandler handler = (IItemHandler)frameStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        NBTTagCompound stackCompound = frameStack.func_77978_p();
        if (stackCompound == null) {
            stackCompound = new NBTTagCompound();
            frameStack.func_77982_d(stackCompound);
        }
        for (int i = 0; i < this.getItemVersionOfBlock().getBulbCount(); ++i) {
            EnumTrafficLightBulbTypes bulbTypeInSlot = trafficLight.getBulbTypeBySlot(i);
            if (bulbTypeInSlot == null) {
                handler.insertItem(i, ItemStack.field_190927_a, false);
            } else {
                handler.insertItem(i, new ItemStack((Item)ModItems.traffic_light_bulb, 1, bulbTypeInSlot.getIndex()), false);
            }
            stackCompound.func_74757_a("always-flash-" + i, trafficLight.getAllowFlashBySlot(i));
        }
        frameStack.func_77982_d(frameStack.func_77973_b().getNBTShareTag(frameStack));
        return frameStack;
    }

    protected abstract BaseItemTrafficLightFrame getItemVersionOfBlock();

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return this.getItemVersionOfBlock((IBlockAccess)world, pos);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.add((Object)this.getItemVersionOfBlock(world, pos));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public abstract TileEntity createTileEntity(World var1, IBlockState var2);

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof BaseTrafficLightTileEntity && ((BaseTrafficLightTileEntity)te).anyActive()) {
            return 15;
        }
        return 0;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (!(state.func_177230_c() instanceof BlockBaseTrafficLight)) {
            return field_185505_j;
        }
        int rotation = (Integer)state.func_177229_b((IProperty)ROTATION);
        switch (rotation) {
            case 0: {
                return new AxisAlignedBB(0.1875, -0.3125, 0.4375, 0.8125, 1.0, 0.75);
            }
            case 8: {
                return new AxisAlignedBB(0.1875, -0.3125, 0.25, 0.8125, 1.0, 0.5625);
            }
            case 4: {
                return new AxisAlignedBB(0.25, -0.3125, 0.1875, 0.5625, 1.0, 0.8125);
            }
            case 12: {
                return new AxisAlignedBB(0.4375, -0.3125, 0.1875, 0.75, 1.0, 0.8125);
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                return new AxisAlignedBB(0.375, 0.0, 0.375, 0.75, 1.0, 0.75);
            }
            case 2: 
            case 6: 
            case 10: 
            case 14: {
                return new AxisAlignedBB(0.2, 0.0, 0.2, 0.8, 1.0, 0.8);
            }
        }
        return field_185505_j;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        worldIn.func_175698_g(pos);
    }
}

